! =======================================================================
!
! Copyright Centre National de la Recherche Scientifique (CNRS)
!
! [Institut des Geosciences de l'Environnement (IGE) & Laboratoire des
! Sciences du climat et de l'Environnement (LSCE)]
!
! contributor(s): C. Ritz, A. Quiquet, C. Dumas, V. Peyaud, V. Rommelaere,
! A. Fabre, N. Lhomme (2018)
!
! contacts:
! C.R.: catherine.ritz@univ-grenoble-alpes.fr
! C.D.: christophe.dumas@lsce.ipsl.fr
! A.Q.: aurelien.quiquet@lsce.ipsl.fr
!
! This file: [tracer_vars_mod.f90]
! is part of the GRISLI (GRenoble Ice-Shelf and Land-Ice model)
! software, a computer program whose purpose is to compute the evolution
! of ice thickness coupled to three-dimensional ice temperature and
! velocity fields given a mass-balance scenario.
!
! This software is governed by the CeCILL license under French law and
! abiding by the rules of distribution of free software.  You can  use,
! modify and/ or redistribute the software under the terms of the CeCILL
! license as circulated by CEA, CNRS and INRIA at the following URL
! "http://www.cecill.info".
!
! As a counterpart to the access to the source code and  rights to copy,
! modify and redistribute granted by the license, users are provided only
! with a limited warranty  and the software's author,  the holder of the
! economic rights,  and the successive licensors  have only  limited
! liability.
!
! In this respect, the user's attention is drawn to the risks associated
! with loading,  using,  modifying and/or developing or reproducing the
! software by the user in light of its specific status of free software,
! that may mean  that it is complicated to manipulate,  and  that  also
! therefore means  that it is reserved for developers  and  experienced
! professionals having in-depth computer knowledge. Users are therefore
! encouraged to load and test the software's suitability as regards their
! requirements in conditions enabling the security of their systems and/or
! data to be ensured and,  more generally, to use and operate it in the
! same conditions as regards security.
!
! The fact that you are presently reading this means that you have had
! knowledge of the CeCILL license and that you accept its terms.
!
! ======================================================================


!   tracer parameters and arrays
!   try to minimize use of allocatable arrays

module tracer_vars
  
  use module3d_phy
  
  implicit none
  save
  
  integer, dimension(nx*ny) :: ix, jx
  
  !! The integer array indx_tr(i,j) yields an index value which is the
  !! ij subscript of the tracer archive array archive_tr(:,:,:)
  
  integer :: nij                 ! number of (i,j)->ij mappings
  
  integer, parameter :: unit_tr_dat=572
  integer, parameter :: unit_tr_out=573
  integer, parameter :: unit_tr_dep=574
  
  integer, parameter :: maxspectimes=31
  
  integer :: delttrout
  integer :: nspectimes
  real :: time_max_accu

  ! afq marion dufresne: tracer with no climat perturb
  ! i.e. we read the Forcage Tpert to compute past accumulation via
  ! rappact
  ! OR we read directly past accum (choice in namelist)
  ! if past accum is given it will still be read with the name Tpert
  ! the past accum given should be the ratio acc_palaeo / acc_present
  integer :: nft_tra                         ! number of snapshot Tpert
  integer :: type_accum                      ! Tpert is given (=0) or accpert (1)
  real    :: rappact_tra                     ! accumulation ratio to convert Tpert
  real    :: coeft_tra                       ! coeft to convert Tpert
  real,dimension(:),allocatable :: tpert_tra ! temperature perturbation
  real,dimension(:),allocatable :: tdate_tra ! time for Tpert

  
  integer, dimension(maxspectimes) :: trout
  real, dimension(nx) :: xgrid
  real, dimension(ny) :: ygrid
  
  real , dimension(nx*ny) :: TS_save
  real , dimension(nx*ny) :: hi_save
  real , dimension(nx*ny) :: bi_save

      !! Traced scalars (xd, yd, td) for sheet
      !! (deposition point and deposition time) for present and previous times

! dep, tableau (grille 'o') "origine de la glace" au temp time
  real , dimension(nz,nx-2,ny-2) :: xdep
  real , dimension(nz,nx-2,ny-2) :: ydep
  real , dimension(nz,nx-2,ny-2) :: tdep

! dep, tableau (grille 'o') "origine de la glace"  a l'initialisation (a confirmer)
  real , dimension(nz,nx-2,ny-2) :: xdepk    ! 
  real , dimension(nz,nx-2,ny-2) :: ydepk    !
  real , dimension(nz,nx-2,ny-2) :: tdepk    !

! dep, tableau (grille 'o') "origine de la glace" au temp time, dimension pour outputs
  real , dimension(nx,ny,nz) :: xdep_out
  real , dimension(nx,ny,nz) :: ydep_out
  real , dimension(nx,ny,nz) :: tdep_out

  real , dimension(nz) :: lnzeta

  character (LEN=60) :: file_tr_dat, file_tr_out, file_tr_dep
  
  real , dimension(nx,ny,nz) :: uxsave
  real , dimension(nx,ny,nz) :: uysave
  real , dimension(nx,ny,nz) :: uzrsave
  
  real , allocatable, dimension(:) :: accucumul

  real, dimension(nx-2,ny-2) :: freezeon


end module tracer_vars

