! =======================================================================
!
! Copyright Centre National de la Recherche Scientifique (CNRS)
!
! [Institut des Geosciences de l'Environnement (IGE) & Laboratoire des
! Sciences du climat et de l'Environnement (LSCE)]
!
! contributor(s): C. Ritz, A. Quiquet, C. Dumas, V. Peyaud, V. Rommelaere,
! A. Fabre, N. Lhomme (2018)
!
! contacts:
! C.R.: catherine.ritz@univ-grenoble-alpes.fr
! C.D.: christophe.dumas@lsce.ipsl.fr
! A.Q.: aurelien.quiquet@lsce.ipsl.fr
!
! This file: [tracer_mod.f90]
! is part of the GRISLI (GRenoble Ice-Shelf and Land-Ice model)
! software, a computer program whose purpose is to compute the evolution
! of ice thickness coupled to three-dimensional ice temperature and
! velocity fields given a mass-balance scenario.
!
! This software is governed by the CeCILL license under French law and
! abiding by the rules of distribution of free software.  You can  use,
! modify and/ or redistribute the software under the terms of the CeCILL
! license as circulated by CEA, CNRS and INRIA at the following URL
! "http://www.cecill.info".
!
! As a counterpart to the access to the source code and  rights to copy,
! modify and redistribute granted by the license, users are provided only
! with a limited warranty  and the software's author,  the holder of the
! economic rights,  and the successive licensors  have only  limited
! liability.
!
! In this respect, the user's attention is drawn to the risks associated
! with loading,  using,  modifying and/or developing or reproducing the
! software by the user in light of its specific status of free software,
! that may mean  that it is complicated to manipulate,  and  that  also
! therefore means  that it is reserved for developers  and  experienced
! professionals having in-depth computer knowledge. Users are therefore
! encouraged to load and test the software's suitability as regards their
! requirements in conditions enabling the security of their systems and/or
! data to be ensured and,  more generally, to use and operate it in the
! same conditions as regards security.
!
! The fact that you are presently reading this means that you have had
! knowledge of the CeCILL license and that you accept its terms.
!
! ======================================================================


!> module appele par le main (step) qui calcule les traceurs
!!  @todo depuis tracer_mod, decider e() en local ou global 
!!  @todo attention l'appel au module climat est en dur 
!!    et peut poser des pb si different du module choix.

!--------------------------------------------------------------
! Position des forages dans la grille grisli.
! Groenland grille GreeneemXX
!
! Ordre GMT : 
! mapproject  -Js-39/90/71/1:50000000 -Fk -R/-150/50/50/85 -C
!
! NEEM : -50.9E 77.5N  -> -281.129 / -1334.05
!  5km:  ineem=143 /jneem=437 
!  15km: ineem=48 / jneem=146
!  45km: ineem=16 / jneem=49
!
! GRIP : -37.633333E 72.583333N -> 45.4707 / -1905.94
!  5km:  igrip=208 /jgrip=323
!  15km: igrip=70 / jgrip=108 ! grosso modo
!  45km: igrip=24 / jgrip=36  ! grosso modo
!
!--------------------------------------------------------------



module tracer_mod

  use module3d_phy
  use tracer_vars             ! module de declaration de variables pour les traceurs
!cdc  use climat_perturb_mois_mod ! on en a besoin, notamment pour NFT
! afq, new version of tracer, does not require climat_perturb
  
  implicit none

! variables de travail
  integer :: i_ij, i_jj, ip, jp, im, jm, km      ! indice dans les matrices des traceurs
  real    :: v_xij, v_yij, v_zij                 ! vitesses 'cumulees'

! pour chaque point de grille on recherche ou etait la particule au pas de temps precedent
! Tout ce qui est mentionne traceur est lie aux proprietes de ce point

  real    :: x_tra                               ! position x du traceur  
  real    :: y_tra                               ! position y du traceur
  real    :: e_tra                               ! position verticale du traceur 

! ecart entre la position du traceur et le point de grille grisli le plus proche
  real    :: fx                                  ! ecart en x
  real    :: fy                                  ! ecart en y
  real    :: fz                                  ! ecart vertical ? (z ou sigma ?) 

  integer :: deltracer   ! pas de temps du traceur ?  -> dans la version d'origine tracer est appele tous les dtt
  integer :: time_tra    ! temps traceur


!===============================================================

  
contains

subroutine init_tracer

! formats pour les ecritures dans 42
428 format(A)

  real :: lambdab  ! fusion basale 'artificielle' pour age des couches 
  real :: agemax   ! age maximum de la glace (pour init_tracer)

  integer :: pert_type ! 0 we give tpert/coeft/rappact,1 we give acc_pert only / afq
  character(len=200) :: filforc    ! nom du fichier forcage
  character(len=200) :: filin      ! variable intermediaire
  character(len=8) :: control      ! label to check clim. forc. file (filin) is usable
  integer ::  err                  ! pour l'allocation des tableaux
  real :: bidon                    ! to skip sealevel change in fileforc
  
  integer :: kk   ! indice vertical pour definition de E, mais on veut conserver la valeur de k
!  real,dimension(nz) :: E   ! vertical coordinate in ice, scaled to H zeta

  ! on lit les parametres par namelist dorenavant
  namelist/tracer/file_tr_dat,file_tr_out,file_tr_dep,lambdab,agemax,coefT_tra,rappact_tra,filforc,pert_type 


if (itracebug.eq.1) write(num_tracebug,*)'init_tracer dans tracer_mod'

! itracer pour les ecritures et lectures recovery
 itracer = 1

! profondeur reduite
  E(1)=0.
  E(NZ)=1.
  do KK=1,NZ
     if ((KK.ne.1).and.(KK.ne.NZ)) E(KK)=(KK-1.)/(NZ-1.)
  end do


if (itracebug.eq.1) write(num_tracebug,*)'init_tracer dans tracer_mod'

  time_tra = floor(time) 

  deltracer = dtt           ! sorte de pas de temps du tracer -  multiple de dtt !


  rewind(num_param)        ! pour revenir au debut du fichier param_list.dat
  read(num_param,tracer)
  print*
  print*
  print*, 'tracer .dat file: ', file_tr_dat
  print*, 'tracer .out file: ', file_tr_out
  print*, 'tracer dep. file: ', file_tr_dep


  write(num_rep_42,428)'!___________________________________________________________' 
  write(num_rep_42,428) '&tracer                                    ! module tracer_mod'
  write(num_rep_42,'(A,A)')   'tracer .dat file : ', file_tr_dat
  write(num_rep_42,'(A,A)')   'tracer .out file : ', file_tr_out
  write(num_rep_42,'(A,A)')   'tracer dep. file : ', file_tr_dep
  write(num_rep_42,'(A,A)')   'lambdab : ', lambdab
  write(num_rep_42,'(A,A)')   'agemax : ', agemax
  write(num_rep_42,'(A,A)')   'coefT_tra : ', coefT_tra
  write(num_rep_42,'(A,A)')   'rappact_tra : ', rappact_tra
  write(num_rep_42,'(A,A)')   'fileforc : ', filforc
  write(num_rep_42,'(A,A)')   'pert_type : ', pert_type
  write(num_rep_42,*)'/'                      
  write(num_rep_42,428) 'declaration des repertoires *traceurs*'
  write(num_rep_42,*)

! on appelle la soubroutine qui lit le fichier .dat des traceurs
! ce fichier contient les dates de sorties des traceurs
  call read_tr_dat ! intervalles d'output

  nij = nx * ny

! initialize "previous" tracer arrays as if all ice at start
! time was created instantaneously and in-place

! attention pourquoi ne pas utiliser xcc et ycc ?
!!$  do i=1,nx
!!$     xgrid(i) = (i- (nx+1)/2. ) * dx
!!$  end do
!!$  do j=1,ny
!!$     ygrid(j) = (j - (ny+1)/2.) * dy
!!$  end do

! notre grille a nous
  do i=1,nx
     xgrid(i)=xmin*1000+(i-1)*dx
  end do
  do j=1,ny
     ygrid(j)=ymin*1000+(j-1)*dy
  end do
  
! initialisation des abscisses et ordonnees a la valeur en surface
! initialisation de l'age 
  do j=2,ny-1
     i_jj = j-1
     ydepk(:,:,i_jj) = ygrid(j) 
     do i=2,nx-1
        i_ij = i-1
        xdepk(:,i_ij,i_jj) = xgrid(i)

! todo0710
! remplacer par une formule logarithmique
! 10**-4 m/an fusion basale (ou valeur de lambda a la base)
! + agemax 1 million d'annees

!!$        if (h(i,j)>10.) then
!!$           do k=1,4 
!!$              tdepk(k,i_ij,i_jj) = - min(3500., h(i,j)) *real((k-1)**2)
!!$           end do
!!$           do k=5,nz
!!$              tdepk(k,i_ij,i_jj) = - min(3500., h(i,j)) *real((k-1)*3)
!!$           end do
!!$           do k=12,nz
!!$              tdepk(k,i_ij,i_jj) = tdepk(k,i_ij,i_jj) * (real(11) + real((k-7)**3)/125. )/12.
!!$           end do
!!$        else
!!$           tdepk(:,i_ij,i_jj) = 0.
!!$        end if
!!$     end do
!!$  end do
!!$
!!$   
!!$! a enlever eventuellement si on utilise le log
!!$  do j=1,ny-2
!!$     do i=1,nx-2
!!$        if (((tdepk(20,i,j)-tdepk(21,i,j))<1000.)) then
!!$           if ((h(i,j)>100.))  then
!!$              tdepk(21,i,j)=tdepk(20,i,j)-10*h(i,j)
!!$           else
!!$              tdepk(21,i,j)=tdepk(20,i,j)- 1000.
!!$           end if
!!$        end if
!!$     end do
!!$  end do
!!$   
        do k=1,nz
           if(acc(i,j).gt.lambdab) then
              tdepk(k,i_ij,i_jj)=H(i,j)*log(    &
                   1-E(k)*(1-lambdab/ACC(i,j)))/(ACC(i,j)-lambdab)
           else
              tdepk(k,i_ij,i_jj)=0.
           end if
        end do

     end do
  end do

  where (tdepk(:,:,:).ge.agemax)
     tdepk(:,:,:)=agemax
  end where
  tdepk(:,:,:) = tdepk(:,:,:) + tbegin


  ! afq marion dufresne:
  ! to build accucumul, we read all what is in climat_perturb here now
  ! meaning: nft, tpert, tdate
  ! OR if pert_type = 1 we read nft, acc_pert, tdate
  ! acc_pert should be the ratio acc_palaeo / acc_present
  
    filin=trim(dirforcage)//trim(filforc)

    open(num_forc,file=filin,status='old')

    read(num_forc,*) control,nft_tra

    ! Determination of file size (line nb), allocation of perturbation array
    if (control.ne.'nb_lines') then
       write(6,*) filin,'indiquer le nb de ligne en debut de fichier:'
       write(6,*) 'le nb de lignes et le label de control nb_lines'
       stop
    endif
    if (.not.allocated(tdate_tra)) then
       allocate(tdate_tra(nft_tra),stat=err)
       if (err/=0) then
          print *,"erreur a l'allocation du tableau Tdate",err
          stop 4
       end if
    end if
    if (.not.allocated(tpert_tra)) then
       allocate(tpert_tra(nft_tra),stat=err)
       if (err/=0) then
          print *,"erreur a l'allocation du tableau Tpert",err
          stop 4
       end if
    end if

    do i=1,nft_tra
       read(num_forc,*) tdate_tra(i),bidon,tpert_tra(i)
    end do
    close(num_forc)

  
 2009 format(21(f12.1))
   
   ! prepares accu-cumul variable for accu-interp

  ! note aurel neem : ATTENTION ! dans version NL ->
  ! chaque indice d'accucumul vaut 100 ans.
  ! 0 pour le present, 10 pour 1000 ans
   allocate(accucumul(0:nft_tra-1)); accucumul = 0.0
   ! watch out its size !!!
   ! note: tpert(1) = tpert at -422700yr
   ! nl 12/08/02: attention au param de l'exp(): doit etre coherent avec le
   ! forcage climatique: ici, change de 0.062 a 0.100
   ! attention a ce que nft <=> present, sinon mon indexage est fourr
   ! a la rigueur je pourrais modifier le fichier d'interpolation pour 
   ! l'adapter a tdate
   accucumul(nft_tra-1) =  0.

   ! todo0710 : marge d'amelioration en tenant compte des accum de depot ?

   if (type_accum.eq.0) then   !Tpert is given, needs to be converted in accumulation ratio
      tpert_tra(:)=tpert_tra(:)*coefT_tra
      do k=2,nft_tra
         accucumul(nft_tra-k) = accucumul(nft_tra-k+1) + (exp(rappact_tra  * tpert_tra(k) ))
      end do
   else if (type_accum.eq.1) then ! accum ration is given, nothing to do
      do k=2,nft_tra
         accucumul(nft_tra-k) = accucumul(nft_tra-k+1) + tpert_tra(k)
      end do
   else
      write (*,*) "Problem in tracer, do you provide tpert or accpert???"
      STOP
   end if
   time_max_accu = tdate_tra(1)
   uxsave(:,:,:) = 0.0
   uysave(:,:,:) = 0.0
   uzrsave(:,:,:) = 0.0
   xdep(:,:,:)=xdepk(:,:,:)
   ydep(:,:,:)=ydepk(:,:,:)
   tdep(:,:,:)=tdepk(:,:,:)
   freezeon(:,:) = 0.     ! variable added on 19/03/03

   print*, 'tbegin, tend : ',tbegin, tend

end subroutine init_tracer


subroutine tracer

  real,dimension(nz) :: E   ! vertical coordinate in ice, scaled to H zeta

  E(1)=0.
  E(NZ)=1.
  do K=1,NZ
     if ((K.ne.1).and.(K.ne.NZ)) E(K)=(K-1.)/(NZ-1.)
  end do

  If (Itracebug.Eq.1) Write(num_tracebug,*)' Entree Dans Routine tracer at time=',Time

   time_tra = floor(time) 
      !! start of main task
      ! main calculation loop omits the outer buffer cells.  update here.

  !===== accucumulative velocities
  
     uxsave(:,:,:) = uxsave(:,:,:) + ux(:,:,:)*real(dtt)  ! todo0710 mettre les tableaux
     uysave(:,:,:) = uysave(:,:,:) + uy(:,:,:)*real(dtt)  ! attention uxsave position en maille staggered
                                     ! ATTENTION, il faudrait deltra pas dtt, SIGNE ?
     do j=1,ny
        do i=1,nx
           ! added on 16/12/03: somehow worked before too
           if (h(i,j)>1.5) &
             uzrsave(i,j,:) = uzrsave(i,j,:) + uzr(i,j,:) *real(dtt) / h(i,j)
        end do
     end do

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

! recalcul de accucumul d'aprs les valeurs courantes pour
!reconstruire accucumul de faon interactive. utile pour une calotte
! qui varie beaucoup en gomtrie.

!if (mod(time_tra,100)==0) then
!       update accu, rewriting on top of the older value
!       i=-time_tra/100
!       accucumul(i) = accucumul(i+1) + acc(105,49)/ 0.0295
!end if

  if (mod(time_tra,deltracer)==0) then
     
     !============ east and west boundaries
     do j=2,ny-1
        i_jj = j-1
        xdep(:,1,i_jj) = xgrid(2)
        xdep(:,nx-2,i_jj) = xgrid(nx-1)
        ydep(:,1,i_jj) = ygrid(j)
        ydep(:,nx-2,i_jj) = ygrid(j)
!        tdep(:,1,i_jj) = time_
!        tdep(:,nx-2,i_jj) = time_
        tdep(:,1,i_jj) = time    
        tdep(:,nx-2,i_jj) = time 
     end do
      !=========== north and south boundaries
     do i=2,nx-1
        i_ij = i-1
        xdep(:,i_ij,1) = xgrid(i)
        xdep(:,i_ij,ny-2) = xgrid(i)
        ydep(:,i_ij,1) = ygrid(2)
        ydep(:,i_ij,ny-2) = ygrid(ny-1)
!	tdep(:,i_ij,1) =  time_
!	tdep(:,i_ij,ny-2) =  time_
        tdep(:,i_ij,1) =  time   
        tdep(:,i_ij,ny-2) =  time
     end do

     
      !============= inside grid: now watch out: (i,j) dyn-grid <=> (i_ij, i_jj) tracer-grid
      do j=3,ny-2
        do i=3,nx-2
          i_ij = i-1
          i_jj = j-1

! nl 11/03/04
          if (h(i,j)<=1.5) then
            xdep(:,i_ij,i_jj) = xgrid(i)
            ydep(:,i_ij,i_jj) = ygrid(j)
            tdep(:,i_ij,i_jj) =  time  
            cycle
          end if
          freezeon(i_ij,i_jj) = max(0.0, freezeon(i_ij,i_jj)-bmelt(i,j) )
          
          ip = i+1
          jp = j+1
          do k=1,nz
            v_xij       = (uxsave(i,j,k)+uxsave(ip,j,k)) / real(2)
            v_yij       = (uysave(i,j,k)+uysave(i,jp,k)) / real(2)
            v_zij       = uzrsave(i,j,k)

            x_tra       = xgrid(i) - v_xij      !* real(deltracer)
            y_tra       = ygrid(j) - v_yij      !* real(deltracer)
            e_tra       = e(k) - v_zij          !* real(deltracer)

            if ((k==nz).and.(bmelt(i,j)<-1.e-4)) then   ! bottom freezeon
               xdep(k,i_ij,i_jj) = xgrid(i)
               ydep(k,i_ij,i_jj) = ygrid(j)
               if (h(i,j)>100.) then
                 tdep(k,i_ij,i_jj) =  tdepk(k,i_ij,i_jj) - &
                        min( abs( (tdepk(k-1,i_ij,i_jj)-tdepk(k,i_ij,i_jj)) *  &
                          bmelt(i,j)  / ( ( e(k)-e(k-1) )*h(i,j) ) ), 2.) * deltracer
                  ! this added 26/03/04 so that not more 2.*deltracer new years of refreezing 
               else
                 tdep(k,i_ij,i_jj) =  tdepk(k,i_ij,i_jj)
                 
               end if 
                !fix:    need to track where freeze-on happens
                ! *1.001	proven to be dumb
!               if((tdep(k,i_ij,i_jj)<=time_  -  1500000.) .or. (tdep(k,i_ij,i_jj)>=tend+1.0)) then
               if((tdep(k,i_ij,i_jj)<=time  -  1500000.) .or. (tdep(k,i_ij,i_jj)>=tend+1.0)) then 
                  print *,"tdep(",k,",",i_ij,",",i_jj,") range error at time=",time_tra
                   print *,"tdep(k,i_ij,i_jj) =",tdep(k,i_ij,i_jj), v_xij, v_yij, v_zij
                   print *, bmelt(i,j), s(i,j), h(i,j), e_tra, tdepk(k,i_ij,i_jj), tdepk(k,i,j)
                   print *, flot(im,jm), flot(im+1,jm), flot(im+1,jm+1), flot(im,jm+1)
                   if (k>1) tdep(k,i_ij,i_jj) = tdepk(k-1,i_ij,i_jj) - real(h(i,j)*(k-1)**2/30.)
                   print *, tdep(k,i_ij,i_jj)
                end if

             else if (k==1 .and. bm(i,j)>0.0) then	  !! surface mass balance
              xdep(k,i_ij,i_jj) = xgrid(i)
              ydep(k,i_ij,i_jj) = ygrid(j)
              tdep(k,i_ij,i_jj) =  time  
            else if ( e_tra < e(1) ) then   		!! rapid thickening by
              xdep(k,i_ij,i_jj) = xgrid(i)        			!! surface accumulation
              ydep(k,i_ij,i_jj) = ygrid(j)
              tdep(k,i_ij,i_jj) =  time   
           else
                call celltest(time_tra,i,j,k,v_xij, v_yij, v_zij, x_tra, y_tra, e_tra, &
                		im,jm,km,fx,fy,fz)
        	!! convert seach results from (i,j) grid to (i_ij,i_jj) tracer grid
                !print*,'i,j,k avt interp',i,j,k

                call interpolate(i_ij, i_jj, k, im-1, jm-1, km, fx,fy,fz, e_tra, nft_tra) 

                if((tdep(k,i_ij,i_jj)<=time  -  1500000.) .or. (tdep(k,i_ij,i_jj)> time   )) then
                   print *,"tdep(",k,",",i_ij,",",i_jj,") range error at time=",time_tra
                   print *,"tdep(k,i_ij,i_jj) =",tdep(k,i_ij,i_jj), v_xij, v_yij, v_zij
		   print *, bmelt(i,j), s(i,j), h(i,j), e_tra, tdepk(k,i_ij,i_jj), tdepk(k,i,j)
		   print *, flot(im,jm), flot(im+1,jm), flot(im+1,jm+1), flot(im,jm+1) 
		   if (k>1) tdep(k,i_ij,i_jj) = tdepk(k-1,i_ij,i_jj) - real(h(i,j)*(k-1)**2/30.)
		   print *, tdep(k,i_ij,i_jj) 
                end if

            end if

          end do
        end do
      end do

      xdepk(:,:,:) = xdep(:,:,:)
      ydepk(:,:,:) = ydep(:,:,:)
      tdepk(:,:,:) = tdep(:,:,:)
      uxsave = 0.00
      uysave = 0.00
      uzrsave = 0.00

   end if !========== if deltracer

   if (abs(time-tend)<19) then   
      open(505,file="freezeonmap.out",status="replace")
      print*,"save freezeon file"
      write(505,  * ) freezeon
      close(505)
      print *, tdep(:,70,70)
   end if

! aurel neem -> je me cree une version formatte "out" pour les sorties
! on traite d'abord les 4 coins
xdep_out(1,1,:)=xdep(:,1,1)
xdep_out(nx,1,:)=xdep(:,nx-2,1)
xdep_out(nx,ny,:)=xdep(:,nx-2,ny-2)
xdep_out(1,ny,:)=xdep(:,1,ny-2)
ydep_out(1,1,:)=ydep(:,1,1)
ydep_out(nx,1,:)=ydep(:,nx-2,1)
ydep_out(nx,ny,:)=ydep(:,nx-2,ny-2)
ydep_out(1,ny,:)=ydep(:,1,ny-2)
tdep_out(1,1,:)=tdep(:,1,1)
tdep_out(nx,1,:)=tdep(:,nx-2,1)
tdep_out(nx,ny,:)=tdep(:,nx-2,ny-2)
tdep_out(1,ny,:)=tdep(:,1,ny-2)
! puis les bords Ouest et Est
do i=2,nx-1
   xdep_out(i,1,:)=xdep(:,i-1,1)
   xdep_out(i,ny,:)=xdep(:,i-1,ny-2)
   ydep_out(i,1,:)=ydep(:,i-1,1)
   ydep_out(i,ny,:)=ydep(:,i-1,ny-2)
   tdep_out(i,1,:)=tdep(:,i-1,1)
   tdep_out(i,ny,:)=tdep(:,i-1,ny-2)
end do
! et les bords Sud et Nord
do j=2,ny-1
   xdep_out(1,j,:)=xdep(:,1,j-1)
   xdep_out(nx,j,:)=xdep(:,nx-2,j-1)
   ydep_out(1,j,:)=ydep(:,1,j-1)
   ydep_out(nx,j,:)=ydep(:,nx-2,j-1)
   tdep_out(1,j,:)=tdep(:,1,j-1)
   tdep_out(nx,j,:)=tdep(:,nx-2,j-1)
end do
! et enfin on complete l'interieur
do k=1,nz
   do j=2,ny-1
      do i=2,nx-1
         xdep_out(i,j,k)=xdep(k,i-1,j-1)
         ydep_out(i,j,k)=ydep(k,i-1,j-1)
         tdep_out(i,j,k)=tdep(k,i-1,j-1)
      end do
   end do
end do

end subroutine tracer

!=============================================================================














!========================================================================
!========================================================================
subroutine get_date_time(yr, mon, iday, hr, minu, sec)

  implicit none
  integer, intent(out) :: yr, mon, iday, hr, minu, sec

  integer, dimension(8) :: values
  character :: date*8, chtime*10, zone*5
     
  call date_and_time(date, chtime, zone, values)
     
  yr   = values(1)
  mon  = values(2)
  iday = values(3)
  hr   = values(5)
  minu  = values(6)
  sec  = values(7)

end subroutine get_date_time

!========================================================================
subroutine read_tr_dat
!      use global_param
  use tracer_vars
  implicit none

! lit le fichier tracer.dat du coup. 
  integer :: ioerr
  character(len=60) :: line

  open(unit=unit_tr_dat, file=file_tr_dat)
  
  read(unit=unit_tr_dat, fmt=*) delttrout
  print*,delttrout
11 format(i8)
  nspectimes = 0
  read(unit=unit_tr_dat, fmt="(a)",iostat=ioerr) line
  if(ioerr/=0 .or. line(1:13)/="special times") return

  do
     nspectimes = nspectimes+1
     read(unit=line, fmt=*,iostat=ioerr) trout(nspectimes)
     if(ioerr/=0) then
        nspectimes=nspectimes-1
        exit
     end if
  end do

  close(unit=unit_tr_dat)
  
end subroutine read_tr_dat

   
end module tracer_mod
