! =======================================================================
!
! Copyright Centre National de la Recherche Scientifique (CNRS)
!
! [Institut des Geosciences de l'Environnement (IGE) & Laboratoire des
! Sciences du climat et de l'Environnement (LSCE)]
!
! contributor(s): C. Ritz, A. Quiquet, C. Dumas, V. Peyaud, V. Rommelaere,
! A. Fabre, N. Lhomme (2018)
!
! contacts:
! C.R.: catherine.ritz@univ-grenoble-alpes.fr
! C.D.: christophe.dumas@lsce.ipsl.fr
! A.Q.: aurelien.quiquet@lsce.ipsl.fr
!
! This file: [remplimat_declar_tabTu_mod.f90]
! is part of the GRISLI (GRenoble Ice-Shelf and Land-Ice model)
! software, a computer program whose purpose is to compute the evolution
! of ice thickness coupled to three-dimensional ice temperature and
! velocity fields given a mass-balance scenario.
!
! This software is governed by the CeCILL license under French law and
! abiding by the rules of distribution of free software.  You can  use,
! modify and/ or redistribute the software under the terms of the CeCILL
! license as circulated by CEA, CNRS and INRIA at the following URL
! "http://www.cecill.info".
!
! As a counterpart to the access to the source code and  rights to copy,
! modify and redistribute granted by the license, users are provided only
! with a limited warranty  and the software's author,  the holder of the
! economic rights,  and the successive licensors  have only  limited
! liability.
!
! In this respect, the user's attention is drawn to the risks associated
! with loading,  using,  modifying and/or developing or reproducing the
! software by the user in light of its specific status of free software,
! that may mean  that it is complicated to manipulate,  and  that  also
! therefore means  that it is reserved for developers  and  experienced
! professionals having in-depth computer knowledge. Users are therefore
! encouraged to load and test the software's suitability as regards their
! requirements in conditions enabling the security of their systems and/or
! data to be ensured and,  more generally, to use and operate it in the
! same conditions as regards security.
!
! The fact that you are presently reading this means that you have had
! knowledge of the CeCILL license and that you accept its terms.
!
! ======================================================================


module remplimat_declar

! ce module sert  dclarer et  initialiser tous les tableaux 
! de la matrice "equation elliptique". Ces tableaux sont locaux  remplidom 
! et aux routines de conditions aux limites.  

! dans cette version les tableaux Tuij, ... sont  4 dimensions
 


use module3d_phy

implicit none 

integer,parameter :: nflmax=2*nx*ny          ! nb. maxi de noeuds dans l'eq. elliptique.


! les tableaux declares ici sont sur nx,ny mais seul le domaine 
! nx1,nx2,ny1,ny2 est vraiment utilise.


! Coefficients de l'quation elliptique pour le calcul de u (ux)
!---------------------------------------------------------------------
! l'equation pour U(i,j) s'ecrit

!  somme (Tu(i,j,itu,jtu))+ somme(Tv(i,j,itv,jtv)) = opposx(i,j)
!  avec itu et jtu : -1,0,1
!       itv : -1,0  et jtv : 0,1
! on dimensionne cependant tous ces tableaux de -1 a 1 pour les coins de la grille


integer :: il,jl                                  ! indices pour les tableaux Tu,... Mu  ...
integer :: ilmin,ilmax                            ! bornes des boucles sur il et jl
integer :: jlmin,jlmax 


real    :: eps_col=1.e-5                          ! pour les tests : ~0

! Les tableaux Tu, Tv, Su, Sv donnent les coefficients pour l'equation en U et V
! Ce sont les lignes de la matrice L2

! coefficients pour l'quation en U
real,dimension(nx,ny,-1:1,-1:1)  ::  Tu       ! coefficients des vitesses U
real,dimension(nx,ny,-1:1,-1:1)  ::  Tv       ! coefficients des vitesses V
real,dimension(nx,ny)            ::  opposx   ! pression latrale

!  idem avec permutation i-j pour V(i,j) avec Su et Sv

! coefficients pour l'quation en V
real,dimension(nx,ny,-1:1,-1:1)  ::  Su       ! coefficients des vitesses U
real,dimension(nx,ny,-1:1,-1:1)  ::  Sv       ! coefficients des vitesses V
real,dimension(nx,ny)            ::  opposy   ! pression latrale


! Les tableaux Mu, Mv, Nu,Nv donnent des indications sur le remplissage des
! colonnes de la matrice L2, 
! pour dterminer si un noeud est vraiment utilise par d'autres.

real,dimension(nx,ny,-1:1,-1:1)  ::  Mu    ! noeuds U utilisant la vitesse U
real,dimension(nx,ny,-1:1,-1:1)  ::  Mv    ! noeuds V utilisant la vitesse U
real,dimension(nx,ny,-1:1,-1:1)  ::  Nu    ! noeuds U utilisant la vitesse V
real,dimension(nx,ny,-1:1,-1:1)  ::  Nv    ! noeuds V utilisant la vitesse V

real,dimension(nx,ny)            :: diagU  ! tableau de travail (diagonale de L2)
real,dimension(nx,ny)            :: diagV  ! tableau detravail  (diagonale de L2)

! pour compter les lignes

integer :: count_line    ! variable de travail pour compter les lignes
integer, dimension(nx,ny) :: ligu_L2                  ! numero de la ligne Uij  dans la matrice complete
integer, dimension(nx,ny) :: ligv_L2                  ! numero de la ligne Vij  dans la matrice complete
integer,dimension(nflmax,2) :: pos_ligu               ! position i,j d'un noeud U en position l dans la matrice L2
integer,dimension(nflmax,2) :: pos_ligv               ! position i,j d'un noeud V en position l dans la matrice L2


logical,dimension(nx,ny)  :: ok_umat           ! vrai si participe a l'equation elliptique
logical,dimension(nx,ny)  :: ok_vmat           ! vrai si participe a l'equation elliptique
logical,dimension(nx,ny)  :: ghost_x           ! vrai si noeud fantome (H=1)
logical,dimension(nx,ny)  :: ghost_y           ! vrai si noeud fantome (H=1)

end module remplimat_declar

