! =======================================================================
!
! Copyright Centre National de la Recherche Scientifique (CNRS)
!
! [Institut des Geosciences de l'Environnement (IGE) & Laboratoire des
! Sciences du climat et de l'Environnement (LSCE)]
!
! contributor(s): C. Ritz, A. Quiquet, C. Dumas, V. Peyaud, V. Rommelaere,
! A. Fabre, N. Lhomme (2018)
!
! contacts:
! C.R.: catherine.ritz@univ-grenoble-alpes.fr
! C.D.: christophe.dumas@lsce.ipsl.fr
! A.Q.: aurelien.quiquet@lsce.ipsl.fr
!
! This file: [graphique_L2.f90]
! is part of the GRISLI (GRenoble Ice-Shelf and Land-Ice model)
! software, a computer program whose purpose is to compute the evolution
! of ice thickness coupled to three-dimensional ice temperature and
! velocity fields given a mass-balance scenario.
!
! This software is governed by the CeCILL license under French law and
! abiding by the rules of distribution of free software.  You can  use,
! modify and/ or redistribute the software under the terms of the CeCILL
! license as circulated by CEA, CNRS and INRIA at the following URL
! "http://www.cecill.info".
!
! As a counterpart to the access to the source code and  rights to copy,
! modify and redistribute granted by the license, users are provided only
! with a limited warranty  and the software's author,  the holder of the
! economic rights,  and the successive licensors  have only  limited
! liability.
!
! In this respect, the user's attention is drawn to the risks associated
! with loading,  using,  modifying and/or developing or reproducing the
! software by the user in light of its specific status of free software,
! that may mean  that it is complicated to manipulate,  and  that  also
! therefore means  that it is reserved for developers  and  experienced
! professionals having in-depth computer knowledge. Users are therefore
! encouraged to load and test the software's suitability as regards their
! requirements in conditions enabling the security of their systems and/or
! data to be ensured and,  more generally, to use and operate it in the
! same conditions as regards security.
!
! The fact that you are presently reading this means that you have had
! knowledge of the CeCILL license and that you accept its terms.
!
! ======================================================================


subroutine graphique_L2(kl,ku,nx1,nx2,ny1,ny2,imx,imy)

use  remplimat_declar  
 
! fait une sortie graphique des matrices
!      imx(n1,n2) masque pour imposer les vitesses ou leur drivee    
!      imy(n1,n2) masque pour imposer les vitesses ou leur drive     

implicit none
integer,intent(in) :: nx1,nx2        ! bornes du domaine traite
integer,intent(in) :: ny1,ny2        ! bornes du domaine traite
integer, dimension(nx1:nx2,ny1:ny2),intent(in)  :: imx    ! masque en entree routine
integer, dimension(nx1:nx2,ny1:ny2),intent(in)  :: imy    ! masque en entree routine

integer :: kl             ! largeur de bande sous diagonale
integer :: ku             ! largeur de bande sur diagonale
integer :: lbande         ! largeur de bande  lbande= kl+ku+1
integer :: ligne          ! dans L2
integer :: colonne        ! dans L2

character (len=8) :: klku

!write(6,*) 'dans graphique, kl, ku', kl,ku 
write(klku,'("-",i0,"-",i0)') kl,ku

!write(6,*) 'graphique',klku
lbande = kl+ku+1

!write(6,*)'eps_col=',eps_col

! matrice L2 : attention, graphiquement ligne est le y et colonne est le x

open(122,file='graph-L2'//trim(klku)) ! fait une sortie graphique de L2 dans un fichier


open(123,file='graph-Mat'//trim(klku)) ! fait une sortie graphique de mat dans un fichier

999 format(i0,1x,i0,1x,es12.2,1x,5(i0,1x),es12.2,1x,a2)
998 format(4(i0,1x),es12.5,1x,4(i0,1x),a2)


! write(6,*)'dans graphique'
do j=ny1,ny2
   do i=nx1,nx2

uokmat:        if (ok_umat(i,j)) then

!              ilmin et jlmin boucle U
               ilmin=max(-1,nx1+1-i)  ! pour avoir i+il entre nx1+1 et nx2
               ilmax=min(1,nx2-i)

               jlmin=max(-1,ny1-j)    ! pour avoir j+jl entre ny1 et ny2
               jlmax=min(1,ny2-j)



               do jl = jlmin , jlmax      ! balaye tous les coefficients d'un noeud U de -1 a 1
                  do il = ilmin , ilmax   !                                           de -1 a 1 

! ecriture des Tu
                     colonne = ligu_L2(i+il,j+jl)
                     ligne   = ligu_L2(i,j)
!               write(6,*) i,j,il,jl,ligu_L2(i,j),Tu(i,j,il,jl),'Tu'

                     if (abs(Tu(i,j,il,jl)).gt.eps_col) then



                        if (colonne.eq.-9999) then
                           write(6,*) 'dans graph  colonne non affectee'
                           write(6,*) i,j,il,jl,Tu(i,j,il,jl),ok_umat(i+il,j+jl),ligu_L2(i,j),ligu_L2(i+il,j+jl)
                        endif


                        write(122,998) i,j,ligne,colonne,Tu(i,j,il,jl), & 
                                       pos_ligu(colonne,1), pos_ligu(colonne,2),il,jl,'Tu'            
                   

                        write(123,999) lbande+ligne-colonne,colonne,Tu(i,j,il,jl),i,j,il,jl, &
                                        imx(i,j),Mu(i+il,j+jl,-il,-jl),'Tu'    ! ecriture des Tu

                     endif

! ecriture des Tv
!               write(6,*) i,j,il,jl,ligu_L2(i,j),Tv(i,j,il,jl),'Tv'

                     if (abs(Tv(i,j,il,jl)).gt.eps_col) then
                        colonne = ligv_L2(i+il,j+jl)
                   

                       write(122,998) i,j,ligne,colonne,Tv(i,j,il,jl), & 
                                       pos_ligv(colonne,1), pos_ligv(colonne,2),il,jl,'Tv'       

                        write(123,999) lbande+ligne-colonne,colonne,Tv(i,j,il,jl), i,j,il,jl, &
                                       imx(i,j),Mv(i+il,j+jl,-il,-jl),'Tv'              ! ecriture des Tv
                     end if
                     
                  end do
               end do
            end if uokmat

vokmat:     if (ok_vmat(i,j)) then



               !     ilmin et jlmin boucle V
               ilmin=max(-1,nx1-i)  ! pour avoir i+il entre nx1 et nx2
               ilmax=min(1,nx2-i)

               jlmin=max(-1,ny1+1-j)    ! pour avoir j+jl entre ny1+1 et ny2
               jlmax=min(1,ny2-j)

               do jl = jlmin , jlmax      ! balaye tous les coefficients d'un noeud U de -1 a 1
                  do il = ilmin , ilmax   !                                           de -1 a 1 


! ecriture des Su    
            ligne   = ligv_L2(i,j)
            colonne = ligu_L2(i+il,j+jl)

!               write(6,*) i,j,il,jl,ligv_L2(i,j),Su(i,j,il,jl),'Su'


            if (abs(Su(i,j,il,jl)).gt.eps_col) then 


               write(122,998) i,j,ligne,colonne,Su(i,j,il,jl), &
                               pos_ligu(colonne,1), pos_ligu(colonne,2),il,jl,'Su'           

               write(123,999) lbande+ligne-colonne,colonne,Su(i,j,il,jl),i,j,il,jl, & 
                               imy(i,j),Nu(i+il,j+jl,-il,-jl),'Su'              ! ecriture des Su

            end if

! ecriture des Sv

!               write(6,*) i,j,il,jl,ligv_L2(i,j),Sv(i,j,il,jl),'Sv'

               colonne = ligv_L2(i+il,j+jl)
            
            if (abs(Sv(i,j,il,jl)).gt.eps_col) then

               write(122,998) i,j,ligne,colonne,Sv(i,j,il,jl), & 
                              pos_ligv(colonne,1), pos_ligv(colonne,2),il,jl,'Sv'    

               write(123,999) lbande+ligne-colonne,colonne,Sv(i,j,il,jl),i,j,il,jl, & 
                             imy(i,j),Nv(i+il,j+jl,-il,-jl),'Sv'              ! ecriture des Sv

            end if

         end do
      end do
   end if vokmat
end do
end do

close(122)  
close(123)        


return
end subroutine graphique_L2
