! =======================================================================
!
! Copyright Centre National de la Recherche Scientifique (CNRS)
!
! [Institut des Geosciences de l'Environnement (IGE) & Laboratoire des
! Sciences du climat et de l'Environnement (LSCE)]
!
! contributor(s): C. Ritz, A. Quiquet, C. Dumas, V. Peyaud, V. Rommelaere,
! A. Fabre, N. Lhomme (2018)
!
! contacts:
! C.R.: catherine.ritz@univ-grenoble-alpes.fr
! C.D.: christophe.dumas@lsce.ipsl.fr
! A.Q.: aurelien.quiquet@lsce.ipsl.fr
!
! This file: [fake_diagno_mod.f90]
! is part of the GRISLI (GRenoble Ice-Shelf and Land-Ice model)
! software, a computer program whose purpose is to compute the evolution
! of ice thickness coupled to three-dimensional ice temperature and
! velocity fields given a mass-balance scenario.
!
! This software is governed by the CeCILL license under French law and
! abiding by the rules of distribution of free software.  You can  use,
! modify and/ or redistribute the software under the terms of the CeCILL
! license as circulated by CEA, CNRS and INRIA at the following URL
! "http://www.cecill.info".
!
! As a counterpart to the access to the source code and  rights to copy,
! modify and redistribute granted by the license, users are provided only
! with a limited warranty  and the software's author,  the holder of the
! economic rights,  and the successive licensors  have only  limited
! liability.
!
! In this respect, the user's attention is drawn to the risks associated
! with loading,  using,  modifying and/or developing or reproducing the
! software by the user in light of its specific status of free software,
! that may mean  that it is complicated to manipulate,  and  that  also
! therefore means  that it is reserved for developers  and  experienced
! professionals having in-depth computer knowledge. Users are therefore
! encouraged to load and test the software's suitability as regards their
! requirements in conditions enabling the security of their systems and/or
! data to be ensured and,  more generally, to use and operate it in the
! same conditions as regards security.
!
! The fact that you are presently reading this means that you have had
! knowledge of the CeCILL license and that you accept its terms.
!
! ======================================================================


!module diagno_L2_mod                    ! Nouvelle version, compatible remplimat 2008 Cat
module diagno_mod                        ! ce module sert quand on ne veut pas du tout de diagno
                                         ! a choisir au niveau du makefile

use module3D_phy
use module_choix
     
implicit none



real                   :: somint,test,delp,prec
real, dimension(nx,ny) :: uxb1
real, dimension(nx,ny) :: uyb1

integer, dimension(nx,ny) :: imx_diag
integer, dimension(nx,ny) :: imy_diag

integer :: nxd1,nxd2     ! domaine selon x Dans l'appel rempli_L2
integer :: nyd1,nyd2     ! domaine selon y

integer :: itour_pvi

integer :: ifail_diagno  ! pour recuperation d'erreur
integer :: iplus1,jplus1
integer ::  ctvisco,iumax,jumax
real  :: delumax,errmax
real  :: phiphi,bt2,d02,discr,ttau
real :: sf3,sf1,epsxxm,epsyym,epsm,sf01,sf03
real :: viscm


logical :: stopvisco,viscolin
logical :: test_visc

contains    

!------------------------------------------------------------------------------------
subroutine init_diagno



! attribution des coefficients de viscosite

! formats pour les ecritures dans 42
428 format(A)

! lecture des parametres du run                      block draghwat
!--------------------------------------------------------------------

   ! pour revenir au debut du fichier param_list.dat


write(num_rep_42,428)'!___________________________________________________________' 
write(num_rep_42,428) '& diagnoshelf : fake'
write(num_rep_42,428)'!___________________________________________________________' 


return
end subroutine init_diagno

!------------------------------------------------------------------------------------
subroutine diagnoshelf !      Resolution numerique des equations diagnostiques

uxflgz(:,:) = 0.
uyflgz(:,:) = 0.

  return
end subroutine diagnoshelf


!end module diagno_L2_mod
end module diagno_mod
