#!/bin/bash

readRef=true
readExp=false
readObs=false
diffs=true
nbias=false
gbias=false
rmse=true


ref=Ref
obs=WFD
exp=Skin
period=1979-2008
lsm=land_sea_mask.nc
seas=summer

rm log.txt>/dev/null 2>> log.txt

if [ $readRef == true ] ; then
	# Reference
	echo 'load reference data...'
	cdo -s -t echam.codes -f nc copy -mul -ymonmean -yearmean -selmon,4,5,6,7,8,9 -selcode,167 ${ref}_${period}.grb ${lsm} ${ref}_${seas}.nc>/dev/null 2>> log.txt 
fi

if [ $readExp == true ] ; then
	# Experiment
	echo 'load experiment data...'
	cdo -s -t echam.codes -f nc copy -mul -ymonmean -yearmean -selmon,4,5,6,7,8,9 -selcode,167 ${exp}_${period}.grb ${lsm} ${exp}_${seas}.nc>/dev/null 2>> log.txt 
fi
	
if [ $readObs == true ] ; then	
	# Observations
	echo 'load observation data...'
	cdo -s copy -mul -ymonmean -yearmean -selmon,4,5,6,7,8,9 -selvar,Tair ${obs}_${period}.nc ${lsm} ${obs}_${seas}.nc>/dev/null 2>> log.txt
fi

if [ $diffs == true ] ; then
	# Differences
	echo 'calculate Differences...'
	# Ref-Obs
	cdo -s sub ${ref}_${seas}.nc ${obs}_${seas}.nc ${ref}-${obs}_${seas}.nc>/dev/null 2>> log.txt
	# Exp-Obs
	cdo -s sub ${exp}_${seas}.nc ${obs}_${seas}.nc ${exp}-${obs}_${seas}.nc>/dev/null 2>> log.txt
	# Exp-Ref
	cdo -s sub ${exp}_${seas}.nc ${ref}_${seas}.nc ${exp}-${ref}_${seas}.nc>/dev/null 2>> log.txt
fi

if [ $nbias == true ] ; then
	echo 'calculate normalized Bias...'
	# normalized Bias
	cdo -s -setmisstoc,0 -div -sub -abs ${ref}-${obs}_${seas}.nc -abs ${exp}-${obs}_${seas}.nc -add -abs ${ref}-${obs}_${seas}.nc -abs ${exp}-${obs}_${seas}.nc normBias_${ref}-${exp}-${obs}_${seas}.nc>/dev/null 2>> log.txt
fi

if [ $gbias == true ] ; then
	echo 'calculate absolute value of global Bias over land...'
	# Ref
	cdo -s -fldmean -setctomiss,0 -abs ${ref}-${obs}_${seas}.nc globalBias_${ref}_${seas}.nc>/dev/null 2>> log.txt
	# Exp
	cdo -s -fldmean -setctomiss,0 -abs ${exp}-${obs}_${seas}.nc globalBias_${exp}_${seas}.nc>/dev/null 2>> log.txt
	# Diff
	cdo -s sub globalBias_${ref}_${seas}.nc globalBias_${exp}_${seas}.nc globalBias_${ref}-${exp}_${seas}.nc>/dev/null 2>> log.txt
fi

if [ ${rmse} == true ] ; then
        echo 'calculate global Bias...'
        # Ref
        cdo -s -sqrt -fldmean -setctomiss,0 -sqr ${ref}-${obs}_${seas}${ttest}.nc rmse_${ref}_${seas}${ttest}.nc>/dev/null 2>> log.txt
        # Exp
        cdo -s -sqrt -fldmean -setctomiss,0 -sqr ${exp}-${obs}_${seas}${ttest}.nc rmse_${exp}_${seas}${ttest}.nc>/dev/null 2>> log.txt
        # Diff
        cdo -s sub rmse_${ref}_${seas}${ttest}.nc rmse_${exp}_${seas}${ttest}.nc rmse_${ref}-${exp}_${seas}${ttest}.nc>/dev/null 2>> log.txt
fi





