
ncid = netcdf.open(filename,'NC_NOWRITE');

finfo = ncinfo(filename);

%Informationen ber den Dateiinhalt
[ndims,nvars,numglobalatts,unlimdimID] = netcdf.inq(ncid);

%Informationen ber die Dimension
dimlen = NaN(ndims,1); %um die Schleife schneller zu machen
dimname = cell(ndims,1); % -"-
for i = 1:ndims
    [dimname{i},dimlen(i)]= netcdf.inqDim(ncid,i-1); %weil NetCDF von 0 Zhlt "i-1"
end

%Informationen ber die Variablen
varid = NaN(nvars,1);
varname = cell(nvars,1);
for i = 1:nvars
    [varname{i},varid(i)] = netcdf.inqVar(ncid,i-1);
       
end
% 
for i = 1:nvars
    var_a = netcdf.getVar(ncid,i-1);
    if length(size(var_a))==3
        var = squeeze(var_a(1,1,:));
    elseif length(size(var_a))==4
        var = squeeze(var_a(1,1,:,:));
    %elseif length(size(var_a))==5
    %    var = squeeze(var_a(1,1,:,:,:));
    %        elseif length(size(var_a))==6
    %    var = squeeze(var_a(1,1,:,:,:,:));
    %        elseif length(size(var_a))==7
    %    var = squeeze(var_a(1,1,:,:,:,:,:));
    else
        var = var_a;
    end
    var_name{i} = [varname{i}];
    assignin('base',var_name{i},var);
    if i==1
        save(output,var_name{1})
    else
        save(output,var_name{i},'-append')
    end 
end

netcdf.close(ncid)


