%% General Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clc;                % Refresh Command Window
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places
addpath(genpath('../Functions')) % load Functions
% time units (in seconds)
sec = 1; minute = 60*sec; hour = 60*minute; day = 24*hour; year = 365*day;
%--------------------------------------------------------------------------

%% Settings
read   = 1;
specID ='nc';

%% Read NC-File %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

filename = 'jsbach_DICE_11tiles_5layers_1976.nc';

if read==1
    % NC-file einlesen
    expid = filename(1:end-2);
    output   = strcat(expid,'mat');
    Text   = ['Read ', filename,'...'];disp(Text)
    readSurfaceFile  % run subroutine
else
    expid = filename(1:end-2);
    output   = strcat(expid,'mat');
    load(output)
end

lon = 263.2649;
lat =  37.6486;
elevation   = 432.00;
root_depth = 0.065;
soil_field_cap = 0.288;
maxmoist = root_depth * soil_field_cap;    
ntiles      = [1 2 3]';
cover_fract = [0.067 0.233 0.7]';
cover_type  = [15 16 20];

%--------------------------------------------------------------------------
%% Output
% rootdepth4cm.sd10m.sfcmod
%ncfilename = strcat('jsbach',expid,num2str(mm_frac),'maxmoist.nsoil7.nc');
ncfilename = ['jsbach.' specID];
% Create a netCDF file.
ncid = netcdf.create(ncfilename,'CLOBBER');


% Define dimensions
xdimid   = netcdf.defDim(ncid,'lon',1);
ydimid   = netcdf.defDim(ncid,'lat',2);
tdimid   = netcdf.defDim(ncid,'time',length(surf_temp));
ndimid   = netcdf.defDim(ncid,'ntiles',length(ntiles));
sdimid   = netcdf.defDim(ncid,'soillev',length(soillev));
ldimid   = netcdf.defDim(ncid,'lct',21);

% Define variables
latid = netcdf.defVar(ncid,'lat','double',[xdimid ydimid]);
netcdf.putAtt(ncid,latid,'long_name','latitude');
netcdf.putAtt(ncid,latid,'units','degrees_north');
netcdf.putAtt(ncid,latid,'standard_name','latitude');

lonid = netcdf.defVar(ncid,'lon','double',xdimid);
netcdf.putAtt(ncid,lonid,'long_name','longitude');
netcdf.putAtt(ncid,lonid,'units','degrees_east');
netcdf.putAtt(ncid,lonid,'standard_name','longitude');

timeid = netcdf.defVar(ncid,'time','double',tdimid);
netcdf.putAtt(ncid,timeid,'long_name','month');
netcdf.putAtt(ncid,timeid,'units',' ');
netcdf.putAtt(ncid,timeid,'standard_name','time');

ntilesid = netcdf.defVar(ncid,'ntiles','double',ndimid);
netcdf.putAtt(ncid,ntilesid,'long_name','number of tiles');

soillevid = netcdf.defVar(ncid,'soillev','double',sdimid);
netcdf.putAtt(ncid,soillevid,'long_name','soil level depth');
netcdf.putAtt(ncid,soillevid,'units','m');
netcdf.putAtt(ncid,soillevid,'standard_name','soillev');

sldid = netcdf.defVar(ncid,'soil_layer_depth','double',[xdimid sdimid]);
netcdf.putAtt(ncid,sldid,'long_name','soil layer thickness');
netcdf.putAtt(ncid,sldid,'units','m');

imid = netcdf.defVar(ncid,'init_moist','double',[xdimid ydimid]);
netcdf.putAtt(ncid,imid,'long_name','soil wetness');
netcdf.putAtt(ncid,imid,'units','m');

slfid = netcdf.defVar(ncid,'slf','double',[xdimid ydimid]);
netcdf.putAtt(ncid,slfid,'long_name','fractional land sea mask');
netcdf.putAtt(ncid,slfid,'units','fractional');

slmid = netcdf.defVar(ncid,'slm','double',[xdimid ydimid]);
netcdf.putAtt(ncid,slmid,'long_name','land sea mask');
netcdf.putAtt(ncid,slmid,'units','1');

rlid = netcdf.defVar(ncid,'roughness_length','double',[xdimid ydimid]);
netcdf.putAtt(ncid,rlid,'long_name','surface roughness length');
netcdf.putAtt(ncid,rlid,'units','m');

eid = netcdf.defVar(ncid,'elevation','double',[xdimid ydimid]);
netcdf.putAtt(ncid,eid,'long_name','Mean orography');
netcdf.putAtt(ncid,eid,'units','m');

mmid = netcdf.defVar(ncid,'maxmoist','double',[xdimid ydimid]);
netcdf.putAtt(ncid,mmid,'long_name','Maximum soil water capacity');
netcdf.putAtt(ncid,mmid,'units','m');

cfid = netcdf.defVar(ncid,'cover_fract','double',[xdimid ydimid ndimid]);
netcdf.putAtt(ncid,cfid,'long_name','land cover fraction');
netcdf.putAtt(ncid,cfid,'units','1');

ctid = netcdf.defVar(ncid,'cover_type','double',[xdimid ydimid ndimid]);
netcdf.putAtt(ncid,ctid,'long_name','land cover type');
netcdf.putAtt(ncid,ctid,'units','1');

vrmid = netcdf.defVar(ncid,'veg_ratio_max','double',[xdimid ydimid]);
netcdf.putAtt(ncid,vrmid,'long_name','maximum vegetation fraction');
netcdf.putAtt(ncid,vrmid,'units','1');

rloid = netcdf.defVar(ncid,'roughness_length_oro','double',[xdimid ydimid]);
netcdf.putAtt(ncid,rloid,'long_name','roughness_length due to orography');
netcdf.putAtt(ncid,rloid,'units','m');

sdid = netcdf.defVar(ncid,'soil_depth','double',[xdimid ydimid]);
netcdf.putAtt(ncid,sdid,'long_name','soil depth until bedrock');
netcdf.putAtt(ncid,sdid,'units','m');

spid = netcdf.defVar(ncid,'soil_porosity','double',[xdimid ydimid]);
netcdf.putAtt(ncid,spid,'long_name','volumetric soil porosity');
netcdf.putAtt(ncid,spid,'units','m/m');

psiid = netcdf.defVar(ncid,'pore_size_index','double',[xdimid ydimid]);
netcdf.putAtt(ncid,psiid,'long_name','soil pore size distribution index');
netcdf.putAtt(ncid,psiid,'units',' ');

sfcid = netcdf.defVar(ncid,'soil_field_cap','double',[xdimid ydimid]);
netcdf.putAtt(ncid,sfcid,'long_name','volumetric soil field capacity');
netcdf.putAtt(ncid,sfcid,'units','m/m');

hcapid = netcdf.defVar(ncid,'heat_capacity','double',[xdimid ydimid]);
netcdf.putAtt(ncid,hcapid,'long_name','heat capacity of dry soil');
netcdf.putAtt(ncid,hcapid,'units','J m-3 K-1');

hconid = netcdf.defVar(ncid,'heat_conductivity','double',[xdimid ydimid]);
netcdf.putAtt(ncid,hconid,'long_name','heat conductivity of dry soil');
netcdf.putAtt(ncid,hconid,'units','J m-1 s-1 K-1');

mpid = netcdf.defVar(ncid,'moisture_pot','double',[xdimid ydimid]);
netcdf.putAtt(ncid,mpid,'long_name','saturated matrix potential');
netcdf.putAtt(ncid,mpid,'units','m');

hcsid = netcdf.defVar(ncid,'hyd_cond_sat','double',[xdimid ydimid]);
netcdf.putAtt(ncid,hcsid,'long_name','saturated hydraulic conductivity');
netcdf.putAtt(ncid,hcsid,'units','m/s');

wpid = netcdf.defVar(ncid,'wilting_point','double',[xdimid ydimid]);
netcdf.putAtt(ncid,wpid,'long_name','volumetric wilting point');
netcdf.putAtt(ncid,wpid,'units','m/m');

bid = netcdf.defVar(ncid,'bclapp','double',[xdimid ydimid]);
netcdf.putAtt(ncid,bid,'long_name','Clapp and Hornberger (1978) exponent b');
netcdf.putAtt(ncid,bid,'units',' ');

rdid = netcdf.defVar(ncid,'root_depth','double',[xdimid ydimid]);
netcdf.putAtt(ncid,rdid,'long_name','rooting depth');
netcdf.putAtt(ncid,rdid,'units','m');

lmid = netcdf.defVar(ncid,'layer_moist','double',[xdimid ydimid sdimid]);
netcdf.putAtt(ncid,lmid,'long_name','initial moisture for multilayer soils');
netcdf.putAtt(ncid,lmid,'units','m');

snowid = netcdf.defVar(ncid,'snow','double',[xdimid ydimid]);
netcdf.putAtt(ncid,snowid,'long_name','snow depth');
netcdf.putAtt(ncid,snowid,'units','m');

albedoid = netcdf.defVar(ncid,'albedo','double',[xdimid ydimid]);
netcdf.putAtt(ncid,albedoid,'long_name','surface background albedo');
netcdf.putAtt(ncid,albedoid,'units','fractional');

osdid = netcdf.defVar(ncid,'orography_std_dev','double',[xdimid ydimid]);
netcdf.putAtt(ncid,osdid,'long_name','Orographoc standard deviation');
netcdf.putAtt(ncid,osdid,'units','m');

glacid = netcdf.defVar(ncid,'glac','double',[xdimid ydimid]);
netcdf.putAtt(ncid,glacid,'long_name','glacier mask');
netcdf.putAtt(ncid,glacid,'units','m');

faoid = netcdf.defVar(ncid,'fao','double',[xdimid ydimid]);
netcdf.putAtt(ncid,faoid,'long_name','FAO data set (soil data flags)');
netcdf.putAtt(ncid,faoid,'units','0...5');

ffid = netcdf.defVar(ncid,'forest_fract','double',[xdimid ydimid]);
netcdf.putAtt(ncid,ffid,'long_name','vegetation type');
netcdf.putAtt(ncid,ffid,'units','fractional');

laiid = netcdf.defVar(ncid,'lai_clim','double',[xdimid ydimid tdimid]);
netcdf.putAtt(ncid,laiid,'long_name','leaf area index');
netcdf.putAtt(ncid,laiid,'units',' ');

vfid = netcdf.defVar(ncid,'veg_fract','double',[xdimid ydimid tdimid]);
netcdf.putAtt(ncid,vfid,'long_name','vegetation ratio');
netcdf.putAtt(ncid,vfid,'units','fractional');

stid = netcdf.defVar(ncid,'surf_temp','double',[xdimid ydimid tdimid]);
netcdf.putAtt(ncid,stid,'long_name','surface temperature');
netcdf.putAtt(ncid,stid,'units','K');

avvid = netcdf.defVar(ncid,'albedo_veg_vis','double',[xdimid ydimid]);
netcdf.putAtt(ncid,avvid,'long_name','vegetation albedo in the visible range');
netcdf.putAtt(ncid,avvid,'units','1');

avnid = netcdf.defVar(ncid,'albedo_veg_nir','double',[xdimid ydimid]);
netcdf.putAtt(ncid,avnid,'long_name','vegetation albedo in the NIR');
netcdf.putAtt(ncid,avnid,'units','1');

asvid = netcdf.defVar(ncid,'albedo_soil_vis','double',[xdimid ydimid]);
netcdf.putAtt(ncid,asvid,'long_name','soil albedo in the visible range');
netcdf.putAtt(ncid,asvid,'units','1');

asnid = netcdf.defVar(ncid,'albedo_soil_nir','double',[xdimid ydimid]);
netcdf.putAtt(ncid,asnid,'long_name','soil albedo in the NIR');
netcdf.putAtt(ncid,asnid,'units','1');


netcdf.putAtt(ncid,netcdf.getConstant('NC_GLOBAL'),'Origin','DICE')
netcdf.putAtt(ncid,netcdf.getConstant('NC_GLOBAL'),'Conversion software','jsbach_nc.m')

netcdf.endDef(ncid)

% Multi-Dimensions 

CoverFract = zeros(1,2,length(cover_fract));
CoverType  = CoverFract;
for i = 1:length(cover_fract)
    CoverFract(1,1,i) = cover_fract(i);
    CoverType(1,1,i) = cover_type(i);
end

LayerMoist = zeros(1,2,length(layer_moist));
for i = 1:length(layer_moist)
    LayerMoist(1,1,i) = layer_moist(i);
end


LaiClim = zeros(1,2,length(lai_clim));
VegFract  = LaiClim;
SurfTemp  = LaiClim;
for i = 1:length(lai_clim)
    LaiClim(1,1,i) = lai_clim(i);
    VegFract(1,1,i) = veg_fract(i);
    SurfTemp(1,1,i) = surf_temp(i);
end

% Write data to variable.
netcdf.putVar(ncid,lonid,lon);
netcdf.putVar(ncid,latid,[lat 90]');
netcdf.putVar(ncid,timeid,time);
netcdf.putVar(ncid,ntilesid,ntiles);
netcdf.putVar(ncid,soillevid,soillev);
netcdf.putVar(ncid,sldid,soil_layer_depth);
netcdf.putVar(ncid,imid,[init_moist 0]);
netcdf.putVar(ncid,slfid,[slf 0]);
netcdf.putVar(ncid,slmid,[slm 0]);
netcdf.putVar(ncid,rlid,[roughness_length 0]);
netcdf.putVar(ncid,eid,[elevation 0]);
netcdf.putVar(ncid,mmid,[maxmoist 0]);
netcdf.putVar(ncid,cfid,CoverFract);
netcdf.putVar(ncid,ctid,CoverType);
netcdf.putVar(ncid,vrmid,[veg_ratio_max 0]);
netcdf.putVar(ncid,rloid,[roughness_length_oro 0]);
netcdf.putVar(ncid,sdid,[soil_depth 0]);
netcdf.putVar(ncid,spid,[soil_porosity 0]);
netcdf.putVar(ncid,psiid,[pore_size_index 0]);
netcdf.putVar(ncid,sfcid,[soil_field_cap 0]);
netcdf.putVar(ncid,hcapid,[heat_capacity 0]);
netcdf.putVar(ncid,hconid,[heat_conductivity 0]);
netcdf.putVar(ncid,mpid,[moisture_pot 0]);
netcdf.putVar(ncid,hcsid,[hyd_cond_sat 0]);
netcdf.putVar(ncid,wpid,[wilting_point 0]);
netcdf.putVar(ncid,bid,[bclapp 0]);
netcdf.putVar(ncid,rdid,[root_depth 0]);
netcdf.putVar(ncid,lmid,LayerMoist);
netcdf.putVar(ncid,snowid,[snow 0]);
netcdf.putVar(ncid,albedoid,[albedo 0]);
netcdf.putVar(ncid,osdid,[orography_std_dev 0]);
netcdf.putVar(ncid,glacid,[glac 0]);
netcdf.putVar(ncid,faoid,[fao 0]);
netcdf.putVar(ncid,ffid,[forest_fract 0]);
netcdf.putVar(ncid,laiid,LaiClim);
netcdf.putVar(ncid,vfid,VegFract);
netcdf.putVar(ncid,stid,SurfTemp);
netcdf.putVar(ncid,avvid,[albedo_veg_vis 0]);
netcdf.putVar(ncid,avnid,[albedo_veg_nir 0]);
netcdf.putVar(ncid,asvid,[albedo_soil_vis 0]);
netcdf.putVar(ncid,asnid,[albedo_soil_nir 0]);

% Close netcdf-file
netcdf.close(ncid)