

F1 = F;
c    = 0.5;
F1(4) = c*F1(4);

bm = 0.08/c;
tm = 0.01;
rm = 0.005;
leftm = 0.05;
dx = 1 - rm - leftm;
dy = 1 - tm - bm;
P1 = [leftm bm dx dy];

% Shaded nights
FC = [0.5 0.5 0.5];
fa = 0.03;
xa = 0.102; xb = 0.420; xc = 0.740;
da = 0.175; db = 0.175; dc = 0.175;

Pos1a = [xa bm da dy];
Pos1b = [xb bm db dy];
Pos1c = [xc bm dc dy];

legStr = {'$\ T_{\mathrm{sfc}}$(\textit{Obs})',...
    '$\ T_{\mathrm{sfc}}$(\textit{Ref})','$\ T_{\mathrm{sfc}}$(\textit{SkIn})'};

legPos = [0.845 0.835 0.01 0.01];

figure('Color','White','units','points','Position',F1,...
         'PaperPositionMode','auto','PaperOrientation','landscape');

lineWid  = 3;
fontSize = 32;

P = P1;
subplot('Position',P)
hold on; box on; grid on


h(1) = plot(x,obs.Tg,'Color',pale(newColor(8),0.0),'LineWidth',lineWid,'LineStyle','--');
h(2) = plot(x,TG,'Color',rgb('Orange'),'LineWidth',lineWid);
h(3) = plot(x,TG_SkIn,'Color',newColor(7),'LineWidth',lineWid);

%h(4) = plot(x,SW,'Color',Color(3,:),'LineWidth',lineWid);

set(gca,'FontSize',fontSize,'xlim',[startDate endDate],'xtick',xTicks,'xticklabel',xLabels)

yMin = -2.5;
yMax = 37.5;
yInt =  2.5;
yTicks = yMin:yInt:yMax;
set(gca,'ylim',[yMin yMax],'ytick',yTicks)
yLabels = get(gca,'yTickLabel');
yLabels(1:2:end) = {''};
set(gca,'yTickLabel',yLabels);
xlabel(xLabStr,'Interpreter','Latex','Fontsize',fontSize)
ylabel('$^\circ$C','Interpreter','Latex','Fontsize',fontSize)

% Create rectangle
annotation('rectangle',Pos1a,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);
annotation('rectangle',Pos1b,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);
annotation('rectangle',Pos1c,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);


ynInt = length(yTicks)-1;

negInt = abs(yTicks(1)/yInt);
    PP4   = P(2)+negInt*(P(4)/ynInt);
    annotation('line',[P(1) P(1)+P(3)], [PP4 PP4],...
        'LineStyle','--','LineWidth',1);
    

leg1 = legend(gca,h(1:3),legStr);
        set(leg1,'Color','White','FontSize',fontSize+4,'Interpreter','Latex',...
            'EdgeColor','white','Position',legPos)    



% Print
if printSwitch == 1
    drucken([outputDir 'tempPlot.' outputFormat])
end


   