
% Axes position
bm = 0.08;
tm = 0.01;
mm = 0.005;
rm = 0.005;
leftm = 0.06;
dx = 1 - rm - leftm;
dy = (1 - tm - bm - mm)/2;
P1 = [leftm bm dx dy];
P2 = [leftm bm+mm+dy dx dy];

% Shaded nights
FC = [0.5 0.5 0.5];
fa = 0.03;
xa = 0.102; xb = 0.420; xc = 0.740;
da = 0.175; db = 0.175; dc = 0.175;

Pos1a = [xa bm       da dy];
Pos1b = [xb bm       db dy];
Pos1c = [xc bm       dc dy];
Pos2a = [xa bm+dy+mm da dy];
Pos2b = [xb bm+dy+mm db dy];
Pos2c = [xc bm+dy+mm dc dy];


legSize = 0.01;
legStr  = {'$\ R_{\mathrm{net}}$','$\ H$','$\ LE$','$\ G$'};
legPos1 = [0.200 0.415 legSize legSize];
legPos2 = [0.855 0.415 legSize legSize];
legPos3 = [0.200 0.855 legSize legSize];
legPos4 = [0.855 0.870 legSize legSize];

figure('Color','White','units','points','Position',F,...
         'PaperPositionMode','auto','PaperOrientation','landscape');

lineWid  = 3;
fontSize = 32;
lSObs    = '--';

P = P1;
subplot('Position',P)
hold on; box on; grid on

h(1) = plot(x,Rnet_SkIn,'Color',newColor(4),'LineWidth',lineWid);
h(2) = plot(x,obs.Rnet,'Color',pale(newColor(4),0.3),'LineWidth',lineWid,'LineStyle',lSObs);
h(3) = plot(x,H_SkIn,'Color',newColor(7),'LineWidth',lineWid);
h(4) = plot(x,obs.shf,'Color',newColor(8),'LineWidth',lineWid,'LineStyle',lSObs);
h(5) = plot(x,E_SkIn,'Color',newColor(6),'LineWidth',lineWid);
h(6) = plot(x,obs.lhf,'Color',newColor(1),'LineWidth',lineWid,'LineStyle',lSObs);
h(7) = plot(x,G_SkIn,'Color',newColor(5),'LineWidth',lineWid);
h(8) = plot(x,obs.ghf,'Color',rgb('Green'),'LineWidth',lineWid,'LineStyle',lSObs);

yMin   = -300;
yMax   = 450;
yInt   = 50;
yTicks = yMin:yInt:yMax;
set(gca,'FontSize',fontSize,'ylim',[yMin yMax],'ytick',yTicks,...
    'xlim',[startDate endDate],'xtick',xTicks,'xticklabel',xLabels)
yLabels = get(gca,'yTickLabel');
yLabels(2:2:end) = {''};
set(gca,'yTickLabel',yLabels);
xlabel(xLabStr,'Interpreter','Latex','Fontsize',fontSize)
ylabel('W/m$^2$','Interpreter','Latex','Fontsize',fontSize)
    

text(0.13,0.935,'\textit{SkIn}','units','normalized','Backgroundcolor','white','Interpreter','latex','Fontsize',fontSize)
text(0.8,0.935,'\textit{Observations}','units','normalized','Backgroundcolor','white','Interpreter','latex','Fontsize',fontSize)
leg1 = legend(gca,h(1:2:end-1),legStr);
        set(leg1,'Color','White','FontSize',fontSize,'Interpreter','Latex','EdgeColor','white','Position',legPos1)
a = axes('position',get(gca,'position'),'visible','off');         
leg2 = legend(a,h(2:2:end),legStr');
        set(leg2,'Color','White','FontSize',fontSize,'Interpreter','Latex','EdgeColor','white','Position',legPos2)   
    
% Create rectangle
annotation('rectangle',Pos1a,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);
annotation('rectangle',Pos1b,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);
annotation('rectangle',Pos1c,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);


ynInt = length(yTicks)-1;

negInt = abs(yTicks(1)/yInt);
    PP4   = P(2)+negInt*(P(4)/ynInt);
    annotation('line',[P(1) P(1)+P(3)], [PP4 PP4],...
        'LineStyle','--','LineWidth',1);

    
P = P2;
subplot('Position',P)
hold on; box on; grid on

h(1) = plot(x,Rnet,'Color',newColor(4),'LineWidth',lineWid);
h(2) = plot(x,obs.Rnet,'Color',pale(newColor(4),0.3),'LineWidth',lineWid,'LineStyle',lSObs);
h(3) = plot(x,H,'Color',newColor(7),'LineWidth',lineWid);
h(4) = plot(x,obs.shf,'Color',newColor(8),'LineWidth',lineWid,'LineStyle',lSObs);
h(5) = plot(x,E,'Color',newColor(6),'LineWidth',lineWid);
h(6) = plot(x,obs.lhf,'Color',newColor(1),'LineWidth',lineWid,'LineStyle',lSObs);
h(7) = plot(x,G,'Color',newColor(5),'LineWidth',lineWid);
h(8) = plot(x,obs.ghf,'Color',rgb('Green'),'LineWidth',lineWid,'LineStyle',lSObs);
h(9) = plot(x,Q,'Color',[0.6 0.4 0.2],'LineWidth',lineWid);

set(gca,'FontSize',fontSize,'ylim',[yMin yMax],'ytick',yTicks,...
    'xlim',[startDate endDate],'xtick',xTicks,'xticklabel',xLabels)
yLabels = get(gca,'yTickLabel');
yLabels(2:2:end) = {''};
set(gca,'yTickLabel',yLabels);
set(gca,'xticklabel','')
ylabel('W/m$^2$','Interpreter','Latex','Fontsize',fontSize)

text(0.12,0.935,'\textit{Reference}','units','normalized','Backgroundcolor','white','Interpreter','latex','Fontsize',fontSize)
text(0.8,0.935,'\textit{Observations}','units','normalized','Backgroundcolor','white','Interpreter','latex','Fontsize',fontSize)
leg3 = legend(gca,h(1:2:end),[legStr,'$\ S_{\mathrm{soil}}$']);
        set(leg3,'Color','White','FontSize',fontSize,'Interpreter','Latex','EdgeColor','white','Position',legPos3)
a = axes('position',get(gca,'position'),'visible','off');         
leg4 = legend(a,h(2:2:end-1),legStr);
        set(leg4,'Color','White','FontSize',fontSize,'Interpreter','Latex','EdgeColor','white','Position',legPos4)        
    
% Create rectangle
annotation('rectangle',Pos2a,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);
annotation('rectangle',Pos2b,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);
annotation('rectangle',Pos2c,'Color','none',...
    'FaceColor',FC,'FaceAlpha',fa);


ynInt = length(yTicks)-1;

negInt = abs(yTicks(1)/yInt);
    PP4   = P(2)+negInt*(P(4)/ynInt);
    annotation('line',[P(1) P(1)+P(3)], [PP4 PP4],...
        'LineStyle','--','LineWidth',1);    

if printSwitch == 1
    drucken([outputDir 'sebPlot.' outputFormat])
end








