
F1 = F;

F1(4) = 0.6*F1(4);

bm = 0.12;
tm = 0.06;
rm = 0.05;
leftm = 0.06;
dx = 1 - rm - leftm;
dy = 1 - tm - bm;
P1 = [leftm bm dx dy];

% Shaded nights
FC = [0.5 0.5 0.5];
fa = 0.03;
xa = 0.102; xb = 0.420; xc = 0.740;
da = 0.175; db = 0.175; dc = 0.175;

Pos1a = [xa bm da dy];
Pos1b = [xb bm db dy];
Pos1c = [xc bm dc dy];

P = P1;
figure('Color','White','units','points','Position',F1,...
         'PaperPositionMode','auto','PaperOrientation','landscape');

lineWid = 3;
fontSize = 32;

P = P1;
subplot('Position',P)
hold on; box on; grid on

SW(SW<4) = 4;
T(T<0.1) = 0.1;
v(v<0.1) = 0.1;

rad = [SW,LW];
qTv = [q,T,v];

legStr1 = {'$\ R_{\mathrm{\,sw}}\downarrow$\,\,\,[W/m$^2$]','$\ R_{\mathrm{\,lw}}\downarrow$\,\,\,[W/m$^2$]'};
legStr2 = {'$\ q_{\mathrm{air}}$(2$\,$m) \,[g/kg]','$\ T_{\mathrm{air}}$(2$\,$m) [$^\circ$C]','$\ v$(10$\,$m) \,\,\,[m/s]'};

legPos1 = [0.12 0.80 0.0883 0.0776];
legPos2 = [0.76 0.77 0.0883 0.0776];

yMin1 = 0;  yMax1 = 800;    yInt1 = 50;
yMin2 = 0;  yMax2 =  32;    yInt2 =  2;


[ax,h1,h2] = plotyy(x,rad,x,qTv);

lineWid = 3;

set(ax(1),'ylim',[yMin1 yMax1],'ytick',yMin1:yInt1:yMax1,'FontSize',fontSize,...
    'xtick',xTicks,'xlim',[startDate endDate],'xticklabel',xLabels)

yLabels = get(ax(1),'yTickLabel');
yLabels(2:2:end-1) = {''};
set(ax(1),'yTickLabel',yLabels);

set(ax(2),'ylim',[yMin2 yMax2],'ytick',yMin2:yInt2:yMax2,'YColor','Black','FontSize',fontSize,...
    'xtick',xTicks,'xlim',[startDate endDate],'xticklabel',xLabels)

yLabels = get(ax(2),'yTickLabel');
yLabels(2:2:end-1) = {''};
set(ax(2),'yTickLabel',yLabels);

set(h1(1),'Color',newColor(3),'LineWidth',lineWid)
set(h1(2),'Color',newColor(2),'LineWidth',lineWid)
set(h2(1),'Color',newColor(1),'LineWidth',lineWid)
set(h2(2),'Color',newColor(7),'LineWidth',lineWid)
set(h2(3),'Color',newColor(5),'LineWidth',lineWid)
xlabel(xLabStr,'Interpreter','Latex','Fontsize',fontSize)
ylabel('W/m$^2$','Interpreter','Latex','Fontsize',fontSize) 

ylabel(ax(2), '[g/kg] or [$^\circ$C] or [m/s]','Interpreter','Latex','Fontsize',fontSize)

leg1 = legend(gca,h1(1:2),legStr1,'location','NW');
set(leg1,'Color','White','FontSize',fontSize+4,'Interpreter','Latex','EdgeColor','white');
a = axes('position',get(gca,'position'),'visible','off'); 
leg2 = legend(a,h2(1:3),legStr2,'location','NE');
set(leg2,'Color','White','FontSize',fontSize+4,'Interpreter','Latex','EdgeColor','white');
set(leg1,'Position',legPos1)
set(leg2,'Position',legPos2)

% Print
if printSwitch == 1
    drucken([outputDir 'forcingPlot.' outputFormat])
end




