%========= General Settings ===============================================

clc;                % Refresh Command Window
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places
addpath(genpath('../Functions')) % load Functions
% time units (in seconds)
sec = 1; minute = 60*sec; hour = 60*minute; day = 24*hour; year = 365*day;

%========= User Interface =================================================

printSwitch     = 1;
forcingSwitch   = 1;
sebSwitch       = 0;
sebSingleSwitch = 0;
tempSwitch      = 0;

outputFormat = 'pdf';               % ('png' or 'pdf')
outputDir    = './Output/';
inputDir     = './Input/';

% Observations
obsFile = 'dice_surf_obs.nc';
obsStr  = {'Tg','lhf','shf','lwup','swup'};

%========= Specification ==================================================

dt = 600;
T0 = 273.15;

load([inputDir 'jsbach.10min.SkIn.mat'])

H_SkIn    = -sensible_heat_flx_10min(2:end);
E_SkIn    = -latent_heat_flx_10min(2:end);
G_SkIn    = ground_heat_flux_10min(2:end);
Rnet_SkIn = net_radiation_10min(2:end);
TG_SkIn   = surface_temperature_10min(2:end)-T0;

load([inputDir 'jsbach.10min.Ref.mat'])

T  = air_temp_10min(2:end);
v  = wind_speed_10min(2:end);
q  = spec_humidity_10min(2:end)*1e3;
SW = rad_sw_down_10min(2:end);
LW = rad_lw_down_10min(2:end);

H     = -sensible_heat_flx_10min(2:end);
E     = -latent_heat_flx_10min(2:end);
G     = ground_heat_flux_10min(2:end);
Rnet  = net_radiation_10min(2:end);
TG    = surface_temperature_10min(2:end)-T0;

C  = 152445.6249;
dT = [TG(2:end)-TG(1:end-1);NaN];
Q  = -dT*C/dt;



% Observations
nVar    = length(obsStr);
ncid = netcdf.open([inputDir obsFile],'NC_NOWRITE');
for iVar = 1:nVar
    varStr  = obsStr{iVar};
    varData = double(netcdf.getVar(ncid,netcdf.inqVarID(ncid,varStr)));
    obs.(varStr) = varData(1:end-1);
end

obs.Tg   = obs.Tg-T0;
obs.Rnet = SW + LW - obs.swup - obs.lwup;
obs.ghf  = obs.shf + obs.lhf - obs.Rnet;


% Time-Axisdate
startDate = datenum('10-23-1999 14:00:00');
endDate   = datenum('10-26-1999 13:50:00');
x  = linspace(startDate,endDate,length(T));
xInt    = 1/12;
xStart  = datenum('10-23-1999 16:00:00');
xEnd    = datenum('10-26-1999 12:00:00');
xTicks  = xStart:xInt:xEnd;
xLabels = cellstr(datestr(xTicks,'HH:MM'));
xLabels(2:2:end) = {''};
xLabStr = 'Local Time (UTC - 5 hours)';
% Figure Size
F = [0 0 2000 1200];

if forcingSwitch == 1
    disp('Plot Forcing Data...')
    forcingPlot
end

if sebSwitch == 1
    disp('Plot Surface-Energy-Balance...')
    sebPlot
end

if sebSingleSwitch == 1
    disp('Plot Surface-Energy-Balance...')
    sebSinglePlot
end

if tempSwitch == 1
    disp('Plot Surface Temperatures...')
    tempPlot
end







        