#!/bin/ksh -l
#-------------------------------------------------------------------------------
#
#
# Create namelist.jsbach
#
#
#-------------------------------------------------------------------------------
#

module unload cdo
module load cdo/1.6.7

#-- specification part --
forcing_frequency=TIMESTEP	# time step of forcing (TIMESTEP or DAILY)
ntiles=1
timeoffset=0
lcc_forcing_type=none		# scheme for landuse change (none, maps, transitions)
lcc_scheme=1                  # Carbon pool scheme for landuse change (i.e. in simulations with lcc_forcing_type=transitions)
                              #   (1 = litter (original), 2 = anthropogenic)
expid=rev309
localtime=false			# forcing data timeaxis is local time (false: GMT)
debug=false			# write debug information 
dynveg=false       		# activate dynamic vegetation
nitrogen=false            	# activate nitrogen cycling
disturbance=false             # calculate disturbances (fires, windbreaks) [required for dynveg!]
co2_forcing=kg_per_kg
qair_type=QAIR                # type of input data used for forcing by atm. humidity (none/RH/QAIR)
precip_in_mm_per_day=false     # precipitation input in mm/day (true) or kg/m^2/s (false)
yasso=false                   # use yasso soil carbon scheme rather than cbalance
nsoil=5                    # Number of soil layers (>1 layer requires a jsbach.nc file with the according number of layers)
jsb_out_filetype=1
cdo=cdo


code_dir=./cosmos-landveg 
jobdir=${code_dir}/contrib/jsbach-site ;			# script directory


# includes lib_site-level-functions_global.ksh such that the functions can be used in the following
. ${jobdir}/lib_site-level-functions_global.ksh
. ${jobdir}/lib_site-level-functions_individual-sites.ksh


data=/scratch/local2/u300340/experiments
exphome=${data}/${expid}
mainworkdir=${exphome}/work
[[ -d ${mainworkdir} ]] || mkdir -p ${mainworkdir}

forcingfile=forcing.dice.10years.60min.nc
forcing_file_realrun=forcing.dice.3days.10min.nc


echo %%%%%%%%%%%%%%%%%%%%%% COPYING FORCING-FILES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cp $forcingfile forcing_1990.nc
cp $forcingfile forcing_1991.nc
cp $forcingfile forcing_1992.nc
cp $forcingfile forcing_1993.nc
cp $forcingfile forcing_1994.nc
cp $forcingfile forcing_1995.nc
cp $forcingfile forcing_1996.nc
cp $forcingfile forcing_1997.nc
cp $forcingfile forcing_1998.nc
cp $forcingfile forcing_1999.nc




setup_jsbach_namelist ${jobdir} ${mainworkdir} ${forcing_frequency} ${qair_type} ${precip_in_mm_per_day} SED_TILES \
    ${jsb_out_filetype} ${debug} ${disturbance} ${dynveg} ${nitrogen} ${lcc_forcing_type} ${lcc_scheme} ${yasso} ${nsoil} "" ${co2_forcing}

# 
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
# 1. initial JSBACH simulation
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%
# to accumulate phenological triggers and equilibriate water cycle. This 
# provides the input for C cycle equilibration. 
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


nsdt=3600               	# time step in seconds
writefreq_spin=309571200        # output during spin-up (in seconds)



startyear=1990
endyear=1999

  #-- set date variables
  startdate=${startyear}0101       # start of run
 # enddate=${endyear}1231           # end ofs run
  (( nextyear = endyear + 1 ))
  nextdate=${nextyear}0101         # start of following run
  (( prevyear = startyear - 1 ))
  prevdate=${prevyear}1231         # date of restart file






    read_cpool=false; read_fpc=false; read_npool=false; read_ndepo=false; restart=false
    update_jsbach_namelist \
          ${code_dir} ${mainworkdir} ${expid} ${startdate} ${nextdate} ${nsdt} \
          ${writefreq_spin} ${restart} ${read_cpool} ${read_fpc} ${read_npool} ${read_ndepo} ${localtime} ${timeoffset} ${ntiles}


    varlist="LAI_yDayMean NPP_yDayMean topSoilTemp_yDayMean alpha_yDayMean"

    set_stream_elements ${code_dir} ${disturbance} ${dynveg} ${lcc_forcing_type} ${yasso} ${varlist} ${vars_for_disturbance} ${vars_for_dynveg} ${vars_for_yasso}
        
cat namelist.jsbach | sed  's/years/seconds/g' > a;mv a namelist.jsbach
cat namelist.jsbach | sed  's/PUTRERUN=1/PUTRERUN=309549600/g' >a; mv a namelist.jsbach #(7*365+2*366+295+18/24)*24*3600       
cat namelist.jsbach | sed  's/DT_STOP=1999 12 31 23 00 00/DT_STOP=1999 10 23 21 00 00/g' >a; mv a namelist.jsbach 
cp namelist.jsbach namelist.jsbach1
#exit

echo %%%%%%%%%%%%%%%%%%%%%% START INITIAL RUN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
./jsbach.x
echo %%%%%%%%%%%%%%%%%%%%%% INITIAL RUN COMPLETED %%%%%%%%%%%%%%%%%%%%%%%%%%%
#exit
rm -f rev309_199*
rm -f forcing_199*

#cp jsbach.most_fun.EV.true.x jsbach.x
cp $forcing_file_realrun forcing_1999.nc

#-- modifiy date stamp of restart file 
#      touch_rerun_files ${expid} ${prevdate} ${nsdt}




# %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
# 2. actual JSBACH experiment
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%
# real run
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


nsdt=600 
writefreq_out=600         # final output frequency in seconds
restart=true


startyear=1999
endyear=1999

  #-- set date variables
  startdate=${startyear}0101       # start of run
 # enddate=${endyear}1231           # end of run
  (( nextyear = endyear + 1 ))
  nextdate=${nextyear}0101         # start of following run
  (( prevyear = startyear - 1 ))
  prevdate=${prevyear}1231         # date of restart file

       
list_of_variables_for_final_output="sensible_heat_flx  net_radiation ground_heat_flux water_balance surface_qair\
       surface_temperature  latent_heat_flx  transpiration soil_temperature albedo\
       evapotranspiration  canopy_cond_limited  canopy_conductance csat_transpiration cair csat\
       soil_moisture  runoff  lai  apar_acc  par_acc  CO2_conc_leaf drainage precip_acc\
       net_assimilation  boxC_litter_wood  boxC_green  boxC_woods skin_evaporation\
       boxC_reserve  boxC_litter_green_bg  boxC_slow  boxC_litter_green_ag \
       CO2_flux_net  box_soil_respiration  NPP_act_yDayMean  air_temp wetskin_fract\
       precip_rain  precip_snow  spec_humidity  frac_PAR_diffuse skin_reservoir\
       rad_sw_down_pot  wind_speed  zchl_acc  cdrag_acc  growth_temperature \
       vapor_pressure rad_PAR_down rad_NIR_down CO2_concentr bare_soil_evaporation\
       czenith_acc evap_act2pot geopot_acc lwdown_acc nir_net_acc albedo_nir albedo_vis
       cover_fract veg_ratio_max rad_lw_down ustar_acc rad_sw_down air_pressure"

  #-- update namelist
  restart=true
  update_jsbach_namelist \
          ${code_dir} ${mainworkdir} ${expid} ${startdate} ${nextdate} ${nsdt} \
          ${writefreq_out} ${restart} ${read_cpool} ${read_fpc} ${read_npool} ${read_ndepo} ${localtime} ${timeoffset} ${ntiles}

  set_stream_elements ${code_dir} ${disturbance} ${dynveg} ${lcc_forcing_type} ${yasso} ${list_of_variables_for_final_output}


substreams="driving forcing jsbach veg"
vtime=184000
nstep=515919 #  (7*365+2*366+295+18/24)*24*6+3
#vtime=170000
#nstep=85986 #  (7*365+2*366+295+18/24)*24*1+3
for substream in ${substreams}; do
  ncatted -O -a vtime,global,m,l,${vtime} restart_${expid}_${substream}.nc
 ncatted -O -a nstep,global,m,l,${nstep} restart_${expid}_${substream}.nc
  ncatted -O -a timestep,global,m,l,${nsdt} restart_${expid}_${substream}.nc
done


cat namelist.jsbach | sed  's/DT_STOP=1999 12 31 23 50 00/DT_STOP=1999 10 26 18 50 00/g' >a; mv a namelist.jsbach   
echo %%%%%%%%%%%%%%%%%%%%%% START REAL RUN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
./jsbach.x
echo %%%%%%%%%%%%%%%%%%%%%% REAL RUN COMPLETED %%%%%%%%%%%%%%%%%%%%%%%%%%%




# %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
# 3. postprocessing 
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%
# ...
# %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

echo %%%%%%%%%%%%%%%%%%%%%% START POST-PROCESSING %%%%%%%%%%%%%%%%%%%%%%%%%%%


for stream in land jsbach driving forcing veg; do
mv ${expid}_199910.23_$stream ${expid}_199910.01_$stream
mv ${expid}_199910.23_$stream.codes ${expid}_199910.01_$stream.codes
done

# join output files and generate additional output variables
    merge_jsb_output ${expid} 1 "" "" ${yasso}
    #generate_additional_vars 
   if [ $writefreq_out -eq 600 ] ; then
      mv jsbach.all.nc jsbach.10min.nc
      $cdo -s -daymean jsbach.10min.nc jsbach.daily.nc
   fi

   if [ $writefreq_out -eq 60 ] ; then
      mv jsbach.all.nc jsbach.1min.nc
      $cdo -s -daymean jsbach.1min.nc jsbach.daily.nc
   fi

   if [ $writefreq_out -eq 3600 ] ; then
      mv jsbach.all.nc jsbach.60min.nc
      $cdo -s -daymean jsbach.60min.nc jsbach.daily.nc
   fi

    if [ $writefreq_out -eq 86400 ] ; then
      mv jsbach.all.nc jsbach.daily.nc
    fi

rm TMP*.nc
rm -f re*
rm forcing_199*
rm na*
rm jsbach.daily.nc
rm jsbach.veg.nc













