
function outdata=changedt(dt,dt_orig,data)
    
    minute = 60;

    % timestep ratio
    dtr = dt_orig/dt; 
    if dt < dt_orig
        disp(char(strcat('Changing timestep from',{' '},num2str(dt_orig/minute),...
            {' '},'min to',{' '},num2str(dt/minute),{' '},'min by interpolating.')))
        data_interpol = nan(size(data,1)*dtr-(dtr-1),size(data,2));
        data_interpol(1:dtr:end,:) = data;
        for i=2:dtr
            data_interpol(i:dtr:end,:) = data(1:end-1,:)+(data(2:end,:)-data(1:end-1,:))*(i-1)/dtr;
        end
        outdata = [data_interpol;repmat(data_interpol(end,:),dtr-1,1)];

    elseif dt > dt_orig
        disp(char(strcat('Changing timestep from',{' '},num2str(dt_orig/minute),...
            {' '},'min to',{' '},num2str(dt/minute),{' '},'min by averaging.')))
        dtr = 1/dtr;
        data_mean = nan(size(data,1)/(dtr),size(data,2));
        for j=1:size(data,2)
            data_mean(:,j) = mean(reshape(data(:,j),dtr,[]));
        end
        outdata = data_mean;
    else
        disp('Input and output time step are the same: No computation accomplished')
        outdata = data;
    end

end

