
% Specifying time constant fields
lat(1:ny) = -9999;
lon(1:nx) = -9999;
lat(1)    = lat_exp;
lon(1)    = lon_exp;
timevec   = datevec((0:nt-1)*dt/day+datenum(startdate,'yyyymmdd'));
timevec   = timevec(1:end,:);
time      = timevec(:,1)*10000+timevec(:,2)*100+timevec(:,3)+timevec(:,4)/(day/hour)+timevec(:,5)/(day/hour)/minute;

% Initialization
ntime=length(time);

% Intialize time series
tair    = -9999*ones(nx,ny,ntime);
qair    = -9999*ones(nx,ny,ntime);
wind    = -9999*ones(nx,ny,ntime);
rainf   = -9999*ones(nx,ny,ntime);
swdown  = -9999*ones(nx,ny,ntime);
lwdown  = -9999*ones(nx,ny,ntime);
co2     = -9999*ones(nx,ny,ntime);

indata(indata(:,3)<eps_wind,3) = eps_wind;

% Convert time series
tair(1,1,:)    = indata(:,1)-273.15;
qair(1,1,:)    = indata(:,6);
wind(1,1,:)    = indata(:,2);
rainf(1,1,:)   = indata(:,3);
swdown(1,1,:)  = indata(:,4);
lwdown(1,1,:)  = indata(:,5);
co2(1,1,:)     = 3.713e-4;

% Create a netCDF file.
ncid = netcdf.create(ncfilename,'CLOBBER');

% Define dimensions
timedimid   = netcdf.defDim(ncid,'time',ntime);
xdimid      = netcdf.defDim(ncid,'lon',nx);
ydimid      = netcdf.defDim(ncid,'lat',ny);

% Define variables
timeid = netcdf.defVar(ncid,'time','double', ...
    [timedimid]);
netcdf.putAtt(ncid,timeid,'units','day as %Y%m%d.%f');
netcdf.putAtt(ncid,timeid,'calendar','proleptic_gregorian');

latid = netcdf.defVar(ncid,'lat','double', ...
    [ydimid]);
netcdf.putAtt(ncid,latid,'long_name','latitude');
netcdf.putAtt(ncid,latid,'units','degrees_north');
netcdf.putAtt(ncid,latid,'standard_name','latitude');

lonid = netcdf.defVar(ncid,'lon','double', ...
    [xdimid]);
netcdf.putAtt(ncid,lonid,'long_name','longitude');
netcdf.putAtt(ncid,lonid,'units','degrees_east');
netcdf.putAtt(ncid,lonid,'standard_name','longitude');

tairid = netcdf.defVar(ncid,'air_temp','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,tairid,'long_name','Air Temperature');
netcdf.putAtt(ncid,tairid,'units','degC');

qairid = netcdf.defVar(ncid,'qair','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,qairid,'long_name','Specific Humidity');
netcdf.putAtt(ncid,qairid,'units','kg/kg');

windid = netcdf.defVar(ncid,'wspeed','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,windid,'long_name','Wind speed');
netcdf.putAtt(ncid,windid,'units','m/s');

rainfid = netcdf.defVar(ncid,'precip','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,rainfid,'long_name','Precipitation (Snow+Rain)');
netcdf.putAtt(ncid,rainfid,'units','kg/m2/s');

swdownid = netcdf.defVar(ncid,'shortwave','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,swdownid,'long_name','Shortwave downward radiation');
netcdf.putAtt(ncid,swdownid,'unit','W/m2');

lwdownid = netcdf.defVar(ncid,'longwave','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,lwdownid,'long_name','Longwave downward radiation');
netcdf.putAtt(ncid,lwdownid,'unit','W/m2');

co2id = netcdf.defVar(ncid,'CO2','double', ...
    [xdimid ydimid timedimid]);
netcdf.putAtt(ncid,co2id,'long_name','atmospheric CO2 concentration');
netcdf.putAtt(ncid,co2id,'unit','micromol/m3');

netcdf.putAtt(ncid,netcdf.getConstant('NC_GLOBAL'),'Origin','Hamburg Wettermast')
netcdf.putAtt(ncid,netcdf.getConstant('NC_GLOBAL'),'Conversion software','prep_wmast2svat.m')

netcdf.endDef(ncid)

% Write data to variable.
netcdf.putVar(ncid,timeid,time);
netcdf.putVar(ncid,lonid,lon);
netcdf.putVar(ncid,latid,lat);
netcdf.putVar(ncid,tairid,tair);
netcdf.putVar(ncid,qairid,qair);
netcdf.putVar(ncid,windid,wind);
netcdf.putVar(ncid,rainfid,rainf);
netcdf.putVar(ncid,swdownid,swdown);
netcdf.putVar(ncid,lwdownid,lwdown);
netcdf.putVar(ncid,co2id,co2);

% Close netcdf-file
netcdf.close(ncid)
