function [szas,ftran,fabs,fref] = plot_ref(ilai,ialb,spec,scene)
%PLOT_REF  Plot reference Monte Carlo results on an existing figure
%  plot_ref(ilai,ialb,spec,scene)
%  Loads and plots the relevant file from the RAMI4PILPS directory,
%  according to the function arguments:
%    ilai     index to the Leaf Area Index: 1-3
%    ialb     index to the surface albedo: 1-3, corresponding to BLK, MED, SNW surfaces
%    spec     spectral interval: 'VIS' or 'NIR'
%    scene    vegetation scene type: 'OFC' (open forest canopy) or 'SHR' (shrubland)
%  Author: Robin Hogan <r.j.hogan@ecmwf.int>

szas = [27 60 83];
if nargin < 3
  % Just return the solar zenith angles of the reference calculations
  return
elseif nargin < 4
  scene = 'OFC';
end

albedo_codes = {'BLK','MED','SNW'};
if strcmp(scene,'OFC')
  lai_codes = {'050','150','250'};
else
  lai_codes = {'025','050','100'};
end

param_codes = {'ftran','fabs','fref'};
cols = {'b','g','r'};

for ii = 1:length(param_codes)
  for isza = 1:length(szas)
    file = ['RAMI4PILPS/' param_codes{ii} '_RAMI4PILPSREF-' scene lai_codes{ilai} '_' albedo_codes{ialb} '_UNI_' spec '_' num2str(szas(isza)) '.mes'];
    disp(['  Loading ' file]);
    data = load(file);
    eval([param_codes{ii} '(isza) = data(1)./100;']);
    plot(szas(isza), data(1)./100,[cols{ii} 'o'])
  end
end
