/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::radar

Description
    Simulating a radar.

SourceFiles
    radar.C

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#ifndef radar_H
#define radar_H

#include "primitiveFieldsFwd.H"
#include "volFieldsFwd.H"
#include "HashSet.H"
#include "Tuple2.H"
#include "OFstream.H"
#include "Switch.H"
#include "pointFieldFwd.H"
#include "areaFields.H"
#include "volFields.H"


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    class objectRegistry;
    class mapPolyMesh;
/*---------------------------------------------------------------------------*\
                           Class enery Declaration
\*---------------------------------------------------------------------------*/

class radar
{
public:
    enum intensity_criterion {sum_velocity, sum_volume, sum_momentum, max_velocity, max_height, div_momentum};


protected:

    // Private data

        const objectRegistry &obr_;

        //- The file for results
        autoPtr<OFstream> radarFilePtr_;

        //- Switch to send output to Info as well as to file
        Switch log_;

        vector pos_;

        scalar dx_;

        scalar xmin_;

        scalar xmax_;

        scalar hmin_;

        label n_gates_;

        intensity_criterion intensity_;

    // Private Member Functions

        //- Disallow default bitwise copy construct
        radar(const radar&);

        //- Disallow default bitwise assignment
        void operator=(const radar&);

public:

    //- Runtime type information
        TypeName("radar");


    // Constructors

        //- Construct for given objectRegistry and dictionary.
        //  Allow the possibility to load fields from files
        radar
        (
            const word& name,
            const objectRegistry&,
            const dictionary&,
            const bool loadFromFiles = false
        );


    //- Destructor
        virtual ~radar();


    // Member Functions

        //- Read the energy data
        virtual void read(const dictionary&);

        //- Execute
        virtual void execute();

        //- Execute at the final time-loop
        virtual void end();

        //- Write the energy
        virtual void write();

        //- Update for changes of mesh
        virtual void updateMesh(const mapPolyMesh&)
        {}

        //- Update for changes of mesh
        virtual void movePoints(const pointField&)
        {}

};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
