/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::cfdfunction

Description
    A helper class to handle all cfd operations

SourceFiles
    cfdfunction.C

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#ifndef cfdfunction_H
#define cfdfunction_H

#include "primitiveFieldsFwd.H"
#include "volFieldsFwd.H"
#include "HashSet.H"
#include "Tuple2.H"
#include "OFstream.H"
#include "Switch.H"
#include "pointFieldFwd.H"
#include "areaFields.H"
#include "edgeFields.H"
#include "uniformDimensionedFields.H"


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    class objectRegistry;
    class mapPolyMesh;
/*---------------------------------------------------------------------------*\
                           Class enery Declaration
\*---------------------------------------------------------------------------*/

class cfdfunction
{
public:


protected:

    // Private data
        const areaVectorField &Us_;
        const areaScalarField &h_;
        const areaVectorField &tau_;
        const areaVectorField &pbn_;
        const uniformDimensionedVectorField &g_;
        const dimensionedScalar &rho_;
        const edgeScalarField &phi2s_;

    // Private Member Functions

        //- Disallow default bitwise copy construct
        cfdfunction(const cfdfunction&);

        //- Disallow default bitwise assignment
        void operator=(const cfdfunction&);

public:


    // Constructors

        //- Construct for given objectRegistry and dictionary.
        //  Allow the possibility to load fields from files
        cfdfunction
        (const areaVectorField &Us,
            const areaScalarField &h,
            const areaVectorField &tau,
            const areaVectorField &pbn,
            const uniformDimensionedVectorField &g,
            const dimensionedScalar &rho,
            const edgeScalarField &phi2s
        );

        void calcLoss(areaScalarField &loss);
        void calcHUResidual3D(areaVectorField &hUsRes);
        void calcHUResidual(areaVectorField &hUsRes);
        void calcHUResidualN(areaVectorField &hUsRes);

    //- Destructor
        virtual ~cfdfunction();

};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
