/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#include "frictionModel.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(frictionModel, 0);
    defineRunTimeSelectionTable(frictionModel, dictionary);
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::frictionModel::frictionModel
(
    const word& name,
    const dictionary& frictionProperties,
    const areaVectorField &Us,
    const areaScalarField &h,
    const areaScalarField &p)
:
    name_(name),
    frictionProperties_(frictionProperties),
    rho_(frictionProperties_.lookup("rho")),
    u0_(frictionProperties_.lookup("u0")),
    h0_(frictionProperties_.lookup("h0")),
    Us_(Us),
    h_(h),
    p_(p),
    tauSp_
    (
        IOobject
        (
            name,
            Us_.time().timeName(),
            Us_.db(),
            IOobject::NO_READ,
            IOobject::NO_WRITE
        ),
        Us_.mesh(),
        dimensionedScalar("one", dimensionSet(0, 1, -1, 0, 0, 0, 0), 0)
    ),
    tauSc_
    (
      IOobject
      (
          name,
          Us_.time().timeName(),
          Us_.db(),
          IOobject::NO_READ,
          IOobject::NO_WRITE
      ),
      Us_.mesh(),
      dimensionedVector("one", dimensionSet(0, 2, -2, 0, 0, 0, 0), vector(0, 0, 0))
  )
{

    Info<< "    with " << endl
        << "    " << rho_ << endl
        << "    " << u0_ << endl
        << "    " << h0_ << endl;

}


// * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * * //


bool Foam::frictionModel::read(const dictionary& frictionProperties)
{
    frictionProperties_ = frictionProperties;

    return true;
}


// ************************************************************************* //
