/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::frictionModels::PoliquenForterre

Description
    A PoliquenForterre friction model.

SourceFiles
    PoliquenForterre.C

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#ifndef PoliquenForterre_H
#define PoliquenForterre_H

#include "frictionModel.H"
#include "dimensionedScalar.H"
#include "volFields.H"
#include "IOdictionary.H"
#include "typeInfo.H"
#include "runTimeSelectionTables.H"
#include "dimensionedScalar.H"
#include "tmp.H"
#include "autoPtr.H"
#include "faMatrices.H"
#include "uniformDimensionedFields.H"



// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace frictionModels
{

/*---------------------------------------------------------------------------*\
                           Class PoliquenForterre Declaration
\*---------------------------------------------------------------------------*/

class PoliquenForterre
:
    public frictionModel
{
    // Private data

    //PoliquenForterre firction parameter L
    dimensionedScalar L_;

    //PoliquenForterre firction parameter beta
    dimensionedScalar beta_;

    //PoliquenForterre firction parameter zeta1
    dimensionedScalar zeta1_;

    //PoliquenForterre firction parameter zeta2
    dimensionedScalar zeta2_;

    //PoliquenForterre firction parameter zeta3
    dimensionedScalar zeta3_;

    //PoliquenForterre firction parameter zeta3
    dimensionedScalar gamma_;

    //mu effective
    mutable areaScalarField mu_;

    //gravity constant
    uniformDimensionedVectorField g_;
public:

    //- Runtime type information
    TypeName("PoliquenForterre");


    // Constructors

        //- construct from components
        PoliquenForterre
        (
            const word& name,
            const dictionary& frictionProperties,
            const areaVectorField &Us,
            const areaScalarField &h,
            const areaScalarField &p
        );


    // Destructor

        virtual ~PoliquenForterre()
        {}


    // Member Functions

        //- Return explicit coefficients for the linear system of equatiosn considering friction
        virtual const areaVectorField &tauSc() const;

        //- Return implicit coefficients for the linear system of equatiosn considering friction
        virtual const areaScalarField &tauSp() const;


        //- Return the friction properties dictionary
        virtual bool read(const dictionary& frictionProperties);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace frictionModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
