/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::frictionModels::ManningStrickler

Description
    A ManningStrickler friction model.

SourceFiles
    ManningStrickler.C

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#ifndef ManningStrickler_H
#define ManningStrickler_H

#include "frictionModel.H"
#include "dimensionedScalar.H"
#include "volFields.H"
#include "IOdictionary.H"
#include "typeInfo.H"
#include "runTimeSelectionTables.H"
#include "dimensionedScalar.H"
#include "tmp.H"
#include "autoPtr.H"
#include "faMatrices.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace frictionModels
{

/*---------------------------------------------------------------------------*\
                           Class DaryWeisbach Declaration
\*---------------------------------------------------------------------------*/

class ManningStrickler
:
    public frictionModel
{
    // Private data

    dimensionedScalar n_;
    dimensionedScalar g_;
public:

    //- Runtime type information
    TypeName("ManningStrickler");


    // Constructors

        //- construct from components
        ManningStrickler
        (
            const word& name,
            const dictionary& frictionProperties,
            const areaVectorField &Us,
            const areaScalarField &h,
            const areaScalarField &p
        );


    // Destructor

        virtual ~ManningStrickler()
        {}


    // Member Functions

        //- Return explicit coefficients for the linear system of equatiosn considering friction
        virtual const areaVectorField &tauSc() const;

        //- Return implicit coefficients for the linear system of equatiosn considering friction
        virtual const areaScalarField &tauSp() const;


        //- Return the friction properties dictionary
        virtual bool read(const dictionary& frictionProperties);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace frictionModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
