IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);


autoPtr<frictionModel> friction
(
    frictionModel::New("frictionModel", transportProperties, Us, h, pb)
);

dimensionedScalar hmin(transportProperties.lookup("hmin"));

dimensionedScalar hminflux(transportProperties.lookup("hminflux"));

Switch pressureFeedback(transportProperties.lookup("pressureFeedback"));


Info << "Running with" << endl
     << "    hmin " << hmin << endl
     << "    hminflux " << hminflux << endl
     << "    pressureFeedback is " << pressureFeedback << endl << endl;
