/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::entrainmentModels::ErrosionEnergy

Description
    An entrainment model following the errosion energy apporach
    (see Rauter et al. 2016).

SourceFiles
    Erosionenergy.C

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#ifndef Erosionenergy_H
#define Erosionenergy_H

#include "entrainmentModel.H"
#include "dimensionedScalar.H"
#include "volFields.H"
#include "IOdictionary.H"
#include "typeInfo.H"
#include "runTimeSelectionTables.H"
#include "dimensionedScalar.H"
#include "tmp.H"
#include "autoPtr.H"
#include "faMatrices.H"



// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace entrainmentModels
{

/*---------------------------------------------------------------------------*\
                           Class Erosionenergy Declaration
\*---------------------------------------------------------------------------*/

class Erosionenergy
:
    public entrainmentModel
{
    // Private data

        //Specific erroision energy parameter e_b
        dimensionedScalar eb_;

        //Pointer to the gravitation fields
        const areaVectorField &gs_;
        const areaScalarField &gn_;

public:

    //- Runtime type information
    TypeName("Erosionenergy");


    // Constructors

        //- construct from components
        Erosionenergy
        (
            const word& name,
            const dictionary& frictionProperties,
            const areaVectorField &Us,
            const areaScalarField &h,
            const areaScalarField &hentrain,
            const areaScalarField &pb,
            const areaVectorField &tau
        );


    // Destructor

        virtual ~Erosionenergy()
        {}


    // Member Functions

        //- Return the Source by entrainment
        virtual const areaScalarField &Sm() const;

        //- Read entrainmentProperties dictionary
        virtual bool read(const dictionary& entrainmentProperties);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace frictionModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
