/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#include "kt.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace frictionModels
{
    defineTypeNameAndDebug(kt, 0);
    addToRunTimeSelectionTable(frictionModel, kt, dictionary);
}
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::frictionModels::kt::kt
(const word& name,
    const dictionary& frictionProperties,
    const areaVectorField &Us,
    const areaScalarField &h,
    const areaScalarField &p)
:
    frictionModel(name, frictionProperties, Us, h, p),
    mu_(frictionProperties_.subDict("ktCoeffs").lookup("mu")),
    chi_(frictionProperties_.subDict("ktCoeffs").lookup("chi"))
{
    Info<< "    " << mu_ << endl
        << "    " << chi_ << endl << endl;

}


// * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * * //


const Foam::areaVectorField &Foam::frictionModels::kt::tauSc() const
{
    tauSc_.internalField() = vector(0, 0, 0);

    return tauSc_;
}

const Foam::areaScalarField &Foam::frictionModels::kt::tauSp() const
{
    tauSp_.internalField() = 0;
    areaScalarField u = mag(Us_);
    dimensionedScalar lambda = dimensionedScalar("g", dimensionSet(0, 1, -2, 0, 0, 0, 0), 9.81)/chi_;

    /*Coulomb Part*/
    tauSp_ += 1./rho_ * p_ * mu_ *
              1./(u + u0_);

    /*Kinetic Part*/
    tauSp_ += lambda *
            u/(sqr(h_)+h0_*dimensionedScalar("1", h0_.dimensions(), 1));

    return tauSp_;
}

bool Foam::frictionModels::kt::read
(
    const dictionary& frictionProperties
)
{
    frictionModel::read(frictionProperties);
    return true;
}


// ************************************************************************* //
