/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | faSavageHutterFOAM
    \\  /    A nd           | Copyright (C) 2017 Matthias Rauter
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Author
    Matthias Rauter matthias.rauter@uibk.ac.at

\*---------------------------------------------------------------------------*/

#include "Voellmy.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace frictionModels
{
    defineTypeNameAndDebug(Voellmy, 0);
    addToRunTimeSelectionTable(frictionModel, Voellmy, dictionary);
}
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::frictionModels::Voellmy::Voellmy
(const word& name,
    const dictionary& frictionProperties,
    const areaVectorField &Us,
    const areaScalarField &h,
    const areaScalarField &p)
:
    frictionModel(name, frictionProperties, Us, h, p),
    mu_(frictionProperties_.subDict("VoellmyCoeffs").lookup("mu")),
  xi_(frictionProperties_.subDict("VoellmyCoeffs").lookup("xi"))
{
    Info<< "    " << mu_ << endl
        << "    " << xi_ << endl << endl;

}


// * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * * //


const Foam::areaVectorField &Foam::frictionModels::Voellmy::tauSc() const
{
    tauSc_.internalField() = vector(0, 0, 0);

    return tauSc_;
}

const Foam::areaScalarField &Foam::frictionModels::Voellmy::tauSp() const
{
    tauSp_.internalField() = 0;
    areaScalarField u = mag(Us_);
    dimensionedScalar lambda = rho_*dimensionedScalar("g", dimensionSet(0, 1, -2, 0, 0, 0, 0), 9.81)/xi_;

    /*Coulomb Part*/
    tauSp_ += 1./rho_ * p_ * mu_ *
              1./(u + u0_);

    /*Kinetic Part*/
    tauSp_ += 1./rho_ * lambda * u;

    return tauSp_;
}

bool Foam::frictionModels::Voellmy::read
(
    const dictionary& frictionProperties
)
{
    frictionModel::read(frictionProperties);

    //frictionProperties_.lookup("nu") >> nu0_;

    return true;
}


// ************************************************************************* //
