#!/bin/bash

parflowOutputDir=$1
runname=$2
forcingDir=$3
restartStep=$4
timeDump=$5
numRestarts=$6
parflowDir=$7
numncfiles=$8

#assumes / is at the end of the directory name:
parflowOutputDir=$(echo "${parflowOutputDir}")

archiveOutputDir="${parflowOutputDir}_archive"
echo $archiveOutputDir

if [[ -d $archiveOutputDir ]]; then
    echo 'archive dir already exists! Exiting..'
    exit 1234
fi
cp -r $parflowOutputDir $archiveOutputDir
wait
count=$(ls *.nc | wc -l)
if (( $count!=$numncfiles )); then
    echo '$count does not equal the number of nc files that should be created! Exiting..'
    exit 1234
fi

#create directories
mkdir $archiveOutputDir/ctrl
mkdir $archiveOutputDir/ics
mkdir $archiveOutputDir/geo
mkdir $archiveOutputDir/logs
mkdir $archiveOutputDir/postpro
mkdir $archiveOutputDir/restart

#move output to directories
cp $parflowDir/pfsimulator/bin/parflow $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*.tcl $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*.py $archiveOutputDir/ctrl/.
mv $archiveOutputDir/drv_*.dat $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*.job* $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*.ini $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*.ncl* $archiveOutputDir/ctrl/.
mv $archiveOutputDir/pf*.so $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*pfsol $archiveOutputDir/ctrl/.
mv $archiveOutputDir/*pfidb $archiveOutputDir/ctrl/.
mv $archiveOutputDir/${runname}.out.pftcl $archiveOutputDir/ctrl/.
cp $archiveOutputDir/*.sh $archiveOutputDir/ctrl/.
mv $archiveOutputDir/${runname}.out.ics_profile.nc $archiveOutputDir/ics/.
mv $archiveOutputDir/${runname}.out.slopes_profile.nc $archiveOutputDir/geo/.
mv $archiveOutputDir/*.pfsol.tar.gz $archiveOutputDir/geo/.
mv $archiveOutputDir/clm.rst.* $archiveOutputDir/restart/.
mv $archiveOutputDir/${runname}.out.saturation_profile.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/${runname}.out.pressure_profile.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/${runname}.out.soil_profile.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/${runname}.out.porosity_profile.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/${runname}.out.permeability_profile.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/${runname}.out.surface_profile.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/DiagnosticPflVars.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/*.nc $archiveOutputDir/postpro/.
mv $archiveOutputDir/clm_* $archiveOutputDir/logs/.
cp $archiveOutputDir/*log $archiveOutputDir/logs/.
cp $archiveOutputDir/*err $archiveOutputDir/logs/.
cp $archiveOutputDir/*out $archiveOutputDir/logs/.
for ((i=0; i<=$numRestarts; i++)); do
    restartTS=$(($i*$restartStep/$timeDump))
    printf -v ts "%05d" "$restartTS"
    printf -v tsc "%04d" "$restartTS"
    mv $archiveOutputDir/${runname}.out.press.${ts}.pfb* $archiveOutputDir/restart/.
    mv $archiveOutputDir/clm.rst.${tsc}.* $archiveOutputDir/restart/.
done
#delete all other output
rm -f $archiveOutputDir/*
#tar up directories
tar -cvf $archiveOutputDir/forcing.tar $archiveOutputDir/$forcingDir
rm -rf $archiveOutputDir/$forcingDir
tar -zcvf $archiveOutputDir/ics.tar $archiveOutputDir/ics
rm -rf $archiveOutputDir/ics 
tar -zcvf $archiveOutputDir/logs.tar.gz $archiveOutputDir/logs
rm -rf $archiveOutputDir/logs
tar -zcvf $archiveOutputDir/ctrl.tar.gz $archiveOutputDir/ctrl
rm -rf $archiveOutputDir/ctrl
tar -cvf $archiveOutputDir/postpro.tar $archiveOutputDir/postpro
rm -rf $archiveOutputDir/postpro
tar -zcvf $archiveOutputDir/geo.tar $archiveOutputDir/geo
rm -rf $archiveOutputDir/geo
tar -zcvf $archiveOutputDir/restart.tar $archiveOutputDir/restart
rm -rf $archiveOutputDir/restart
#tar up directory
tar -cvf "${archiveOutputDir}.tar" $archiveOutputDir
rm -rf $archiveOutputDir
#delete everything we no longer need in original dir- can't do a rm * as we don't want to accidently delete this file
rm -rf $parflowOutputDir/${runname}*
rm -rf $parflowOutputDir/clm*
rm -rf $parflowOutputDir/*pfb*
rm -rf $parflowOutputDir/*job*
rm -rf $parflowOutputDir/*.py*
rm -rf $parflowOutputDir/*.so
rm -rf $parflowOutputDir/*.sa
rm -rf $parflowOutputDir/*pfl*
rm -rf $parflowOutputDir/*pfsol*
rm -rf $parflowOutputDir/*tcl*
rm -rf $parflowOutputDir/*.ini
rm -rf $parflowOutputDir/*.dat
rm -rf $parflowOutputDir/*log
rm -rf $parflowOutputDir/${forcingDir}
rm -rf $parflowOutputDir/*.nc

#mv the arcived and compressed dir into the original output dir:
mv "${archiveOutputDir}.tar" $parflowOutputDir/.



