# Import the ParFlow TCL package
lappend auto_path $env(PARFLOW_DIR)/bin
package require parflow
namespace import Parflow::*

pfset FileVersion 4

set NP  [lindex $argv 0]
set NQ  [lindex $argv 1]
set forceStartTime [lindex $argv 2]
set startTime [lindex $argv 3]
set endTS [lindex $argv 4]

pfset Process.Topology.P $NP 
pfset Process.Topology.Q $NQ 
pfset Process.Topology.R 1
set runname #RUNNAME#
# THE COMPUTATIONAL GRID IS A (BOX) THT CONTAINS THE MAIN PROBLEM. THIS CAN EITHER BE EXACTLY THE SIZE
# OF THE PROBLEM OR LARGER. A BOX GEOMETRY IN PARFLOW CAN BE ASIGNED BY EITHER SPECIFYING COORDINATES FOR
# TWO CORNERS OF THE BOX OR GRID SIZE AND NUMBER OF CELLS IN X,Y, AND Z.
#------------------------------------------------------------------------
# Computational Grid: It Defines The Grid Resolutions within The Domain
#------------------------------------------------------------------------
pfset ComputationalGrid.Lower.X                  0.0
pfset ComputationalGrid.Lower.Y                  0.0
pfset ComputationalGrid.Lower.Z                  0.0

set DX          #DX#
set DY          #DY#
set DZ          #DZ#

pfset ComputationalGrid.DX                       $DX
pfset ComputationalGrid.DY                       $DY
pfset ComputationalGrid.DZ                       $DZ

set NX          #NX#
set NY          #NY#
set NZ          #NZ#

pfset ComputationalGrid.NX               [ expr #CALC_NX# ]
pfset ComputationalGrid.NY               [ expr #CALC_NY# ]
pfset ComputationalGrid.NZ               [ expr #CALC_NZ# ]


#-----------------------------------------------------------------------------
# Domain
#-----------------------------------------------------------------------------
 pfset Domain.GeomName                            domain

#--------------------------------------------------------
# Indicator file 
#--------------------------------------------------------
puts "setting up"

set slope_x [pfload #SLOPEXFILE#]
set slope_y [pfload #SLOPEYFILE#]
set mannings [pfload #MANNINGSFILE#]
set specific_storage [pfload $runname.out.specific_storage.pfb]
set porosity [pfload $runname.out.porosity.pfb]
set mask [pfload $runname.out.mask.pfb]
set top [pfcomputetop $mask]

#set surface_area_of_domain [expr [pfget ComputationalGrid.DX] * [pfget ComputationalGrid.DY] * [pfget ComputationalGrid.NX] * [pfget ComputationalGrid.NY]]

#Water balance:
# change in storage = sum of fluxes
# Delta (volsubsurface + volsurface)/Delta T = Qoverland + Qevaptrans + Qsourcesink 
# Total water in domain current timestep - Total water in domain previous timestep = PFLevaptrans + PFLsurface runoff
# where L = m and T = hours

set prev_total_water_balance 0.0
for {set i $startTime} {$i <= $endTS} {incr i} {
    puts "======================================================"
    puts "Timestep $i"
    puts "======================================================"
    set total_water_in_domain 0.0

    #vol surface
    set filename [format "%s.out.press.%05d.pfb" $runname $i] 
    set pressure [pfload $filename]
    set surface_storage [pfsurfacestorage $top $pressure]
    #save surface storage
    if { $i >= $forceStartTime} {
        set outputfilename [format "%s.out.surface_storage.%05d.pfb" $runname $i]
        pfsave $surface_storage -pfb $outputfilename
    }
    set total_surface_storage [pfsum $surface_storage]
    puts "Surface storage : $total_surface_storage"
    set total_water_in_domain [expr $total_water_in_domain + $total_surface_storage]

    set filename [format "%s.out.satur.%05d.pfb" $runname $i] 
    set saturation [pfload $filename]
    
    #vol subsurface
    set subsurface_storage [pfsubsurfacestorage $mask $porosity $pressure $saturation $specific_storage]
    #save subsurface storage
    if { $i >= $forceStartTime} {
        set outputfilename [format "%s.out.subsurface_storage.%05d.pfb" $runname $i]
        pfsave $subsurface_storage -pfb $outputfilename
    } 
    set total_subsurface_storage [pfsum $subsurface_storage]
    puts "Subsurface storage : $total_subsurface_storage"
    set total_water_in_domain [expr $total_water_in_domain + $total_subsurface_storage]

    #Qoverland
    set surface_runoff [pfsurfacerunoff $top $slope_x $slope_y $mannings $pressure]
    #save surface runoff
    if { $i >= $forceStartTime} {
        set outputfilename [format "%s.out.surface_runoff.%05d.pfb" $runname $i]
        pfsave $surface_runoff -pfb $outputfilename
    }
    set total_surface_runoff [pfsum $surface_runoff]
    puts "Surface runoff : $total_surface_runoff"

    #save water table depth
    set water_table_depth [pfwatertabledepth $top $saturation]
    if { $i >= $forceStartTime} {
        set outputfilename [format "%s.out.water_table_depth.%05d.pfb" $runname $i]
        pfsave $water_table_depth -pfb $outputfilename
    }

    if { $i >= $forceStartTime} { 
        #Qevaptrans
        set filename [format "%s.out.evaptrans.%05d.silo" $runname $i]
        set evaptrans [pfload -silo $filename]
        set outputfilename [format "%s.out.evaptrans.%05d.pfb" $runname $i]
        pfsave $evaptrans -pfb $outputfilename
        set total_evaptrans [pfsum $evaptrans]
        puts "EvapTrans PFL : $total_evaptrans"
    }   

    puts "Total water in domain : $total_water_in_domain"

    if { $i >= $forceStartTime} { 
        puts [format "\tdifference from prev : %.12e" [expr $total_water_in_domain - $prev_total_water_balance]]
        set expected_difference [expr $total_evaptrans + $total_surface_runoff]
        puts [format "Expected difference\t : %.12e" $expected_difference]
        set expected_water_balance [expr $prev_total_water_balance - $expected_difference]
        puts [format "Expected total water sum\t : %.12e" $expected_water_balance]
        set percent_diff [expr abs(($total_water_in_domain - $expected_water_balance)) / $expected_water_balance * 100]
        puts [format "Percent diff from expected total water sum\t : %.12e" $percent_diff]
    }   

    set prev_total_water_balance [expr $total_water_in_domain]
}
