import numpy as np
from numpy import dtype, arange
import numpy.ma as ma
import matplotlib.pyplot as plt 
#from matplotlib.colors import LogNorm , SymLogNorm
#from mpl_toolkits.drivermap import Basemap, cm
import time
import scipy.ndimage
from subprocess import call
import sys 
#from mpi4py import MPI 
#import matplotlib.gridspec as gridspec
import datetime as dt
#from matplotlib.colors import LinearSegmentedColormap



ncpack="nc4"

if ncpack=="nc":
  from Scientific.IO.NetCDF import *
  def openNC(fileN,mode):
	return NetCDFFile(fileN,mode)

if ncpack=="nc4":
  from netCDF4 import Dataset
  def openNC(fileN,mode):
        return Dataset(fileN,mode)


class Globals:
	def __init__(self,title="",lons=None,lats=None,topo=None,titleFrames=0,splitFrames=0,imdir="",root="",fileName="",video=True,domain="nrw",vidList={},mask=None):
		self.lons=lons
		self.lats=lats
		self.topo=topo
		self.titleFrames=titleFrames
		self.splitFrames=splitFrames
		self.imdir=imdir
		self.root=root	
		self.fileName=fileName
		self.video=video
		self.domain=domain
		self.title=title
		self.vidList=vidList
		self.mask=mask
"""
                #autogenerate min, max, ticks if not set manually
                   self.rangeD.minV=np.amin(data)
                   self.rangeD.maxV=np.amax(data)
                count=7
                   dist=(self.rangeD.maxV-self.rangeD.minV)/count
                   for i in range(0,count+1):
                     self.rangeD.ticks.append(self.rangeD.minV + (i*dist))

"""

class Var:
        """represents a (netcdf) variable"""
        def __init__(self,dim,varName,vpath="",data=None,suffix=[""],gpp=[],off=0,numSteps=1,units=""):
                """Var constructor - varName and dim and are mandatory
                   Arrays are expected as dimendions: [time,layer,lat,lon]      
                   Use dim 2.5 / 3.5 for pseudo 2/3d arrays (2/3d array as 4d with single timestep) 
                   If data is passed, path and suffix is irrelevant
                   Else data is loaded from nc-file/series from path+suffixes
                """
		self.varName=varName
                self.data=data
                self.dim=dim
		self.gpp=gpp
		self.off=off
		self.numSteps=numSteps
                self.units=units
                if self.data==None:
		    self.data=[]
                    #loop over files/timesteps
		    counter=0	
                    for s in suffix:
                        ncfile = openNC(vpath+s,'r')
			#normal arrays
			#multiple timesteps with 2d data (single timestep with 3d data is not defined so far)
			if dim==3:
				for i in range(0,cfile.variables.shape[0]):
				    e=[]					
                                    self.data.append(e)
				    self.data[i].append(ncfile.variables[self.varName][off:off+numSteps,:,:]) 

			#multiple timesteps with 3d data
                        elif dim==4:
                                self.data=ncfile.variables[self.varName][off:off+numSteps,:,:,:]


			#nested arrays 
                        #single timestep with 2d data packt in 1d time dimension
			if counter >= off and counter<off+numSteps:
                            if dim==2.5:
                                self.data.append(ncfile.variables[self.varName][:,:,:])
                        #single timestep with 3d data packt in 1d time dimension
                            elif dim==3.5:
                                self.data.append(ncfile.variables[self.varName][0,:,:,:])
                        ncfile.close()
			counter+=1
		    self.data=np.array(self.data)
		print str(self.data.shape) + " ; init  ; " +varName		
		for p in gpp:
		    p(self)	
	'''	 
        def getTs(self):    
		return range(0,self.numSteps)	

                if self.dim==2.0:
                        out=range(0,1)
                elif self.dim==2.5:
                        out=range(self.off,len(self.data))
                elif self.dim==3.0:
                        out=range(self.off,len(self.data[0]))
                elif self.dim==3.5:
                        out=range(self.off,len(self.data))
                elif self.dim==4.0:
                        out=range(self.off,len(self.data[0]))
                return out 
	'''
            
        def get3dArr(self,ts,l=range(0,1)):
                """returns the lat/lon dimensions of a multidimensional grid"""
                out=self.data[ts,l,:,:]

		out=np.array(out)
                return out

        def set3dArr(self,ts,l=range(0,1),dat=None):
                self.data[ts]=dat[l,:,:]

class Frame:
        def __init__(self,nr,ts,plot,vid,array={}):
                self.nr=nr
                self.array=array
                self.ts=ts
                self.plot=plot
		self.vid=vid

class Plot:
        def __init__(self,name="",plotList=[],settingList={},numSteps=1,title="",main=None, fig=None, style="solo",initDate=None,secPerStep=3600):
                self.settingList=settingList
		self.plotList=plotList
                self.title=title
                self.name=name
                self.fig=fig
                self.main=main
		self.style=style
		self.numSteps=numSteps
		self.initDate=initDate
		self.secPerStep=secPerStep

class Setting:
	def __init__(self,varName,cbar,ax,steps=range(0,1),layer=range(0,1),plotType="pcolormesh",title="",lpp=[],zo=1, m=True,withMap=True,withMapTexture=False,withLines=True):
                self.steps=steps
                self.layer=layer
		self.withMap=withMap
		self.varName=varName
		self.cbar=cbar
		self.plotType=plotType
		self.title=title
		self.ax=ax
		self.lpp=lpp
		self.zo=zo
		self.m=m
		self.withLines=withLines
		self.withMapTexture=withMapTexture

class CBar:
        def __init__(self,ax,title="",cmap=plt.cm.get_cmap(name="jet",lut=14),minV=None,maxV=None,ticks=[], ticklabels=None, norm=None,orientation="vertical",contLev=None,colors=None):
                self.ax=ax
		self.colors=colors
		self.contLev=contLev
                self.cmap=cmap
                self.norm=norm
                self.ticks=ticks
                self.title=title
                self.minV=minV
                self.maxV=maxV
                if ticklabels==None:
                  self.ticklabels=self.ticks
                else:
                  self.ticklabels=ticklabels
                self.orientation=orientation


