# Import the ParFlow TCL package
lappend auto_path $env(PARFLOW_DIR)/bin
package require parflow
namespace import Parflow::*

pfset FileVersion 4

set NP  [lindex $argv 0]
set NQ  [lindex $argv 1]
set NR 1

pfset Process.Topology.P $NP
pfset Process.Topology.Q $NQ
pfset Process.Topology.R 1
# THE COMPUTATIONAL GRID IS A (BOX) THT CONTAINS THE MAIN PROBLEM. THIS CAN EITHER BE EXACTLY THE SIZE
# OF THE PROBLEM OR LARGER. A BOX GEOMETRY IN PARFLOW CAN BE ASIGNED BY EITHER SPECIFYING COORDINATES FOR
# TWO CORNERS OF THE BOX OR GRID SIZE AND NUMBER OF CELLS IN X,Y, AND Z.
#------------------------------------------------------------------------
# Computational Grid: It Defines The Grid Resolutions within The Domain
#------------------------------------------------------------------------
pfset ComputationalGrid.Lower.X                  0.0
pfset ComputationalGrid.Lower.Y                  0.0
pfset ComputationalGrid.Lower.Z                  0.0

pfset ComputationalGrid.DX                       #DX#
pfset ComputationalGrid.DY                       #DY#
pfset ComputationalGrid.DZ                       #DZ#

set NX          #NX#
set NY          #NY#
set NZ          #NZ#

pfset ComputationalGrid.NX               [ expr #CALC_NX# ]
pfset ComputationalGrid.NY               [ expr #CALC_NY# ]
pfset ComputationalGrid.NZ               [ expr #CALC_NZ# ]

#-----------------------------------------------------------------------------
# Domain
#-----------------------------------------------------------------------------
pfset Domain.GeomName                            domain

#--------------------------------------------------------
# Indicator file 
#--------------------------------------------------------

set pattern ".*.pfb"
set fileind "#PFINDFILE#"

if ![regexp $pattern $fileind match] {
    set suffix "pfb"
    set name [string trimright $fileind ".sa"]
    set filename [format "%s.%s" $name $suffix]
    set data [pfload #PFINDFILE#]
    pfsave $data -pfb $filename
    pfdist $filename
} else {
    pfdist #PFINDFILE#
}

#--------------------------------------------------------
# Initial Conditions
#--------------------------------------------------------
if [file exists pfl_ic.sa] {
    set data [pfload -sa pfl_ic.sa]
    pfsave $data -pfb pfl_ic.pfb
}

if [file exists pfl_ic.pfb] {
    pfdist pfl_ic.pfb
}

#--------------------------------------------------------
# Slopes
#--------------------------------------------------------
pfset ComputationalGrid.NZ                       1

set filex "#SLOPEXFILE#"
set filey "#SLOPEYFILE#"

if ![regexp $pattern $filex match] {
    set suffix "pfb"
    set name [string trimright $filex ".sa"]
    set filename [format "%s.%s" $name $suffix]
    set data [pfload #SLOPEXFILE#]
    pfsave $data -pfb $filename
    pfdist $filename
} else {
    pfdist #SLOPEXFILE#
}

if ![regexp $pattern $filey match] {
    set suffix "pfb"
    set name [string trimright $filey ".sa"]
    set filename [format "%s.%s" $name $suffix]
    set data [pfload #SLOPEYFILE#]
    pfsave $data -pfb $filename
    pfdist $filename
} else {
    pfdist #SLOPEYFILE#
}


#--------------------------------------------------------
# Forcing
#--------------------------------------------------------
set forcingDimension #FORCINGDIMENSION#

if { $forcingDimension == "3D" } {
pfset ComputationalGrid.NZ			#FORCINGNT#
set name #FORCINGFILEPREFIX#
set path #FORCINGFILESPATH#
set var [list "APCP" "DLWR" "DSWR" "Press" "SPFH" "Temp" "UGRD" "VGRD"]
set start [expr #FORCINGSTEPEND#/#FORCINGNT# - #CYCLES#]
set end [expr $start + #CYCLES#]
for {set i $start} {$i < $end} {incr i} {
     foreach v $var {
      set t1 [expr $i * #FORCINGNT# + 1]
      set t2 [expr $t1 + #FORCINGNT# - 1]
      puts $t1
      puts $t2
     set filename [format "%s/%s.%s.%06d_to_%06d" $path $name $v $t1 $t2]
     puts $filename
     if ![file exists ${filename}.pfb] {
         set data [pfload -sa ${filename}.sa]
         pfsave $data -pfb ${filename}.pfb
     } 
     pfdist ${filename}.pfb
     #pfundist $filename
}
}
}

if { $forcingDimension == "2D" } {
set name #FORCINGFILEPREFIX#
set var [list "APCP" "DLWR" "DSWR" "Press" "SPFH" "Temp" "UGRD" "VGRD"]
set end #FORCINGNT#
  for {set i #FORCINGSTEPSTART#} {$i <= $end} {incr i} {
     foreach v $var {
      set t1 [expr $i ]
      puts $t1
     set filename [format "%s/%s.%s.%06d" $name $name $v $t1]
     puts $filename
     if ![file exists ${filename}.pfb] {
         set data [pfload -sa ${filename}.sa]
         pfsave $data -pfb ${filename}.pfb
     } 
     pfdist ${filename}.pfb
     #pfundist $filename
}
}
}
 
