# Import the ParFlow TCL package
lappend auto_path $env(PARFLOW_DIR)/bin
package require parflow
namespace import Parflow::*

pfset FileVersion 4

set NP  [lindex $argv 0]
set NQ  [lindex $argv 1]
set NR 1

pfset Process.Topology.P $NP
pfset Process.Topology.Q $NQ
pfset Process.Topology.R 1
# THE COMPUTATIONAL GRID IS A (BOX) THT CONTAINS THE MAIN PROBLEM. THIS CAN EITHER BE EXACTLY THE SIZE
# OF THE PROBLEM OR LARGER. A BOX GEOMETRY IN PARFLOW CAN BE ASIGNED BY EITHER SPECIFYING COORDINATES FOR
# TWO CORNERS OF THE BOX OR GRID SIZE AND NUMBER OF CELLS IN X,Y, AND Z.
#------------------------------------------------------------------------
# Computational Grid: It Defines The Grid Resolutions within The Domain
#------------------------------------------------------------------------
pfset ComputationalGrid.Lower.X                  0.0
pfset ComputationalGrid.Lower.Y                  0.0
pfset ComputationalGrid.Lower.Z                  0.0

pfset ComputationalGrid.DX                       #DX#
pfset ComputationalGrid.DY                       #DY#
pfset ComputationalGrid.DZ                       #DZ#

set NX          #NX#
set NY          #NY#
set NZ          #NZ#

pfset ComputationalGrid.NX               [ expr #CALC_NX# ]
pfset ComputationalGrid.NY               [ expr #CALC_NY# ]
pfset ComputationalGrid.NZ               [ expr #CALC_NZ# ]

#-----------------------------------------------------------------------------
# Domain
#-----------------------------------------------------------------------------
pfset Domain.GeomName                            domain

#--------------------------------------------------------
# Indicator file 
#--------------------------------------------------------

set pattern ".*.pfb"
set fileind "#PFINDFILE#"

if ![regexp $pattern $fileind match] {
    set suffix "pfb"
    set name [string trimright $fileind ".sa"]
    set filename [format "%s.%s" $name $suffix]
    set data [pfload #PFINDFILE#]
    pfsave $data -pfb $filename
    pfdist $filename
} else {
    pfdist #PFINDFILE#
}

#--------------------------------------------------------
# Slopes
#--------------------------------------------------------
pfset ComputationalGrid.NZ                       1

set filex "#SLOPEXFILE#"
set filey "#SLOPEYFILE#"

if ![regexp $pattern $filex match] {
    set suffix "pfb"
    set name [string trimright $filex ".sa"]
    set filename [format "%s.%s" $name $suffix]
    set data [pfload #SLOPEXFILE#]
    pfsave $data -pfb $filename
    pfdist $filename
} else {
    pfdist #SLOPEXFILE#
}

if ![regexp $pattern $filey match] {
    set suffix "pfb"
    set name [string trimright $filey ".sa"]
    set filename [format "%s.%s" $name $suffix]
    set data [pfload #SLOPEYFILE#]
    pfsave $data -pfb $filename
    pfdist $filename
} else {
    pfdist #SLOPEYFILE#
}

