# Import the ParFlow TCL package
#
lappend auto_path $env(PARFLOW_DIR)/bin
package require parflow
namespace import Parflow::*


#set tcl_precision 16

#-----------------------------------------------------------------------------
# File input version number
#-----------------------------------------------------------------------------
pfset FileVersion 4

#-----------------------------------------------------------------------------
# Process Topology
#-----------------------------------------------------------------------------

set NP  [lindex $argv 0]
set NQ  [lindex $argv 1]
set NR 1

pfset Process.Topology.P $NP
pfset Process.Topology.Q $NQ
pfset Process.Topology.R 1

#-----------------------------------------------------------------------------
# Computational Grid
#-----------------------------------------------------------------------------
pfset ComputationalGrid.Lower.X                0.0
pfset ComputationalGrid.Lower.Y                0.0
pfset ComputationalGrid.Lower.Z                0.0

pfset ComputationalGrid.DX                      1000.0
pfset ComputationalGrid.DY                      1000.0
pfset ComputationalGrid.DZ                       2.0

#-----------------------------------------------------------------------------
## Distribute inputs
##-----------------------------------------------------------------------------
pfset ComputationalGrid.NX                41 
pfset ComputationalGrid.NY                41 
pfset ComputationalGrid.NZ                1
pfdist #SLOPEXFILE#
pfdist #SLOPEYFILE#

pfset ComputationalGrid.NX                41 
pfset ComputationalGrid.NY                41 
pfset ComputationalGrid.NZ                50 

pfdist #PFINDFILE#
pfdist pfl_ic.pfb


pfset ComputationalGrid.NX                      41
pfset ComputationalGrid.NY                      41
pfset ComputationalGrid.NZ                      #FORCINGNT#

set name #FORCINGFILEPREFIX#
set var [list "APCP" "DLWR" "DSWR" "Press" "SPFH" "Temp" "UGRD" "VGRD"]

set end #CYCLES#
set start [expr #FORCINGSTEPEND#/#FORCINGNT# - $end]
  for {set i $start} {$i < $end} {incr i} {
     foreach v $var {
      set t1 [expr $i * #FORCINGNT# + 1]
      set t2 [ expr $t1 + #FORCINGNT# - 1]
      puts $t1
      puts $t2
     set filename [format "%s/%s.%s.%06d_to_%06d" $name $name $v $t1 $t2]
     puts $filename
     if ![file exists ${filename}.pfb] {
         set data [pfload -sa ${filename}.sa]
         pfsave $data -pfb ${filename}.pfb
     }
     pfdist ${filename}.pfb
     #pfundist $filename
}
}
