#!/bin/bash

# Quick script to tar up the archive dirs and copy them across to arch2
# to run: eg: ./taruparchivedirs.sh '/arch2/slts/slts14/SpinupResults/Geology1/Year1' 'week' 2 20 'cordexIHME' 
arch_dir=$1
period=$2
beg=$3
end=$4
runname=$5
for (( ii=$beg;ii<$end;ii++ )); do 
    rm -rf output_${ii}_archive/${runname}.out
    tar cvf output_${period}${ii}_archive.tar output_${ii}_archive
    wait
    chmod a+rwx output_${period}${ii}_archive.tar
    wait
    gborig=$(du -sch output_${ii}_archive | tail -1)
    gborig=${gborig%G*}
    gbtar=$(du -sch output_${period}${ii}_archive.tar | tail -1)
    gbtar=${gbtar%G*}
    if (( gborig-gbtar < 2 )); then
        cp output_${period}${ii}_archive.tar $arch_dir/.
	wait
        #rm output_${period}${ii}_archive.tar
    else
        echo "Something went wrong with the tar- tarred directory size doesn't match size of original directory"
        echo $gborig $gbtar
        exit 1234
    fi
done

