# Wendy Sharples 28/10/2016
# Usage: tclsh pfb2ascii.tcl cordex011_out_press_2003-05-02-00000 12500.0 12500.0 2.0 436 424 15
# Import the ParFlow TCL package
lappend auto_path $env(PARFLOW_DIR)/bin
package require parflow
namespace import Parflow::*

pfset FileVersion 4

set filename [lindex $argv 0]
set DX  [lindex $argv 1]
set DY  [lindex $argv 2]
set DZ  [lindex $argv 3]
set NX  [lindex $argv 4]
set NY  [lindex $argv 5]
set NZ  [lindex $argv 6]

pfset Process.Topology.P 1
pfset Process.Topology.Q 1
pfset Process.Topology.R 1
# THE COMPUTATIONAL GRID IS A (BOX) THT CONTAINS THE MAIN PROBLEM. THIS CAN EITHER BE EXACTLY THE SIZE
# OF THE PROBLEM OR LARGER. A BOX GEOMETRY IN PARFLOW CAN BE ASIGNED BY EITHER SPECIFYING COORDINATES FOR
# TWO CORNERS OF THE BOX OR GRID SIZE AND NUMBER OF CELLS IN X,Y, AND Z.
#------------------------------------------------------------------------
# Computational Grid: It Defines The Grid Resolutions within The Domain
#------------------------------------------------------------------------
pfset ComputationalGrid.Lower.X                  0.0
pfset ComputationalGrid.Lower.Y                  0.0
pfset ComputationalGrid.Lower.Z                  0.0

pfset ComputationalGrid.DX                       $DX
pfset ComputationalGrid.DY                       $DY
pfset ComputationalGrid.DZ                       $DZ

pfset ComputationalGrid.NX               $NX
pfset ComputationalGrid.NY               $NY
pfset ComputationalGrid.NZ               $NZ

#-----------------------------------------------------------------------------
# Domain
#-----------------------------------------------------------------------------
pfset Domain.GeomName                            domain

#--------------------------------------------------------
# file 
#--------------------------------------------------------
set data [pfload -pfb ${filename}.pfb]
pfsave $data -sa ${filename}.sa


