import numpy as np
from netCDF4 import Dataset
import sys
import os
from struct import *

#Usage: python PFBReaderToNetCDF.py LW.slopex.pfb 41 41 1 1000.0 1000.0 2.0 'SLPX'

filename = sys.argv[1]
nx = sys.argv[2]
nx = int(nx)
ny = sys.argv[3]
ny = int(ny)
nz = sys.argv[4]
nz = int(nz)
dx = sys.argv[5]
dx = float(dx)
dy = sys.argv[6]
dy = float(dy)
dz = sys.argv[7]
dz = float(dz)
variable = sys.argv[8]

# Open the file
pfbfile = open(filename, 'rb')
# Read the start index of the domain
bigEnd = pfbfile.read(8)
x1 = list(unpack('>d', bigEnd))[0]
#print(x1)
bigEnd = pfbfile.read(8)
y1 = list(unpack('>d', bigEnd))[0]
#print(y1)
bigEnd = pfbfile.read(8)
z1 = list(unpack('>d', bigEnd))[0]
#print(z1)

# Read the number of points in x, y and z direction
bigEnd = pfbfile.read(4)
gx = list(unpack('>i', bigEnd))[0]
#print(gx)
bigEnd = pfbfile.read(4)
gy = list(unpack('>i', bigEnd))[0]
#print(gy)
bigEnd = pfbfile.read(4)
gz = list(unpack('>i', bigEnd))[0]
#print(gz)

# Read dx, dy and dz
bigEnd = pfbfile.read(8)
d_x = list(unpack('>d', bigEnd))[0]
#print(d_x)
bigEnd = pfbfile.read(8)
d_y = list(unpack('>d', bigEnd))[0]
#print(dy)
bigEnd = pfbfile.read(8)
d_z = list(unpack('>d', bigEnd))[0]
#print(dz)

#check: nx, ny, nz and dx, dy, dz
print "Checking grid specifications... \n"
assert (nx == gx), "number of grid points in x direction in file " + str(nx) + " does not equal number of grid points in x direction specified " + str(gx)
assert (ny == gy), "number of grid points in y direction in file " + str(ny) + " does not equal number of grid points in y direction specified " + str(gy)
assert (nz == gz), "number of grid points in z direction in file " + str(nz) + " does not equal number of grid points in z direction specified " + str(gz)
assert (dx == d_x), "grid spacing in x direction in file " + str(dx) + " does not equal grid spacing in x direction specified " + str(d_x)
assert (dy == d_y), "grid spacing in y direction in file " + str(dy) + " does not equal grid spacing in y direction specified " + str(d_y)
assert (dz == d_z), "grid spacing in z direction in file " + str(dz) + " does not equal grid spacing in z direction specified " + str(d_z)

# Allocate array to read the data
var = np.empty([nx,ny,nz])

# Read the number of subdomains =  number of procs
bigEnd = pfbfile.read(4)
nSubGrid = list(unpack('>i', bigEnd))[0]
#print(nSubGrid)

for gridCounter in range(0, nSubGrid):
    # Read the subgrid indices and counters
    bigEnd = pfbfile.read(4)
    ix = list(unpack('>i', bigEnd))[0]
    #print(ix)
    bigEnd = pfbfile.read(4)
    iy = list(unpack('>i', bigEnd))[0]
    #print(iy)
    bigEnd = pfbfile.read(4)
    iz = list(unpack('>i', bigEnd))[0]
    #print(iz)

    bigEnd = pfbfile.read(4)
    nnx = list(unpack('>i', bigEnd))[0]
    #print(nnx)
    bigEnd = pfbfile.read(4)
    nny = list(unpack('>i', bigEnd))[0]
    #print(nny)
    bigEnd = pfbfile.read(4)
    nnz = list(unpack('>i', bigEnd))[0]
    #print(nnz)
	
    bigEnd = pfbfile.read(4)
    rx = list(unpack('>i', bigEnd))[0]
    #print(rx)
    bigEnd = pfbfile.read(4)
    ry = list(unpack('>i', bigEnd))[0]
    #print(ry)
    bigEnd = pfbfile.read(4)
    rz = list(unpack('>i', bigEnd))[0]
    #print(rz)

    # Following loop could be improved of someone knows to unpack bytes into array. e.g. if we read 4*8=32 bytes.
    # unpack them into a vector of 4 doubles. Send the imporvements to k.kulkarni@fz-juelich.de
    for kk in range(iz,iz+nnz):
	for jj in range(iy,iy+nny):
	    for ii in range(ix,ix+nnx):
		bigEnd=pfbfile.read(8)
		var[ii,jj,kk] = list(unpack('>d', bigEnd))[0] 


filenc = filename + ".nc"
ncfile = Dataset(filenc,'w')
ncfile.createDimension('lon',nx)
ncfile.createDimension('lat',ny)
if (nz > 1):
    ncfile.createDimension('lev',nz)
    data = ncfile.createVariable(variable,'f8',('lev','lat','lon'))
else:
    var = np.reshape(var,(nx,ny))
    data = ncfile.createVariable(variable,'f8',('lat','lon'))
data[:] = np.transpose(var)
ncfile.close()

