import numpy as np
from netCDF4 import Dataset
import sys
import os
from struct import *

#usage: python MakeSlopeFile.py 'ncfile' 440 240 3000.0 3000.0 2.0 'SLPX'

ncfile=sys.argv[1]
nx=sys.argv[2]
nx=int(nx)
ny=sys.argv[3]
ny=int(ny)
nz=1
dx = sys.argv[4]
dx = float(dx)
dy = sys.argv[5]
dy = float(dy)
dz = sys.argv[6]
dz = float(dz)
varNc=sys.argv[7]
var=Dataset(ncfile, 'r')
array = var.variables[varNc][:]
array = np.float64(array)
array = np.reshape(array,(nz,ny,nx))
print np.shape(array)
arrayT = np.transpose(array)
print np.shape(arrayT)
arrayCheckT = arrayT[:,0:1,0:1]
print np.shape(arrayCheckT)
arrayCheckT = np.reshape(arrayCheckT,(nx,1))
arrayCheck = array[0:1,0:1,:]
print np.shape(arrayCheck)
arrayCheck = np.reshape(arrayCheck,(nx,1))

filename='ParFlow_' + varNc + '_x' + str(nx) + 'y' + str(ny) + '.pfb'
filepfb = open(filename, 'wb')

bigbyte = pack('>d', 0)
filepfb.write(bigbyte)
bigbyte = pack('>d', 0)
filepfb.write(bigbyte)
bigbyte = pack('>d', 0)
filepfb.write(bigbyte)

bigbyte = pack('>i', nx)
filepfb.write(bigbyte)
bigbyte = pack('>i', ny)
filepfb.write(bigbyte)
bigbyte = pack('>i', nz)
filepfb.write(bigbyte)


bigbyte = pack('>d', dx)
filepfb.write(bigbyte)
bigbyte = pack('>d', dy)
filepfb.write(bigbyte)
bigbyte = pack('>d', dz)
filepfb.write(bigbyte)

gridID=1
bigbyte = pack('>i', gridID)
filepfb.write(bigbyte)

bigbyte = pack('>i', 0)
filepfb.write(bigbyte)
bigbyte = pack('>i', 0)
filepfb.write(bigbyte)
bigbyte = pack('>i', 0)
filepfb.write(bigbyte)

bigbyte = pack('>i', nx)
filepfb.write(bigbyte)
bigbyte = pack('>i', ny)
filepfb.write(bigbyte)
bigbyte = pack('>i', nz)
filepfb.write(bigbyte)


bigbyte = pack('>i', 0)
filepfb.write(bigbyte)
bigbyte = pack('>i', 0)
filepfb.write(bigbyte)
bigbyte = pack('>i', 0)
filepfb.write(bigbyte)

for kk in range(0,nz):
        for jj in range(0,ny):
                for ii in range(0,nx):
                        bigbyte = pack('>d', arrayT[ii,jj,kk])
                        filepfb.write(bigbyte)

filepfb.close()

# Open the file
pfbfile = open(filename, 'rb')
# Read the start index of the domain
bigEnd = pfbfile.read(8)
x1 = list(unpack('>d', bigEnd))[0]
#print(x1)
bigEnd = pfbfile.read(8)
y1 = list(unpack('>d', bigEnd))[0]
#print(y1)
bigEnd = pfbfile.read(8)
z1 = list(unpack('>d', bigEnd))[0]
#print(z1)

# Read the number of points in x, y and z direction
bigEnd = pfbfile.read(4)
gx = list(unpack('>i', bigEnd))[0]
#print(gx)
bigEnd = pfbfile.read(4)
gy = list(unpack('>i', bigEnd))[0]
#print(gy)
bigEnd = pfbfile.read(4)
gz = list(unpack('>i', bigEnd))[0]
#print(gz)

# Read dx, dy and dz
bigEnd = pfbfile.read(8)
d_x = list(unpack('>d', bigEnd))[0]
#print(d_x)
bigEnd = pfbfile.read(8)
d_y = list(unpack('>d', bigEnd))[0]
#print(dy)
bigEnd = pfbfile.read(8)
d_z = list(unpack('>d', bigEnd))[0]
#print(dz)

#check: nx, ny, nz and dx, dy, dz
print "Checking grid specifications... \n"
assert (nx == gx), "number of grid points in x direction in file " + str(nx) + " does not equal number of grid points in x direction specified " + str(gx)
assert (ny == gy), "number of grid points in y direction in file " + str(ny) + " does not equal number of grid points in x direction specified " + str(gy)
assert (nz == gz), "number of grid points in z direction in file " + str(nz) + " does not equal number of grid points in x direction specified " + str(gz)
assert (dx == d_x), "grid spacing in x direction in file " + str(dx) + " does not equal number of grid points in x direction specified " + str(d_x)
assert (dy == d_y), "grid spacing in y direction in file " + str(dy) + " does not equal number of grid points in x direction specified " + str(d_y)
assert (dz == d_z), "grid spacing in z direction in file " + str(dz) + " does not equal number of grid points in x direction specified " + str(d_z)

# Allocate array to read the data
var = np.empty([nx,ny,1])

# Read the number of subdomains =  number of procs
bigEnd = pfbfile.read(4)
nSubGrid = list(unpack('>i', bigEnd))[0]
#print(nSubGrid)

for gridCounter in range(0, nSubGrid):
    # Read the subgrid indices and counters
    bigEnd = pfbfile.read(4)
    ix = list(unpack('>i', bigEnd))[0]
    #print(ix)
    bigEnd = pfbfile.read(4)
    iy = list(unpack('>i', bigEnd))[0]
    #print(iy)
    bigEnd = pfbfile.read(4)
    iz = list(unpack('>i', bigEnd))[0]
    #print(iz)

    bigEnd = pfbfile.read(4)
    nnx = list(unpack('>i', bigEnd))[0]
    #print(nnx)
    bigEnd = pfbfile.read(4)
    nny = list(unpack('>i', bigEnd))[0]
    #print(nny)
    bigEnd = pfbfile.read(4)
    nnz = list(unpack('>i', bigEnd))[0]
    #print(nnz)
	
    bigEnd = pfbfile.read(4)
    rx = list(unpack('>i', bigEnd))[0]
    #print(rx)
    bigEnd = pfbfile.read(4)
    ry = list(unpack('>i', bigEnd))[0]
    #print(ry)
    bigEnd = pfbfile.read(4)
    rz = list(unpack('>i', bigEnd))[0]
    #print(rz)

    # Following loop could be improved of someone knows to unpack bytes into array. e.g. if we read 4*8=32 bytes.
    # unpack them into a vector of 4 doubles. Send the imporvements to k.kulkarni@fz-juelich.de
    # set nnz to 1 as we only need first timestep
    nnz =  1
    for kk in range(iz,iz+nnz):
	for jj in range(iy,iy+nny):
	    for ii in range(ix,ix+nnx):
		bigEnd=pfbfile.read(8)
		var[ii,jj,kk] = list(unpack('>d', bigEnd))[0] 

varT = np.transpose(var)
arrayCheckTB = varT[0:1,0:1,:]
arrayCheckTB = np.reshape(arrayCheckTB,(nx,1))
arrayCheckB = var[:,0:1,0:1]
arrayCheckB = np.reshape(arrayCheckB,(nx,1))

# Assert arrays are almost equal:
print "Checking the bottom row of the first timestep... \n"
np.testing.assert_array_almost_equal(arrayCheckT,arrayCheckTB, decimal=4)
np.testing.assert_array_almost_equal(arrayCheck, arrayCheckB, decimal=4)
print "ALL tests passed\n"


#sed -n -e '1,440p' ParFlow_Temp_month04_1-12thTS.sa > checkBottomRowfromSa
#then diff files
