import numpy as np
from netCDF4 import Dataset
import sys
import os
from struct import *

#usage: python MakeHomogCLMFields.py 'oldclmfile' case
#case=1,2,3,4 Constant LU ind, Constant sand %, Constant clay %, constant soil color 
oldclmfile=sys.argv[1]
case=sys.argv[2]
case=int(case)
nlon=1592
nlat=1544

lat_s=23.77013
lon_s=-9.369095

dlat=0.0275
dlon=0.0275

fixedline=[0.16, 0.26, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0]
constLU="0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00\n"
filename='drv_vegm_alluvhomogfieldsCLM_' + str(case) + '.dat'
f = open(filename, 'w')

header1="  x  y   lat     lon    sand clay color  fractional coverage of grid by vegetation class (Must/Should Add to 1.0)" 
header2="        (Deg)   (Deg)    (%/100)  index  1    2    3    4    5    6    7    8    9   10  11  12   13   14   15   16   17   18"

f.write(header1 + "\n")
f.write(header2 + "\n")
newtext=["","","",""]
fin=open(oldclmfile,'r')
ind=case-1
for line in fin:
    line = line.rstrip()
    array = line.split(' ') 
    #              x                y              lat     lon
    prefix = array[0] + " " + array[1] + " " + array[2] + " " + array[3] + " "
    #index  1    2    3    4    5    6    7    8    9   10  11  12   13   14   15   16   17   18
    suffix = array[7] + " " + array[8] + " " + array[9] + " " + array[10] +  " " + array[11] + " " + array[12] + " " + array[13] + " " + array[14] + " " + array[15] + " " + array[16]  + " " + array[17] + " " + array[18] + " " + array[19]  + " " + array[20] + " " + array[21] + " " + array[22]  + " " + array[23] + " " + array[24] + "\n"
    # sand clay soil color LU
    newtext[0] = prefix + array[4] + " " + array[5] + " " + array[6] + " " + constLU
    newtext[1] = prefix + " 0.16  " + array[5] + " " + array[6] + " " + suffix
    newtext[2] = prefix + array[4] + " 0.26 " + array[6] + " " + suffix
    newtext[3] = prefix + array[4] + " " + array[5] + " 2 " + suffix
    f.write(newtext[ind])   
 

fin.close()
f.close()
print "finished"

#sed -n -e '1,440p' ParFlow_Temp_month04_1-12thTS.sa > checkBottomRowfromSa
#then diff files
