import numpy as np
from netCDF4 import Dataset
import sys
import os
from struct import *

#usage: python MakeHomogCLMFile.py 'oldclmfile'
nlon=1592
nlat=1544

lat_s=23.77013
lon_s=-9.369095

dlat=0.0275
dlon=0.0275

fixedline='0.16 0.26 2 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0'
filename='drv_vegm_alluvhomogCLM.dat'
f = open(filename, 'w')

header1="  x  y   lat     lon    sand clay color  fractional coverage of grid by vegetation class (Must/Should Add to 1.0)" 
header2="        (Deg)   (Deg)    (%/100)  index  1    2    3    4    5    6    7    8    9   10  11  12   13   14   15   16   17   18"

f.write(header1 + "\n")
f.write(header2 + "\n")
line=""
for jj in range(0, nlat):
    for ii in range(0, nlon):
       x = ii + 1
       y = jj + 1
       lat = jj*dlat+lat_s
       lon = ii*dlon+lon_s
       line+=str(x) + " " + str(y) + " " + str(lat) + " " + str(lon) + " " + fixedline + "\n"
    f.write(line)   
    line=""

f.close()
print "finished"

#sed -n -e '1,440p' ParFlow_Temp_month04_1-12thTS.sa > checkBottomRowfromSa
#then diff files
