#/usr/bin/ksh

PARFLOW_DESIRED_DIR=$PARFLOW_DIR
PARFLOW_R_DIR=$PARFLOW_SRC/ParFlow.${PARFLOW_REV}

source $(pwd)/env_juqueen.ini

#WRAPPERFUNCTIONS#

if (( $PARFLOW_COMPILE_TRUE == 1 )) ; then

    if (( $PARFLOW_EXTRACT_SRC_TRUE == 1 )) ; then
        wdir=$(pwd)
        cd $PARFLOW_DIR_EXTRACT
        if [[ -d "${PARFLOW_DESIRED_DIR}" ]] ; then
           rm -rf $PARFLOW_DESIRED_DIR
        fi
        tar -xvzf $PARFLOW_SRC/ParFlow.${PARFLOW_REV}.tar.gz
	cd $wdir
    elif (( $PARFLOW_DOWNLOAD_SRC_TRUE == 1 )) ; then
        wdir=$(pwd)
        cd $PARFLOW_DIR_EXTRACT
        if [[ -d "${PARFLOW_DESIRED_DIR}" ]] ; then
           rm -rf $PARFLOW_DESIRED_DIR
        fi
	#If this particular revision has already been downloaded- remove it
        if [[ -e "Parflow.${PARFLOW_REV}.tar.gz" ]] ; then
             rm -f Parflow.${PARFLOW_REV}.tar.gz
        fi
        # Use the web version revision nomenclature, where the revision number is given by the user:
        wget "http://inside.mines.edu/~rmaxwell/ParFlow.${PARFLOW_REV}.tar.gz"
        tar -xvzf $PARFLOW_SRC/ParFlow.${PARFLOW_REV}.tar.gz
        cd $wdir
    fi
      
    #mv the directory to whatever the user named it
    mv $PARFLOW_R_DIR $PARFLOW_DESIRED_DIR
 
    export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$SILO_DIR/lib:$HYPRE_DIR/lib:$PARFLOW_DESIRED_DIR/lib:$TCL_DIR/lib
    export CC=#MPICC#
    export CXX=#MPIC++#
    export FC=#MPIF90#
    pathtowrapper=#PATHTOWRAPPER#

    #2 Issue with JUQUENN XLF Compilter FORTRAN underscore
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/amps_init.c         $PARFLOW_DESIRED_DIR/pfsimulator/amps/oas3/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/oas3_coupler.h      $PARFLOW_DESIRED_DIR/pfsimulator/amps/oas3/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/oas3_external.h     $PARFLOW_DESIRED_DIR/pfsimulator/amps/oas3/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/oas_pfl_vardef.F90  $PARFLOW_DESIRED_DIR/pfsimulator/amps/oas3/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/parflow_proto_f90.h $PARFLOW_DESIRED_DIR/pfsimulator/parflow_lib/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/parflow_proto_f.h   $PARFLOW_DESIRED_DIR/pfsimulator/parflow_lib/
    #3 Issue with JUQUEEN LITTLE ENDIAN
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/amps_proto.h        $PARFLOW_DESIRED_DIR/pfsimulator/amps/oas3/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/amps_proto.h        $PARFLOW_DESIRED_DIR/pfsimulator/amps/mpi1/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/amps_io.c           $PARFLOW_DESIRED_DIR/pfsimulator/amps/common/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/parflow_model.h.in $PARFLOW_DESIRED_DIR/pfsimulator/model/
    cp $PARFLOW_BASE/juqueen_files/parflow_patch/tools_io.h          $PARFLOW_DESIRED_DIR/pftools/

    
    #PATCHES#

    cd $PARFLOW_DESIRED_DIR/pfsimulator

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if (( $PARFLOW_COMPILE_CLM == 1 )) ; then
	if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
            ./modelure --prefix=$PARFLOW_DESIRED_DIR --with-clm --with-amps=mpi1 --with-amps-sequential-io --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --enable-timing --enable-opt="#OPT_FLAGS#"
    	else
            ./modelure --prefix=$PARFLOW_DESIRED_DIR --with-clm --with-amps=mpi1 --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --enable-opt="#OPT_FLAGS#"
    	fi
    else
    	if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
            ./modelure --prefix=$PARFLOW_DESIRED_DIR --with-amps=mpi1 --with-amps-sequential-io --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --enable-timing --enable-opt="#OPT_FLAGS#"
    	else
            ./modelure --prefix=$PARFLOW_DESIRED_DIR --with-amps=mpi1 --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --enable-timing --enable-opt="#OPT_FLAGS#"
    	fi
    fi
    # Fabian doesn't know why this is necessary, this used to work with a compiler flag
    sed -i "s,advect_,advect," $PARFLOW_DESIRED_DIR/pfsimulator/parflow_lib/parflow_proto_f.h 

    #PREMAKE#

    make
    make install

    #POSTMAKE#

    echo "ParFlow compilation done"

    CC=#CC#
    F77=#F77#
    FC=#FC#

    cd $PARFLOW_DESIRED_DIR/pftools

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
        ./modelure CC=$CC F77=$F77 FC=$FC  --prefix=$PARFLOW_DESIRED_DIR --enable-timing --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --with-amps=mpi1 --disable-debug --with-amps-sequential-io
    else
        ./modelure CC=$CC F77=$F77 FC=$FC --prefix=$PARFLOW_DESIRED_DIR --enable-timing --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --disable-debug --with-amps=mpi1
    fi

    make
    make install

    echo "ParFlow tools compilation done"
    cd $PARFLOW_SRC
    if (( $PARFLOW_DOWNLOAD_SRC_TRUE == 1 )) ; then
        rm -f $PARFLOW_DIR_EXTRACT/ParFlow.${PARFLOW_REV}.tar.gz
    fi
  
else

    echo "ParFlow was not recompiled for this run"

fi
