#/usr/bin/ksh

PARFLOW_SRC=/gpfs/homeb/pcp0/pcp0050/parFlow_EoCoE/src
PARFLOW_REV=693
PARFLOW_DIR=$PARFLOW_SRC/ParFlow.r${PARFLOW_REV}
PARFLOW_DESIRED_DIR=$PARFLOW_SRC/ParFlow.r${PARFLOW_REV}_julia_none
#PARFLOW_EXTRACT_SRC_TRUE=1
#PARFLOW_COMPILE_TRUE=1
#PARFLOW_COMPILE_CLM=0
#PARFLOW_UNDISTRIBUTED_FILE=1
#PARFLOW_CLEAN_COMPILE=1
#PARFLOW_DOWNLOAD_SRC_TRUE=0

if (( $PARFLOW_COMPILE_TRUE == 1 )) ; then

    if (( $PARFLOW_EXTRACT_SRC_TRUE == 1 )) ; then
        wdir=$(pwd)
        if [[ -d "${PARFLOW_DESIRED_DIR}" ]] ; then
           rm -rf $PARFLOW_DESIRED_DIR
        fi
        tar -xvzf ${PARFLOW_DIR}.tar.gz
	echo $PARFLOW_DIR
	ls $PARFLOW_DIR
	cd $wdir
    elif (( $PARFLOW_DOWNLOAD_SRC_TRUE == 1 )) ; then
        wdir=$(pwd)
        cd $PARFLOW_DIR_EXTRACT
        echo $PARFLOW_DIR
        if [[ -d "${PARFLOW_DESIRED_DIR}" ]] ; then
           rm -rf $PARFLOW_DESIRED_DIR
        fi
        #If this particular revision has already been downloaded- remove it
        if [[ -e "Parflow.r${PARFLOW_REV}.tar.gz" ]] ; then
             rm -f Parflow.r${PARFLOW_REV}.tar.gz
        fi
        # Use the web version revision nomenclature, where the revision number is given by the user:
        wget "http://inside.mines.edu/~rmaxwell/ParFlow.r${PARFLOW_REV}.tar.gz"
        tar -xvzf $PARFLOW_SRC/ParFlow.r${PARFLOW_REV}.tar.gz
        cd $wdir
    fi
 
    # patch for orig r693 from FGa
    if [[ $PARFLOW_REV =~ "693" ]]; then
        cp ${PARFLOW_SRC}/pf_pfmg_octree.c ${PARFLOW_DIR}/pfsimulator/parflow_lib/.
    fi

    mv $PARFLOW_DIR $PARFLOW_DESIRED_DIR
    export LD_LIBRARY_PATH=/gpfs/homeb/pcp0/pcp0050/sw/lib:$LD_LIBRARY_PATHPATH

    export PATH=/gpfs/homeb/pcp0/pcp0050/sw/bin:$PATH

     cd $PARFLOW_DESIRED_DIR/pfsimulator

     if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
         make clean
     fi

        


   ./modelure CC=mpiicc CFLAGS="-g -O3 -xMIC-AVX512" CXX=mpiicpc CXXFLAGS="-g -O3 -xMIC-AVX512" FC=mpiifort FCFLAGS="-g -O3 -xMIC-AVX512" F77=mpiifort FFLAGS="-g -O3 -xMIC-AVX512" --with-amps=mpi1 --with-hypre=/gpfs/homeb/pcp0/pcp0050/sw --with-silo=/gpfs/homeb/pcp0/pcp0050/sw --with-amps-sequential-io --enable-timing --enable-opt --prefix=${PARFLOW_DESIRED_DIR}
    

    #needed due to automodel, gfortran is irrelevant
    sed -i 's/"//g' $PARFLOW_DESIRED_DIR/pfsimulator/model/Makefile.model
    #sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DESIRED_DIR/pfsimulator/model/Makefile.model
    #sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DESIRED_DIR/pfsimulator/model/Makefile.model
    #sed "s/ m /  -lm  /g" -i $PARFLOW_DESIRED_DIR/pfsimulator/model/Makefile.model
    #sed "s/-l /  /g" -i $PARFLOW_DESIRED_DIR/pfsimulator/model/Makefile.model
    # due to the usage of gfortran intel opt flags need to be removed from that call
    #sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DESIRED_DIR/pfsimulator/model/Makefile.model
   

    make -j 16 && make install

    echo "ParFlow compilation done"

    #pftools are not available with some profiler wrappers so need to change this to plain mpicc etc


    cd $PARFLOW_DESIRED_DIR/pftools

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi
   ./modelure CC=mpiicc CFLAGS="-g -O3 -xMIC-AVX512" CXX=mpiicpc CXXFLAGS="-g -O3 -xMIC-AVX512" FC=mpiifort FCFLAGS="-g -O3 -xMIC-AVX512" F77=mpiifort FFLAGS="-g -O3 -xMIC-AVX512" --with-amps=mpi1 --with-hypre=/gpfs/homeb/pcp0/pcp0050/sw --with-silo=/gpfs/homeb/pcp0/pcp0050/sw --with-amps-sequential-io --enable-timing --enable-opt --prefix=${PARFLOW_DESIRED_DIR}

   # ./modelure CC=mpiicc CFLAGS="-O3 -xMIC-AVX512" CXX=mpiicpc CXXFLAGS="-O3 -xMIC-AVX512" FC=mpiifort FCFLAGS="-O3 -xMIC-AVX512" F77=mpiifort FFLAGS="-O3 -xMIC-AVX512" --with-amps=mpi1 --with-hypre=/gpfs/homeb/pcp0/pcp005/sw --with-silo=/gpfs/homeb/pcp0/pcp0050/sw --with-amps-sequential-io --enable-timing --enable-opt

    #needed due to automodel, gfortran is irrelevant
    sed -i 's/"//g' $PARFLOW_DESIRED_DIR/pftools/model/Makefile.model    

    make -j 16 && make install

    echo "ParFlow tools compilation done"
    cd $PARFLOW_SRC
    if (( $PARFLOW_DOWNLOAD_SRC_TRUE == 1 )) ; then
        rm -f $PARFLOW_DIR_EXTRACT/ParFlow.r${PARFLOW_REV}.tar.gz
    fi
 
    #mv the directory to whatever the user named it- prefix does not seem to work!
    #mv $PARFLOW_DIR $PARFLOW_DESIRED_DIR
else

    echo "ParFlow was not recompiled for this run"
fi
