import numpy as np
import sys
import os
import shutil


"""
.. module:: jubeJobRunner
    :platform: Unix
    :synopsis: execute a custom xml to run on either Jureca or Juqueen

.. moduleauthor:: Wendy Sharples <w.sharples@fz-juelich.de>

"""

__author__ = 'wendy'


# Simple script to run a driver xml file with your particulars in JUBE.
# Assumptions:
# 1. Assumes you are in the ${jube_benchmark_home} dir where this script resides 
# 1. Assumes the driver file you nominate is in ${jube_benchmark_home}/driver and assumes that the driver file contains the parameters: benchmarkName, outputDir, runID and customJob. Check this before running. Eg. ParflowJUBE2_BMBase.xml
# 2. Assumes custom file you nominate is in ${jube_benchmark_home}/custom
# 3. Assumes template files are in ${jube_benchmark_home}/templates
# The outputDir is set by: ${jube_benchmark_home}/outputDir
# The output path to your unique jube benchmark ID is set automatically by the JUBE environment and is given by ${jube_benchmark_home}/${outputDir}/${runID}/${jube_id}
# The xml run file is a copy of the driver xml file with sed replacements and is saved under: jobName_runID_customJob.xml. After the jube run cmd is executed it is moved to this location: outputDir/runID.
# Usage: Use this script like this: python jubeRun_script.py <runID> <benchmarkName> <driverFileName> <outputDir> <customJob> where jobName is the name given to your job run model. eg: python jubeRun_script.py 'idealised_100x100x50_48taskspernode_jureca' 'ParFlowScalingBM' 'ParFlowJUBE2_BMBase.xml' 'ParFlow_BMRuns' 'weakScalingIdealised_Job_Jureca.xml'

class JobRunner:
    
    def __init__(self, runID, jobName, driverFileName, outputDir, customJob):
	self.runID = runID
	self.jobName = jobName
	self.driverFileName = driverFileName
	self.outputDir = outputDir
	self.customJob = customJob
	
    def runJob(self, runID, jobName, driverFileName, outputDir, customJob):
	newFileName = jobName + '_' + runID + '_' + customJob
	shutil.copy('driver/' + driverFileName, newFileName)
	# now use sed to replace benchmarkName with $benchmarkName
	bashCmd1 = 'sed -i \"s/benchmarkName/' + jobName + '/g\" ' + newFileName
	# now use sed to replace outputDir with $outputDir
	bashCmd2 = 'sed -i \"s/outputDir/' + outputDir + '/g\" '  + newFileName
	# now use sed to replace runID with $runID
	bashCmd3 = 'sed -i \"s/runID/' + runID + '/g\" ' + newFileName
	# now use sed to replace customJob with $customJob
	bashCmd4 = 'sed -i \"s/customJob.xml/' + customJob + '/g\" ' + newFileName 
	
	os.system(bashCmd1)
	os.system(bashCmd2)
	os.system(bashCmd3)
	os.system(bashCmd4)

	#jube run cmd, automatically in verbose mode to diagnose problems more easily:
	runCmd = 'jube -v run ' + newFileName
	os.system(runCmd)
	
	#mv the file to the job output directory:
	os.rename(newFileName, outputDir + '/' + runID + '/' + newFileName)

if __name__ == '__main__':

	data = JobRunner(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5])
	data.runJob(data.runID, data.jobName, data.driverFileName, data.outputDir, data.customJob)
