import numpy as np
import sys
import os



"""
.. module:: jubeResultRunner
    :platform: Unix
    :synopsis: execute the main jube cmds to analyse a job run

.. moduleauthor:: Wendy Sharples <w.sharples@fz-juelich.de>

"""

__author__ = 'wendy'


#Script to run the jube cmds subsequently for a quick look at the info and results for the benchmark run which is piped to stdout.
#Use this script like this: python jubeResult_script.py <outputpath> <ID> where ID is the number given to your benchmark run

class ResultRunner:
    
    def __init__(self, outputPath, ID):
	self.outputPath = outputPath
	self.ID = ID
	
    def executeCmds(self, outputPath, ID):
	bashCmd1 = 'jube analyse ' + outputPath + ' --id ' + ID
	bashCmd2 = 'jube result ' + outputPath + ' --id ' + ID
	bashCmd3 = 'jube info ' + outputPath + ' --id ' + ID
	bashCmd4 = 'jube log ' + outputPath + ' --id ' + ID
 
	os.system(bashCmd1)
	os.system(bashCmd2)
	os.system(bashCmd3)
	os.system(bashCmd4)

if __name__ == '__main__':

	data = ResultRunner(sys.argv[1], sys.argv[2])
	data.executeCmds(data.outputPath, data.ID)
