def replaceICPFBPatch(spinupPatch,spinupDir,tclFile,oldTclFile):
    #tclFile: from patch, lines separated by ,
    #1. pfset ICPressure.Type
    #2. pfset ICPressure.GeomNames
    #3. pfset Geom.domain.ICPressure.Value
    #4. pfset Geom.domain.ICPressure.RefGeom
    #5. pfset Geom.domain.ICPressure.RefPatch
    array = spinupPatch.split(',')  
    newtclFile = open(spinupDir + '/' + str(tclFile),"w")
    with open(oldTclFile) as f:
        for line in f:
            if 'pfset ICPressure.Type' in line:
                #replace the oldLine with the newLine:
                line = str(array[0]) + '\n'
		newtclFile.write(line)
            elif 'pfset ICPressure.GeomNames' in line:
                #replace the oldLine with the newLine:
                line = str(array[1]) + '\n'
                newtclFile.write(line)
            elif 'pfset Geom.domain.ICPressure.FileName' in line:
                #replace the oldLine with the newLine:
                line = str(array[2]) + '\n'
                newtclFile.write(line)
            elif 'pfset Geom.domain.ICPressure.RefGeom' in line:
                #replace the oldLine with the newLine:
                line = str(array[3]) + '\n'
                newtclFile.write(line)
            elif 'pfset Geom.domain.ICPressure.RefPatch' in line:
                #replace the oldLine with the newLine:
                line = str(array[4]) + '\n'
                newtclFile.write(line)
            else:
                newtclFile.write(line)

def replaceModelScriptsWeekly(prefix,forcingyear,firstforcingweek,restartWeeks,counter,forcingweek,tclsh_cmd,distfile,tclfile,runname,press_icfile,clm_icfile,NP,NQ,pfltsperday,startinghour,modelsubmitscript,path):

    #Assumed press ic file is in pfb format
    #Assume we are restarting/starting from a timestep before and then forcing starts on the next timestep
    forcingfileprefix=prefix + "_" + str(forcingweek)
    forcingfilespath=path + '/output_' + str(forcingweek) + '/' + prefix + '_' + str(forcingweek)
    totalprocs=int(NP)*int(NQ)
    #NetCDF vars:
    startdatelist = [0,0]
    enddatelist = [0,0]
    startdateyear = forcingyear
    startdateweek = forcingweek
    startdatelist = getstartdaydate_return(forcingyear,forcingweek)
    enddatelist = getenddaydate_return(forcingyear, forcingweek, startdatelist)

    #FORCING: starts at the same time the simulation starts
    #Starting hour is the time the forcing starts
    #Counters: 1 to end of the week for CLM and ParFlow
    prevforcingweek=int(restartWeeks.split()[int(counter)])
    prevforcingyear = forcingyear
    endingyear = forcingyear
    if (prevforcingweek == 52):
	prevforcingyear = forcingyear - 1
    if (forcingweek == 52):
	endingyear = forcingyear + 1
    startingweek = '%02d' % forcingweek
    endingweek = '%02d' % forcingweek
    startdateday = startdatelist[0]
    startingday = '%02d' % startdatelist[0]
    startingmonth = '%02d' % startdatelist[1]
    prevd = eowday_return(prevforcingyear, prevforcingweek)
    d = eowday_return(forcingyear, forcingweek)
    restartTS=int(prevd)*int(pfltsperday)
    endTS=int(d)*int(pfltsperday)
    endingday = '%02d' % enddatelist[0]
    endingmonth = '%02d' % enddatelist[1]
    restart=1
    #preamble
    if(int(prevforcingweek) < 0):
	#spinup is -1: file can have any naming convention but should be pfb
	preamble = 'cp ' + str(press_icfile) + ' pfl_ic.pfb; ' + tclsh_cmd
	restart=2
    elif(int(prevforcingweek) == 0):
        #when the restart files are not in the same directory as the run directory
        preamble = 'cp ' + str(press_icfile) + '/*.pfb pfl_ic.pfb; cp ' + str(clm_icfile)  + '/clm.rst.* .; for (( i=0;i<'+ str(totalprocs) +';i++ )); do mv clm.rst.00*' + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd        
    elif(int(prevforcingweek) >= int(firstforcingweek)):
        preamble = 'cp ../output_' + str(prevforcingweek) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ../output_' + str(prevforcingweek) + '/clm.rst.00' + str(restartTS) + '* .; for (( i=0;i<' + str(totalprocs) + ';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd
    #Assumed format of restart files- runname.5%d.pfb and clm.rst.5%d.proc
    elif(int(prevforcingweek) < int(firstforcingweek)):
	 preamble = 'cp ' + str(press_icfile) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ' + str(clm_icfile) + '/clm.rst.00' + str(restartTS) + '* .; for (( i=0;i<'+ str(totalprocs) +';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd	
       
    #postamble: check the whole week was run:
    postamble = 'if ! [ -s ' + str(runname) + '.out.press.00' + str(endTS) + '.pfb ]; then echo \"Month:' + str(forcingweek) + ' year:' + str(forcingyear) + ' is incomplete\"; exit 100; fi'

    #replace:
    #dist tcl file: forcingstepend,forcingNT
    newdistfile = open('output_' + str(forcingweek) + '/' + str(distfile),"w")
    with open(distfile) as f:
        for line in f:
	    if '$forcingfileprefix' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfileprefix', str(forcingfileprefix))
                newdistfile.write(line)
	    elif '$forcingfilespath' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfilespath', str(forcingfilespath))
                newdistfile.write(line)
            elif '$forcingnt' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingnt', str(endTS))
	    	if '$forcingstepend' in line:
		    stuff = line
	            line = stuff.replace('$forcingstepend', str(endTS))
                newdistfile.write(line)
            else:
                newdistfile.write(line)
    
    #tcl file: forcingstepstart, forcingstepend,forcingNT
    newtclfile = open('output_' + str(forcingweek) + '/' + str(tclfile),"w")
    with open(tclfile) as f:
        for line in f:
            if '$TIMESTOPTIME' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$TIMESTOPTIME', str(endTS)+'.0')
                newtclfile.write(line)
	    elif '$forcingfilespath' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfilespath', str(forcingfilespath))
                newtclfile.write(line)
	    elif '$forcingfileprefix' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfileprefix', str(forcingfileprefix))
                newtclfile.write(line)
	    elif '$forcingnt' in line:
		stuff = line
	        line = stuff.replace('$forcingnt', str(endTS))
                newtclfile.write(line)
	    elif '$startdateyear' in line:
		stuff = line
	        line = stuff.replace('$startdateyear', str(startdateyear))
                newtclfile.write(line)
	    elif '$startdatemonth' in line:
		stuff = line
	        line = stuff.replace('$startdatemonth', str(startdatemonth))
                newtclfile.write(line)
	    elif '$startdateday' in line:
		stuff = line
	        line = stuff.replace('$startdateday', str(startdateday))
                newtclfile.write(line)
            else:
                newtclfile.write(line)

    #clmdrv file: forcingNT,restartTS,restartMonth,startingDay,startingMonth,startingYear,endingDay,endingMonth,endingYear
    newclmdrvfile = open('output_'+ str(forcingweek) + '/drv_clmin.dat',"w")
    with open('drv_clmin.dat') as f:
        for line in f:
            if '$restart' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$restart', str(restart))
                newclmdrvfile.write(line)
	    elif '$startingday' in line:
                 stuff = line
                 line = stuff.replace('$startingday', str(startingday))
                 newclmdrvfile.write(line) 
            elif '$startingmonth' in line:
		stuff = line
	        line = stuff.replace('$startingmonth', str(startingmonth))
                newclmdrvfile.write(line)
	    elif '$endingday' in line:
		stuff = line
	        line = stuff.replace('$endingday', str(endingday))
                newclmdrvfile.write(line)
	    elif '$endingmonth' in line:
		stuff = line
	        line = stuff.replace('$endingmonth', str(endingmonth))
                newclmdrvfile.write(line)
	    elif '$endingyear' in line:
		stuff = line
	        line = stuff.replace('$endingyear', str(endingyear))
                newclmdrvfile.write(line)
            else:
                newclmdrvfile.write(line)

    #model submit script:
    modelsubmitscript=modelsubmitscript.replace('.job','')
    newsubmitscript = open('output_' + str(forcingweek) + '/' + modelsubmitscript + '_' + str(forcingweek) + '.job',"w")
    with open(modelsubmitscript + '.job') as f:
        for line in f:
	    if '$forcingweek' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingweek', str(forcingweek))
                newsubmitscript.write(line)
	    elif 'job.out' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('job.out', 'job.out')
                newsubmitscript.write(line)
	    elif 'job.err' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('job.err', 'job.err')
                newsubmitscript.write(line)
            elif 'preamble' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('preamble', str(preamble))
                newsubmitscript.write(line)
	    elif 'postamble' in line:
		stuff = line
	        line = stuff.replace('postamble', str(postamble))
                newsubmitscript.write(line)
            else:
                newsubmitscript.write(line)

def replaceModelScriptsWeeklyIncludingPostPro(prefix,forcingyear,firstforcingweek,restartWeeks,counter,forcingweek,tclsh_cmd,distfile,tclfile,runname,press_icfile,clm_icfile,NP,NQ,pfltsperday,startinghour,modelsubmitscript,path,postprojobs):

    #Assumed press ic file is in pfb format
    #Assume we are restarting/starting from a timestep before and then forcing starts on the next timestep
    forcingfileprefix=prefix + "_" + str(forcingweek)
    forcingfilespath=path + '/output_' + str(forcingweek) + '/' + prefix + '_' + str(forcingweek)
    totalprocs=int(NP)*int(NQ)
    #NetCDF vars:
    startdatelist = [0,0]
    enddatelist = [0,0]
    startdateyear = forcingyear
    startdateweek = forcingweek
    startdatelist = getstartdaydate_return(forcingyear,forcingweek)
    enddatelist = getenddaydate_return(forcingyear, forcingweek, startdatelist)

    #FORCING: starts at the same time the simulation starts
    #Starting hour is the time the forcing starts
    #Counters: 1 to end of the week for CLM and ParFlow
    prevforcingweek=int(restartWeeks.split()[int(counter)])
    prevforcingyear = forcingyear
    endingyear = forcingyear
    if (prevforcingweek == 52):
	prevforcingyear = forcingyear - 1
    if (forcingweek == 52):
	endingyear = forcingyear + 1
    startingweek = '%02d' % forcingweek
    endingweek = '%02d' % forcingweek
    startdateday = startdatelist[0]
    startingday = '%02d' % startdatelist[0]
    startingmonth = '%02d' % startdatelist[1]
    prevd = eowday_return(prevforcingyear, prevforcingweek)
    d = eowday_return(forcingyear, forcingweek)
    restartTS=int(prevd)*int(pfltsperday)
    endTS=int(d)*int(pfltsperday)
    endingday = '%02d' % enddatelist[0]
    endingmonth = '%02d' % enddatelist[1]
    restart=1
    #preamble
    if(int(prevforcingweek) < 0):
	#spinup is -1: file can have any naming convention but should be pfb
	preamble = 'cp ' + str(press_icfile) + ' pfl_ic.pfb; ' + tclsh_cmd
	restart=2
    elif(int(prevforcingweek) == 0):
        #when the restart files are not in the same directory as the run directory
        preamble = 'cp ' + str(press_icfile) + '/*.pfb pfl_ic.pfb; cp ' + str(clm_icfile)  + '/clm.rst.* .; for (( i=0;i<'+ str(totalprocs) +';i++ )); do mv clm.rst.00*' + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd        
    elif(int(prevforcingweek) >= int(firstforcingweek)):
        preamble = 'if [ -f ../output_' + str(prevforcingweek) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb ]; then cp ../output_' + str(prevforcingweek) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ../output_' + str(prevforcingweek) + '/clm.rst.00' + str(restartTS) + '* . ; else cp ../output_' + str(prevforcingweek) + '_archive/restart/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ../output_' + str(prevforcingweek) + '_archive/restart/clm.rst.00' + str(restartTS) + '* .; fi; for (( i=0;i<' + str(totalprocs) + ';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd
    #Assumed format of restart files- runname.5%d.pfb and clm.rst.5%d.proc
    elif(int(prevforcingweek) < int(firstforcingweek)):
	 preamble = 'if [ -f ../output_' + str(prevforcingweek) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb ]; then cp ../output_' + str(prevforcingweek) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ../output_' + str(prevforcingweek) + '/clm.rst.00' + str(restartTS) + '* . ; else cp ../output_' + str(prevforcingweek) + '_archive/restart/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ../output_' + str(prevforcingweek) + '_archive/restart/clm.rst.00' + str(restartTS) + '* .; fi; for (( i=0;i<'+ str(totalprocs) +';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd	
    
    
    #postamble: check the whole week was run and if yes, then submit postpro scripts:
    scripts=postprojobs.split()
    postprosubcmd=""
    if (len(scripts)):
        postprosubmcmd='echo \"sbatch ' + str(scripts[0]) + '\"; JOBID=$(sbatch ' + str(scripts[0]) + ' 2>&1 | awk \'{print $(NF)}\'); sbatch --dependency=afterok:${JOBID} ' + str(scripts[1])
    else:
        postprosubmcmd='echo \"sbatch ' + str(scripts[0]) + '\"'
    postamble = 'if ! [ -s ' + str(runname) + '.out.press.00' + str(endTS) + '.pfb ]; then echo \"Month:' + str(forcingweek) + ' year:' + str(forcingyear) + ' is incomplete\"; exit 100; else ' + str(postprosubmcmd) + '; fi'

    #replace:
    #dist tcl file: forcingstepend,forcingNT
    newdistfile = open('output_' + str(forcingweek) + '/' + str(distfile),"w")
    with open(distfile) as f:
        for line in f:
	    if '$forcingfileprefix' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfileprefix', str(forcingfileprefix))
                newdistfile.write(line)
	    elif '$forcingfilespath' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfilespath', str(forcingfilespath))
                newdistfile.write(line)
            elif '$forcingnt' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingnt', str(endTS))
	    	if '$forcingstepend' in line:
		    stuff = line
	            line = stuff.replace('$forcingstepend', str(endTS))
                newdistfile.write(line)
            else:
                newdistfile.write(line)
    
    #tcl file: forcingstepstart, forcingstepend,forcingNT
    newtclfile = open('output_' + str(forcingweek) + '/' + str(tclfile),"w")
    with open(tclfile) as f:
        for line in f:
            if '$TIMESTOPTIME' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$TIMESTOPTIME', str(endTS)+'.0')
                newtclfile.write(line)
	    elif '$forcingfilespath' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfilespath', str(forcingfilespath))
                newtclfile.write(line)
	    elif '$forcingfileprefix' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfileprefix', str(forcingfileprefix))
                newtclfile.write(line)
	    elif '$forcingnt' in line:
		stuff = line
	        line = stuff.replace('$forcingnt', str(endTS))
                newtclfile.write(line)
	    elif '$startdateyear' in line:
		stuff = line
	        line = stuff.replace('$startdateyear', str(startdateyear))
                newtclfile.write(line)
	    elif '$startdatemonth' in line:
		stuff = line
	        line = stuff.replace('$startdatemonth', str(startdatemonth))
                newtclfile.write(line)
	    elif '$startdateday' in line:
		stuff = line
	        line = stuff.replace('$startdateday', str(startdateday))
                newtclfile.write(line)
            else:
                newtclfile.write(line)

    #clmdrv file: forcingNT,restartTS,restartMonth,startingDay,startingMonth,startingYear,endingDay,endingMonth,endingYear
    newclmdrvfile = open('output_'+ str(forcingweek) + '/drv_clmin.dat',"w")
    with open('drv_clmin.dat') as f:
        for line in f:
            if '$restart' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$restart', str(restart))
                newclmdrvfile.write(line)
	    elif '$startingday' in line:
                 stuff = line
                 line = stuff.replace('$startingday', str(startingday))
                 newclmdrvfile.write(line) 
            elif '$startingmonth' in line:
		stuff = line
	        line = stuff.replace('$startingmonth', str(startingmonth))
                newclmdrvfile.write(line)
	    elif '$endingday' in line:
		stuff = line
	        line = stuff.replace('$endingday', str(endingday))
                newclmdrvfile.write(line)
	    elif '$endingmonth' in line:
		stuff = line
	        line = stuff.replace('$endingmonth', str(endingmonth))
                newclmdrvfile.write(line)
	    elif '$endingyear' in line:
		stuff = line
	        line = stuff.replace('$endingyear', str(endingyear))
                newclmdrvfile.write(line)
            else:
                newclmdrvfile.write(line)

    #model submit script:
    modelsubmitscript=modelsubmitscript.replace('.job','')
    newsubmitscript = open('output_' + str(forcingweek) + '/' + modelsubmitscript + '_' + str(forcingweek) + '.job',"w")
    with open(modelsubmitscript + '.job') as f:
        for line in f:
	    if '$forcingweek' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingweek', str(forcingweek))
                newsubmitscript.write(line)
	    elif 'job.out' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('job.out', 'job.out')
                newsubmitscript.write(line)
	    elif 'job.err' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('job.err', 'job.err')
                newsubmitscript.write(line)
            elif 'preamble' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('preamble', str(preamble))
                newsubmitscript.write(line)
	    elif 'postamble' in line:
		stuff = line
	        line = stuff.replace('postamble', str(postamble))
                newsubmitscript.write(line)
            else:
                newsubmitscript.write(line)


def replaceModelScripts(prefix,forcingyear,firstforcingmonth,restartMonths,counter,forcingmonth,tclsh_cmd,distfile,tclfile,runname,press_icfile,clm_icfile,NP,NQ,pfltsperday,startinghour,modelsubmitscript,path):

    #TODO: adapt this to cycles instead of months
    #Assumed press ic file is in pfb format
    #Assume we are restarting/starting from a timestep before and then forcing starts on the next timestep
    forcingfileprefix=prefix + "_" + str(forcingmonth)
    forcingfilespath=path + '/output_' + str(forcingmonth) + '/' + prefix + '_' + str(forcingmonth)
    totalprocs=int(NP)*int(NQ)
    #NetCDF vars:
    startdateyear = forcingyear
    startdatemonth = forcingmonth
    startdateday = 1
    startingday = '%02d' % startdateday

    #FORCING: starts at the same time the simulation starts
    #Starting hour is the time the forcing starts
    #Counters: 1 to end of the month for CLM and ParFlow
    prevforcingmonth=int(restartMonths.split()[int(counter)])
    prevforcingyear = forcingyear
    endingyear = forcingyear
    if (prevforcingmonth == 12):
	prevforcingyear = forcingyear - 1
    if (forcingmonth == 12):
	endingyear = forcingyear + 1
    startingmonth = '%02d' % forcingmonth
    endingmonth = '%02d' % forcingmonth
    prevd = eomday_return(prevforcingyear, prevforcingmonth)
    d = eomday_return(forcingyear, forcingmonth)
    restartTS=int(prevd)*int(pfltsperday)
    endTS=int(d)*int(pfltsperday)
    endingday = '%02d' % d
    if (int(startinghour) > 0):
	endingday = '01'
	endingmonth = '%02d' % (int(forcingmonth)+1)
    restart=1
    #preamble
    if(int(prevforcingmonth) < 0):
	#spinup file can have any naming convention but should be pfb
	preamble = 'cp ' + str(press_icfile) + ' pfl_ic.pfb; ' + tclsh_cmd
	restart=2
    #Assumed format of restart files- runname.5%d.pfb and clm.rst.5%d.proc
    elif(int(prevforcingmonth) == 0):
        #when the restart files are not in the same directory as the run directory
        preamble = 'cp ' + str(press_icfile) + '/*.pfb pfl_ic.pfb; cp '  + str(clm_icfile) + '/clm.rst.* .; for (( i=0;i<'+ str(totalprocs) +';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd
    elif(int(prevforcingmonth) < int(firstforcingmonth)):
	preamble = 'cp ' + str(press_icfile) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ' + str(clm_icfile) + '/clm.rst.00' + str(restartTS) + '* .; for (( i=0;i<'+ str(totalprocs) +';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd	
    elif(int(prevforcingmonth) >= int(firstforcingmonth)):
        preamble = 'cp ../output_' + str(prevforcingmonth) + '/' + str(runname) + '.out.press.00' + str(restartTS) + '.pfb pfl_ic.pfb; cp ../output_' + str(prevforcingmonth) + '/clm.rst.00' + str(restartTS) + '* .; for (( i=0;i<' + str(totalprocs) + ';i++ )); do mv clm.rst.00' + str(restartTS) + '.${i} clm.rst.00000.${i}; done; ' + tclsh_cmd
    
    #postamble: check the whole month was run:
    postamble = 'if ! [ -s ' + str(runname) + '.out.press.00' + str(endTS) + '.pfb ]; then echo \"Month:' + str(forcingmonth) + ' year:' + str(forcingyear) + ' is incomplete\"; exit 100; fi'

    #replace:
    #dist tcl file: forcingstepend,forcingNT
    newdistfile = open('output_' + str(forcingmonth) + '/' + str(distfile),"w")
    with open(distfile) as f:
        for line in f:
	    if '$forcingfileprefix' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfileprefix', str(forcingfileprefix))
                newdistfile.write(line)
	    elif '$forcingfilespath' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfilespath', str(forcingfilespath))
                newdistfile.write(line)
            elif '$forcingnt' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingnt', str(endTS))
	    	if '$forcingstepend' in line:
		    stuff = line
	            line = stuff.replace('$forcingstepend', str(endTS))
                newdistfile.write(line)
            else:
                newdistfile.write(line)
    
    #tcl file: forcingstepstart, forcingstepend,forcingNT
    newtclfile = open('output_' + str(forcingmonth) + '/' + str(tclfile),"w")
    with open(tclfile) as f:
        for line in f:
            if '$TIMESTOPTIME' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$TIMESTOPTIME', str(endTS)+'.0')
                newtclfile.write(line)
	    elif '$forcingfilespath' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfilespath', str(forcingfilespath))
                newtclfile.write(line)
	    elif '$forcingfileprefix' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingfileprefix', str(forcingfileprefix))
                newtclfile.write(line)
	    elif '$forcingnt' in line:
		stuff = line
	        line = stuff.replace('$forcingnt', str(endTS))
                newtclfile.write(line)
	    elif '$startdateyear' in line:
		stuff = line
	        line = stuff.replace('$startdateyear', str(startdateyear))
                newtclfile.write(line)
	    elif '$startdatemonth' in line:
		stuff = line
	        line = stuff.replace('$startdatemonth', str(startdateday))
                newtclfile.write(line)
	    elif '$startdateday' in line:
		stuff = line
	        line = stuff.replace('$startdateday', str(startdatemonth))
                newtclfile.write(line)
            else:
                newtclfile.write(line)

    #clmdrv file: forcingNT,restartTS,restartMonth,startingDay,startingMonth,startingYear,endingDay,endingMonth,endingYear
    newclmdrvfile = open('output_'+ str(forcingmonth) + '/drv_clmin.dat',"w")
    with open('drv_clmin.dat') as f:
        for line in f:
            if '$restart' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$restart', str(restart))
                newclmdrvfile.write(line)
            elif '$startingday' in line:
                 stuff = line 
                 line = stuff.replace('$startingday', str(startingday))
                 newclmdrvfile.write(line)
	    elif '$startingmonth' in line:
		stuff = line
	        line = stuff.replace('$startingmonth', str(startingmonth))
                newclmdrvfile.write(line)
	    elif '$endingday' in line:
		stuff = line
	        line = stuff.replace('$endingday', str(endingday))
                newclmdrvfile.write(line)
	    elif '$endingmonth' in line:
		stuff = line
	        line = stuff.replace('$endingmonth', str(endingmonth))
                newclmdrvfile.write(line)
	    elif '$endingyear' in line:
		stuff = line
	        line = stuff.replace('$endingyear', str(endingyear))
                newclmdrvfile.write(line)
            else:
                newclmdrvfile.write(line)

    #model submit script:
    modelsubmitscript=modelsubmitscript.replace('.job','')
    newsubmitscript = open('output_' + str(forcingmonth) + '/' + modelsubmitscript + '_' + str(forcingmonth) + '.job',"w")
    with open(modelsubmitscript + '.job') as f:
        for line in f:
	    if '$forcingmonth' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingmonth', str(forcingmonth))
                newsubmitscript.write(line)
	    elif 'job.out' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('job.out', 'job.out')
                newsubmitscript.write(line)
	    elif 'job.err' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('job.err', 'job.err')
                newsubmitscript.write(line)
            elif 'preamble' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('preamble', str(preamble))
                newsubmitscript.write(line)
	    elif 'postamble' in line:
		stuff = line
	        line = stuff.replace('postamble', str(postamble))
                newsubmitscript.write(line)
            else:
                newsubmitscript.write(line)


def replacePostProScripts(forcingyear,forcingmonth,restartMonths,counter,press_icfile,runname,restartStep,timeDump,startinghour,pfltsperday,prefix,chunks,parflowdir,nclscript,diagscript,tarScript,parflowoutputdir,numncfiles,diagsubmitscript,nclsubmitscript):
    #this is for the extracting data step- see preprocessing scripts
    date = ""
    d = eomday_return(forcingyear, forcingmonth)
    endTS=int(d)*int(pfltsperday)
    chunks=int(chunks)
    prevforcingmonth=int(restartMonths.split()[int(counter)])
    yearStart = forcingyear
    yearEnd = forcingyear
    if (prevforcingmonth == 12):
	prevforcingyear = forcingyear - 1
    if (prevforcingmonth == 0):
	prevforcingmonth = forcingmonth - 1
	date = press_icfile
    timeStart = '01:00'
    timeEnd = '00:00'
    dayStart = '01'
    dayEnd = '01'
    monthStart = '%02d' % forcingmonth
    monthEnd = '%02d' % (forcingmonth+1)
    if(monthStart == '12' and str(startinghour) == "01"):
	monthEnd = '01'
	yearEnd = forcingyear + 1
	pressureTimeStart = "00:00"
	#Put in date of pressure initial condition: YYYY-MM-DD-HH:HH, it is the hour before the start time
    	date=str(yearStart) + "-" + str(monthStart) + "-" + str(dayStart) + "-" + pressureTimeStart
    elif (str(startinghour) == "00"):	    
	timeStart = '00:00'
	timeEnd = '23:00'
	monthStart = '%02d' % forcingmonth
	monthEnd = '%02d' % forcingmonth
	dayEnd = '%02d' % d
	emonth = '%02d' % forcingmonth
	pressureYearStart = forcingyear
	if (forcingmonth == 1):
	    pressureYearStart = forcingyear - 1
	pressureTimeStart = "23:00"
	pressureDay =  eomday_return(pressureYearStart, prevforcingmonth)
	pressureDayStart = '%02d' % pressureDay
	pressureMonthStart = '%02d' % prevforcingmonth

    	#Put in date of pressure initial condition: YYYY-MM-DD-HH:HH, it is the hour before the forcing start time
    	date=str(pressureYearStart) + "-" + str(pressureMonthStart) + "-" + str(dayStart) + "-" + pressureTimeStart
    simulationtimespan = str(yearStart) + "-" + str(monthStart) + "-" + str(dayStart) + "-" + str(timeStart) + "-" + str(yearEnd) + "-" + str(monthEnd) + "-" + str(dayEnd) + "-" + str(timeEnd)
    timeStart = '01:00'
    if (str(startinghour) == "00"):
        timeStart = '00:00'
	monthStart = '%02d' % forcingmonth
	yearStart = forcingyear
    forcingtimespan = str(yearStart) + "-" + str(monthStart) + "-" + str(dayStart) + "-" + str(timeStart) + "-" + str(yearEnd) + "-" + str(monthEnd) + "-" + str(dayEnd) + "-" + str(timeEnd)
    if (prevforcingmonth < 0):
	date=press_icfile;   
    forcingDir=str(prefix) + "_" + str(forcingmonth)
    numRestarts = endTS/(int(restartStep)/int(timeDump))
    postprocess = 'count=$(ls -1 *.nc 2>/dev/null | wc -l); if [ $? -ne 0 ] ; then echo \"postprocessing for month:' + str(forcingmonth) + ' and year:' + str(forcingyear) + ' failed\"; exit 1234 ; elif (( $count==0 )); then echo \"no netcdf files found! postprocessing for month:' + str(forcingmonth) + ' and year:' + str(forcingyear) + ' failed\"; exit 1234 ; else ./' + str(tarScript) + ' ' + str(parflowoutputdir) +  ' ' + str(runname) + ' ' + str(forcingDir) + ' ' + str(restartStep) + ' ' + str(timeDump) + ' ' + str(numRestarts) + ' ' + str(parflowdir) +  ' ' + str(numncfiles) + '; fi'
    #for ncl submit script if divided into chunks
    interval=int(endTS / chunks) + (endTS % chunks > 0)
    timestampstartdate=str(yearStart) + "-" + str(monthStart) + "-" + str(dayStart)

    newnclscript = open('output_' + str(forcingmonth) + '/' + nclscript,"w")
    with open(nclscript) as f:
        for line in f:
	     if '$simulationtimespan' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$simulationtimespan', str(simulationtimespan))
                newnclscript.write(line)
 	     elif '$forcingtimespan' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingtimespan', str(forcingtimespan))
                newnclscript.write(line)
             elif '$date' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$date', str(date))
                newnclscript.write(line)
	     elif '$parflowoutputdir' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$parflowoutputdir', str(parflowoutputdir))
                newnclscript.write(line)
	     elif '$runname' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$runname', str(runname))
                newnclscript.write(line)
	     elif '$startTS' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$startTS', str(0))
		newnclscript.write(line)
	     elif '$endTS' in line:
		#replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$endTS', str(endTS))
                newnclscript.write(lin)
             else:
                newnclscript.write(line)

    diagsubmitscript=diagsubmitscript.replace('.job','')
    nclsubmitscript=nclsubmitscript.replace('.job','')
    newdiagsubmitscript = open('output_' + str(forcingmonth) + '/' + diagsubmitscript + '_' + str(forcingmonth) + '.job',"w")
    with open(diagsubmitscript + '.job') as f:
        for line in f:
	    if '$forcingmonth' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingmonth', str(forcingmonth))
                newdiagsubmitscript.write(line)
	    elif '$parflowoutputdir' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$parflowoutputdir', str(parflowoutputdir))
		if 'timesteps' in line:
	            #replace the oldVar with the newVar:
	            stuff = line
	            line = stuff.replace('timesteps', str(endTS))
                newdiagsubmitscript.write(line)
            elif '$diagTarCmd' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$diagTarCmd', str(postprocess))
                newdiagsubmitscript.write(line)
	    else:
                newdiagsubmitscript.write(line)

    newnclsubmitscript = open('output_' + str(forcingmonth) + '/' + nclsubmitscript + '_' + str(forcingmonth) + '.job',"w")
    doneF=0
    doneI=0
    with open(nclsubmitscript + '.job') as f:
        for line in f:
	    if '$forcingmonth' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingmonth', str(forcingmonth))
                newnclsubmitscript.write(line)
            elif '$timestampdate' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$timestampdate', str(timestampstartdate))
                newnclsubmitscript.write(line)
	    elif '$endAbsTS' in line:
                #replace the oldVar with the newVar:
                stuff = line
                line = stuff.replace('$endAbsTS', str(endTS))
                newdiagsubmitscript.write(line)
            elif '$forcingmonthd' in line and doneF==0:
                #replace the oldVar with the newVar:
                stuff = line
                fmd = '%02d' % forcingmonth
	        line = stuff.replace('$forcingmonthd', fmd)
                newdiagsubmitscript.write(line)
                doneF=1
            elif '$interval' in line and doneI==0:
                #replace the oldVar with the newVar:
                stuff = line
                line = stuff.replace('$interval', str(interval))
                newdiagsubmitscript.write(line)
 		doneI=1
	    elif '$nclTarCmd' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$nclTarCmd', str(postprocess))
                newnclsubmitscript.write(line)
            else:
            	newnclsubmitscript.write(line)
    
def replacePostProScriptsWeekly(forcingyear,forcingWeek,restartWeeks,counter,press_icfile,runname,restartStep,timeDump,startinghour,pfltsperday,prefix,chunks,parflowdir,nclscript,diagscript,tarScript,parflowoutputdir,numncfiles,diagsubmitscript,nclsubmitscript):
    #this is for the extracting data step- see preprocessing scripts
    date = ""
    forcingweek=int(forcingWeek)
    d =  eowday_return(forcingyear, forcingweek)
    startdatelist = [0,0]
    enddatelist = [0,0]
    startdatelist = getstartdaydate_return(forcingyear, forcingweek)    
    enddatelist = getenddaydate_return(forcingyear, forcingweek, startdatelist)
        
    endTS=int(d)*int(pfltsperday)
    chunks=int(chunks)
    prevforcingweek=int(restartWeeks.split()[int(counter)])
    yearStart = forcingyear
    yearEnd = forcingyear
    if (prevforcingweek == 52):
	prevforcingyear = forcingyear - 1
    if (prevforcingweek == 0):
	# I don't know why this is here
	prevforcingweek = forcingweek - 1
	date = press_icfile
    timeStart = '01:00'
    timeEnd = '00:00'
    dayStart = '%02d' % startdatelist[0]
    dayEnd = '%02d' % enddatelist[0]
    monthStart = '%02d' % startdatelist[1]
    monthEnd = '%02d' % enddatelist[1]
    pressureDay = startdatelist[0]
    pressureMonth = startdatelist[1]
    weekStart = str(forcingweek)
    if(weekStart == '52' and str(startinghour) == "01"):
	monthEnd = '01'
	yearEnd = forcingyear + 1
	pressureTimeStart = "00:00"
	#Put in date of pressure initial condition: YYYY-MM-DD-HH:HH, it is the hour before the start time
    	date=str(yearStart) + "-" + str(monthStart) + "-" + str(dayStart) + "-" + pressureTimeStart
    elif (str(startinghour) == "00"):	    
	timeStart = '00:00'
	timeEnd = '23:00'
	weekStart = '%02d' % forcingweek
	weekEnd = '%02d' % forcingweek
	pressureYearStart = forcingyear
	if (forcingweek == 1):
	    pressureYearStart = forcingyear - 1
	pressureTimeStart = "23:00"
	pressureDay = pressureDay - 1
	if (pressureDay == 0):
            pressureMonth = pressureMonth - 1
	    if (pressureMonth == 0):
	        pressureMonth = 12
	    pressureDay = eomday_return(pressureYearStart, pressureMonth)
	
        pressureDayStart = '%02d' % pressureDay
	pressureMonthStart = '%02d' % pressureMonth
    	#Put in date of pressure initial condition: YYYY-MM-DD-HH:HH, it is the hour before the forcing start time
    	date=str(pressureYearStart) + "-" + str(pressureMonthStart) + "-" + str(pressureDayStart) + "-" + pressureTimeStart
    
    simulationtimespan = str(yearStart) + "-" + str(monthStart) + "-" + str(pressureDayStart) + "-" + str(timeStart) + "-" + str(yearEnd) + "-" + str(monthEnd) + "-" + str(dayEnd) + "-" + str(timeEnd)
    timeStart = '01:00'
    if (str(startinghour) == "00"):
        timeStart = '00:00'
    forcingtimespan = str(yearStart) + "-" + str(monthStart) + "-" + str(dayStart) + "-" + str(timeStart) + "-" + str(yearEnd) + "-" + str(monthEnd) + "-" + str(dayEnd) + "-" + str(timeEnd)
    if (prevforcingweek < 0):
	date=press_icfile 
           
    forcingDir=str(prefix) + "_" + str(forcingweek)
    numRestarts = endTS/(int(restartStep)/int(timeDump))
    postprocess = 'count=$(ls -1 *.nc 2>/dev/null | wc -l); if [ $? -ne 0 ] ; then echo \"postprocessing for week:' + str(forcingweek) + ' and year:' + str(forcingyear) + ' failed\"; exit 1234 ; elif (( $count==0 )); then echo \"no netcdf files found! postprocessing for week:' + str(forcingweek) + ' and year:' + str(forcingyear) + ' failed\"; exit 1234 ; else ./' + str(tarScript) + ' ' + str(parflowoutputdir) +  ' ' + str(runname) + ' ' + str(forcingDir) + ' ' + str(restartStep) + ' ' + str(timeDump) + ' ' + str(numRestarts) + ' ' + str(parflowdir) + ' ' + str(numncfiles) + '; fi'
    #for ncl submit script if divided into chunks
    interval=int(endTS / chunks) + (endTS % chunks > 0)

    newnclscript = open('output_' + str(forcingweek) + '/' + nclscript,"w")
    with open(nclscript) as f:
        for line in f:
	     if '$simulationtimespan' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$simulationtimespan', str(simulationtimespan))
                newnclscript.write(line)
 	     elif '$forcingtimespan' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingtimespan', str(forcingtimespan))
                newnclscript.write(line)
             elif '$date' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$date', str(date))
                newnclscript.write(line)
	     elif '$parflowoutputdir' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$parflowoutputdir', str(parflowoutputdir))
                newnclscript.write(line)
	     elif '$runname' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$runname', str(runname))
                newnclscript.write(line)
	     elif '$startTS' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$startTS', str(0))
		newnclscript.write(line)
	     elif '$endTS' in line:
		#replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$endTS', str(endTS))
                newnclscript.write(lin)
             else:
                newnclscript.write(line)
    
    timestampstartdate = str(forcingyear)+'-'+str(monthStart)+'-'+str(dayStart)
    diagsubmitscript=diagsubmitscript.replace('.job','')
    newdiagsubmitscript = open('output_' + str(forcingweek) + '/' + diagsubmitscript + '_' + str(forcingweek) + '.job',"w")
    with open(diagsubmitscript + '.job') as f:
        for line in f:
	    if '$endAbsTS' in line:
                #replace the oldVar with the newVar:
                stuff = line
                line = stuff.replace('$endAbsTS', str(endTS))
                newdiagsubmitscript.write(line)
	    elif '$timestampdate' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$timestampdate', str(timestampstartdate))
                newnclsubmitscript.write(line)
	    elif '$forcingweek' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingweek', str(forcingweek))
                newdiagsubmitscript.write(line)
	    elif '$parflowoutputdir' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$parflowoutputdir', str(parflowoutputdir))
		if 'timesteps' in line:
	            #replace the oldVar with the newVar:
	            stuff = line
	            line = stuff.replace('timesteps', str(endTS))
                newdiagsubmitscript.write(line)
            elif '$diagTarCmd' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$diagTarCmd', str(postprocess))
                newdiagsubmitscript.write(line)
	    else:
                newdiagsubmitscript.write(line)

    nclsubmitscript=nclsubmitscript.replace('.job','')
    newnclsubmitscript = open('output_' + str(forcingweek) + '/' + nclsubmitscript + '_' + str(forcingweek) + '.job',"w")
    timestampstartdate = str(forcingyear)+'-'+str(monthStart)+'-'+str(dayStart)
    with open(nclsubmitscript + '.job') as f:
        for line in f:
	    if '$timestampdate' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$timestampdate', str(timestampstartdate))
                newnclsubmitscript.write(line)
	    elif '$endAbsTS' in line:
                #replace the oldVar with the newVar:
                stuff = line
                line = stuff.replace('$endAbsTS', str(endTS))
                newnclsubmitscript.write(line)
	    elif '$forcingweek' in line:
                #replace the oldVar with the newVar:
                stuff = line
                line = stuff.replace('$forcingweek', str(forcingweek))
                newnclsubmitscript.write(line)
	    elif '$nclTarCmd' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$nclTarCmd', str(postprocess))
                newnclsubmitscript.write(line)
            else:
            	newnclsubmitscript.write(line)

def replacePostProScript(forcingyear,forcingmonth,runname,restartStep,timeDump,pfltsperday,prefix,diagscript,parflowoutputdir,diagsubmitscript):
    #this is for the extracting data step- see preprocessing scripts but with no need to convert to NetCDF beforehand
    d = eomday_return(forcingyear, forcingmonth)
    endTS=int(d)*int(pfltsperday)
    dayStart = '01'
    forcingDir=str(prefix) + "_" + str(forcingmonth)
    numRestarts = endTS/(int(restartStep)/int(timeDump))
    postprocess = 'if [ $? -ne 0 ] ; then echo \"postprocessing for month:' + str(forcingmonth) + ' and year:' + str(forcingyear) + ' failed\"; exit 1234 ; else ./tarCmd.sh ' + str(parflowoutputdir) +  ' ' + str(runname) + ' ' + str(forcingDir) + ' ' + str(restartStep) + ' ' + str(timeDump) + ' ' + str(numRestarts) + '; fi'

    timestampstartdate = str(forcingyear)+'-'+str(forcingMonth)+'-'+str(dayStart)
    diagsubmitscript=diagsubmitscript.replace('.job','')
    newdiagsubmitscript = open('output_' + str(forcingmonth) + '/' + diagsubmitscript + '_' + str(forcingmonth) + '.job',"w")
    with open(diagsubmitscript + '.job') as f:
        for line in f:
	    if '$forcingmonth' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$forcingmonth', str(forcingmonth))
                newdiagsubmitscript.write(line)
	    elif '$parflowoutputdir' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$parflowoutputdir', str(parflowoutputdir))
		if 'timesteps' in line:
	            #replace the oldVar with the newVar:
	            stuff = line
	            line = stuff.replace('timesteps', str(endTS))
                newdiagsubmitscript.write(line)
            elif '$diagTarCmd' in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace('$diagTarCmd', str(postprocess))
                newdiagsubmitscript.write(line)
	    else:
                newdiagsubmitscript.write(line)


def getPrefix(monthfile, path, year):
    prefix=monthfile.split(path)[1]
    prefix=prefix.split(year)[0]
    print prefix

def getPrevNCFile(netCDFfileprefix, forcingyear, forcingmonth, fileInterval):
    forcingmonth = int(forcingmonth)
    if (forcingmonth == 1):
	prevforcingm = 12
	prevforcingyear = forcingyear - 1
    else:
	prevforcingm=forcingmonth-1
	prevforcingyear=forcingyear
    d = eomday_return(prevforcingyear, prevforcingmonth)
    day = '%02d' % d
    prevforcingmonth = '%02d' % prevforcingm
    #assumes WRF daily files are always named according to the following convention:
    #netCDFfileprefixYYYYMMDD000000.nc:
    if (fileInterval == 'DAILY'):
	prevncfile = netCDFfileprefix + str(prevforcingyear) + prevforcingmonth + day + '000000.nc'
    #assumes WRF monthly files are always named according to the following convention:
    #netCDFfileprefixYYYYMM01000000-YYYYNM01000000.nc:
    if (fileInterval == 'MONTHLY'):
	nextm = prevforcingm + 1
	nextyear = prevforcingyear
	if (nextm > 12):
	    nextm = 1
	    nextyear = forcingyear
	nextmonth = '%02d' % nextm
  	prevncfile = netCDFfileprefix + str(prevforcingyear) + prevforcingmonth + '01000000-' + str(nextyear) + nextmonth + '01000000.nc'
    print prevncfile

def getDateFromForcingDir(forcingfileprefix, forcingDir, time):
    #assumes forcing directories are always named according to the convention:
    #forcingPrefix_YYYY_MM, assume simulation starts on the first of each month:
    pseudoDate = forcingDir.strip(forcingPrefix)
    dateArray = pseudoDate.split('_')
    #Put in: YYYY-MM-DD-HH:HH
    date = dateArray[0] + "-" + dateArray[1] + "-" + "01" + "-" + time
    print date

def getForcingDir(actualForcingFile, forcingDirArray):
    forcingDirs = []
    if (',' in forcingDirArray):
        forcingDirs = [x.strip() for x in forcingDirArray.split(',')]
    else:
        forcingDirs.append(forcingDirArray)
    for dirF in forcingDirs:
	if (actualForcingFile.find(str(dirF)) >= 0):
	    print dirF
            break

def writeSubmitScriptWithNewVariable(oldSubmitScript, newSubmitScript, oldVar, newVar):
    newScript = open(newSubmitScript,"w")
    with open(oldSubmitScript) as f:
        for line in f:
            if oldVar in line:
	        #replace the oldVar with the newVar:
	        stuff = line
	        line = stuff.replace(str(oldVar), str(newVar))
                newScript.write(line)
            else:
                newScript.write(line)	
   
def getstartdaydate_return(year, week):
    w = int(week)
    #returns the number of days in a given month
    date = [0,0]
    start_days_per_week = [1, 8, 15, 22, 29, 5, 12, 19, 26, 5, 12, 19, 26, 2, 9, 16, 23, 30, 7, 14, 21, 28, 4, 11, 18, 25, 2, 9, 16, 23, 30, 6, 13, 20, 27, 3, 10, 17, 24, 1, 8, 15, 22, 29, 5, 12, 19, 26, 3, 10, 17, 24]
    start_months_per_week = [1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12]
    leap_start_days_per_week = [1, 8, 15, 22, 29, 5, 12, 19, 26, 4, 11, 18, 25, 1, 8, 15, 22, 29, 6, 13, 20, 27, 3, 10, 17, 24, 1, 8, 15, 22, 29, 5, 12, 19, 26, 2, 9, 16, 23, 30, 7, 14, 21, 28, 4, 11, 18, 24, 2, 9, 16, 23]
    leap_start_months_per_week = [1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12]

    startday = start_days_per_week[w - 1]
    startmonth = start_months_per_week[w - 1]
    if (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
         startday = leap_start_days_per_week[w - 1]
    	 startmonth = leap_start_months_per_week[w - 1]
    date[0] = startday
    date[1] = startmonth
    return date

def getenddaydate_return(year, week, startdatelist):
    enddatelist = [0,0]
    startday = startdatelist[0]
    startmonth = startdatelist[1]
    endofmonthday = eomday_return(year,startmonth)
    endday = startday + 6
    endmonth = startmonth
    if (endday > endofmonthday):
        endmonth = startmonth + 1
        endday = endday - endofmonthday
    enddatelist[0] = endday
    enddatelist[1] = endmonth
    return enddatelist

def eowday(year, week):
    w = int(week)
    #returns the number of days in a given month
    d = 7
    if w == 52:
        d = 8
    if w == 52 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 9
    print d

def eomday(year, month):
    m = int(month)
    #returns the number of days in a given month
    days_per_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
    d = days_per_month[m - 1]
    if m == 2 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 29
    print d

def eowday_return(year, week):
    w = int(week)
    #returns the number of days in a given month
    d = 7
    if w == 52:
        d = 8
    if w == 52 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 9
    return d

def eomday_return(year, month):
    m = int(month)
    #returns the number of days in a given month
    days_per_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
    d = days_per_month[m - 1]
    if m == 2 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 29
    return d

def numts_weeks(year, week, numpfltsperday):
    w = int(week)
    #returns the number of days in a given month
    d = 7
    if w == 52:
        d = 8
    if w == 52 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 9
    ts = d * pfltspd
    print ts

def numts(year, month, numpfltsperday):
    m = int(month)
    pfltspd = int(numpfltsperday)
    #returns the number of timesteps in a given month
    days_per_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31] 
    d = days_per_month[m - 1]
    if m == 2 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0): 
        d = 29
    ts = d * pfltspd
    print ts

#This function only works for certain situations otherwise endless loop
def decomp_dim(tasks, return_index):
    dist = [0, 0]
    index = 0

    while dist[0]*dist[1] < tasks:
        dist[index % 2] += 1
        index += 1

    if not dist[0]*dist[1] == tasks:
        while not dist[0]*dist[1] == tasks:
            dist[0] += 1
            dist[1] -= 1
    
    print dist[return_index]

def decomp_dim_array(currentTasks, tasksArray, NParray, NQarray, return_index):
    dist = [0, 0]
    listindex = 0
    
    for tasks in tasksArray:
        if tasks == currentTasks:
	    break
	listindex += 1
  
    dist = [NParray[listindex], NQarray[listindex]]
    print dist[return_index]

#Domain decomp: would be so much easier if imports worked  
def decomp_dim_bq(tasks, taskspernode, nodes, aspectx, aspecty, return_index):
    dist = [0, 0]
    index = 0
    driver = 0    
    if tasks % taskspernode != 0:
	sys.exit("Can not use decomp dim bq if taskspernode is not a divisor of tasks! Exiting\n")
    
    #Check for square number
    sqrt=tasks**(0.5)
    if(int(sqrt) == sqrt):
	dist = [sqrt, sqrt]
	#print dist
    #Then check for specified aspect ratio: Eg if tasks per node == 16, add 16 each time to get to get driver then multiply by x and y aspect ratio
    if not dist[0]*dist[1] == tasks:
        while not dist[0]*dist[1] == tasks:
	    driver += taskspernode
            dist[index % 2] = aspectx*driver
	    dist[(index+1)%2] = aspecty*driver
	    #print dist[0]
	    #print str(dist[1]) + '\n\n'
            index += 2
    
    print dist[return_index]


def string_pre(profiler_index):
    """
    save the strings needed for the preprocessing sub in the submit script
    """
    data_dict = {
        'none': '',
        'darshan': 'source ./$envfile\n'
            + 'export LD_PRELOAD=$$EBROOTDARSHANMINRUNTIME/lib/libdarshan.so\n'
            + 'export DARSHAN_LOGFILE=darshan.log\n',
        'scorep': 'source ./env.ini\n'
            + 'export SCOREP_TOTAL_MEMORY=150MB\n'
            + 'export SCOREP_METRIC_RUSAGE_PER_PROCESS=ru_inblock,ru_oublock\n'
            + 'export SCOREP_FILTERING_FILE=filter\n'
            + 'export SCAN_ANALYZE_OPTS="--verbose --time-correct"\n'
            + 'export SCOREP_METRIC_PAPI=PAPI_TOT_INS,PAPI_TOT_CYC,PAPI_L1_DCM,PAPI_L2_DCM\n'
    }

    print data_dict[profiler_index]


def string_measure(profiler_index):
    """
    save the strings for the measurement sub in the submit script
    """
    data_dict = {
        'none': '',
        'darshan': 'time',
        'scorep': 'scan'
    }

    print data_dict[profiler_index]


def string_post(profiler_index):
    """
    save the strings for the post sub in the submit script
    """
    data_dict = {
        'none': '',
        'darshan': 'darshan-parser setup_submit_run/$DARSHAN_LOGFILE',
        'scorep': ''
    }

    print data_dict[profiler_index]
