#/usr/bin/ksh
PARFLOW_REV=r693
PARFLOW_DIR=/homea/slts/slts14/parFlow_EoCoE/eocoe_benchmarking/src/ParFlow.${PARFLOW_REV}
PARFLOW_SRC=/homea/slts/slts14/parFlow_EoCoE/eocoe_benchmarking/src
PARFLOW_TARBALL=/homeb/zam/benchmark/ParFlow/src/ParFlow.${PARFLOW_REV}.tar.gz
PARFLOW_COMPILE=1
PARFLOW_CLEAN_COMPILE=1
PARFLOW_EXTRACT_SRC=1
PARFLOW_COMPILE_CLM=1

if (( $PARFLOW_COMPILE == 1 )) ; then

    if (( $PARFLOW_EXTRACT_SRC == 1 )) ; then
       rm -rf $PARFLOW_DIR
       tar -xvzf $PARFLOW_TARBALL -C $PARFLOW_SRC
    fi

    # patch for orig r693 from FGa
    if [[ $PARFLOW_REV =~ "r693" ]]; then
       cp ${PARFLOW_SRC}/pf_pfmg_octree.c ${PARFLOW_DIR}/pfsimulator/parflow_lib/.
    fi

    source $(pwd)/env.ini

    MPIDIR=$EBROOTPSMPI
    SILO_DIR=$EBROOTSILO
    HYPRE_DIR=$EBROOTHYPRE
    TCL_DIR=$EBROOTTCL

    CC=$MPIDIR/bin/mpicc
    CXX=$MPIDIR/bin/mpic++
    FC=$MPIDIR/bin/mpif90
    export CFLAGS=

    cd $PARFLOW_DIR/pfsimulator

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if [[ $PARFLOW_REV =~ "v320" ]]; then
       if (( $PARFLOW_COMPILE_CLM == 1 )); then
          ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-clm --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing
       else
          ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing
       fi
    else
       if (( $PARFLOW_COMPILE_CLM == 1 )); then
          ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-clm --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing --enable-opt="-O3 -xCORE-AVX2"
       else
          ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing --enable-opt="-O3 -xCORE-AVX2"
       fi   
    fi
    
    #needed due to automodel, gfortran is irrelevant
    if ! [[ $PARFLOW_REV =~ "v320" ]]; then
       sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DIR/pfsimulator/model/Makefile.model
       sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
       sed "s/ m /  -lm  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
       sed "s/-l /  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
       # due to the usage of gfortran intel opt flags need to be removed from that call
       sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    fi

    if [[ $PARFLOW_REV == "v320" ]]; then
       sed -i 's@-lmpi"@@' $PARFLOW_DIR/pfsimulator/model/Makefile.model
    fi
    make
    make install

    echo "ParFlow compilation done"

    cd $PARFLOW_DIR/pftools

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

     ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-opt="-O3 -xCORE-AVX2"

    #needed due to automodel, gfortran is irrelevant
    if ! [[ $PARFLOW_REV =~ "v320" ]]; then
      sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DIR/pftools/model/Makefile.model
       sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
       sed "s/ m /  -lm  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
       sed "s/-l /  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
       # due to the usage of gfortran intel opt flags need to be removed from that call
       sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    fi
 
    if [[ $PARFLOW_REV =~ "v320" ]]; then
       sed -i 's@-lmpi"@@' $PARFLOW_DIR/pftools/model/Makefile.model
    fi
    make
    make install

    echo "ParFlow tools compilation done"

else

    echo "ParFlow was not recompiled for this run"

fi
