#Some useful functions   
def eomday(year, month):
    m = int(month)
    #returns the number of days in a given month
    days_per_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
    d = days_per_month[m - 1]
    if m == 2 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 29
    print d

def eomday_return(year, month):
    m = int(month)
    #returns the number of days in a given month
    days_per_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
    d = days_per_month[m - 1]
    if m == 2 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0):
        d = 29
    return d


def numts(year, month, numpfltsperday):
    m = int(month)
    pfltspd = int(numpfltsperday)
    #returns the number of timesteps in a given month
    days_per_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31] 
    d = days_per_month[m - 1]
    if m == 2 and (year % 4 == 0 and year % 100 != 0 or year % 400 == 0): 
        d = 29
    ts = d * pfltspd
    print ts

#This function only works for certain situations otherwise endless loop
def decomp_dim(tasks, return_index):
    dist = [0, 0]
    index = 0

    while dist[0]*dist[1] < tasks:
        dist[index % 2] += 1
        index += 1

    if not dist[0]*dist[1] == tasks:
        while not dist[0]*dist[1] == tasks:
            dist[0] += 1
            dist[1] -= 1
    
    print dist[return_index]

def decomp_dim_array(currentTasks, tasksArray, NParray, NQarray, return_index):
    dist = [0, 0]
    listindex = 0
    if not isinstance( tasksArray, (frozenset, list, set, tuple,) ):   
        dist = [NParray,NQarray]
    else:
        for tasks in tasksArray:
            if tasks == currentTasks:
	        break
	    listindex += 1
  
    	dist = [NParray[listindex], NQarray[listindex]]
    print dist[return_index]

#Domain decomp: would be so much easier if imports worked  
def decomp_dim_bq(tasks, taskspernode, nodes, aspectx, aspecty, return_index):
    dist = [0, 0]
    index = 0
    driver = 0    
    if tasks % taskspernode != 0:
	sys.exit("Can not use decomp dim bq if taskspernode is not a divisor of tasks! Exiting\n")
    
    #Check for square number
    sqrt=tasks**(0.5)
    if(int(sqrt) == sqrt):
	dist = [sqrt, sqrt]
	#print dist
    #Then check for specified aspect ratio: Eg if tasks per node == 16, add 16 each time to get to get driver then multiply by x and y aspect ratio
    if not dist[0]*dist[1] == tasks:
        while not dist[0]*dist[1] == tasks:
	    driver += taskspernode
            dist[index % 2] = aspectx*driver
	    dist[(index+1)%2] = aspecty*driver
	    #print dist[0]
	    #print str(dist[1]) + '\n\n'
            index += 2
    
    print dist[return_index]


def string_pre(profiler_index):
    """
    save the strings needed for the preprocessing sub in the submit script
    """
    data_dict = {
        'none': '',
        'darshan': 'source ./$envfile\n'
            + 'export LD_PRELOAD=$$EBROOTDARSHANMINRUNTIME/lib/libdarshan.so\n'
            + 'export DARSHAN_LOGFILE=darshan.log\n',
        'scorep': 'source ./env.ini\n'
            + 'export SCOREP_TOTAL_MEMORY=150MB\n'
            + 'export SCOREP_METRIC_RUSAGE_PER_PROCESS=ru_inblock,ru_oublock\n'
            + 'export SCOREP_FILTERING_FILE=filter\n'
            + 'export SCAN_ANALYZE_OPTS="--verbose --time-correct"\n'
            + 'export SCOREP_METRIC_PAPI=PAPI_TOT_INS,PAPI_TOT_CYC,PAPI_L1_DCM,PAPI_L2_DCM\n'
    }

    print data_dict[profiler_index]


def string_measure(profiler_index):
    """
    save the strings for the measurement sub in the submit script
    """
    data_dict = {
        'none': '',
        'darshan': 'time',
        'scorep': 'scan'
    }

    print data_dict[profiler_index]


def string_post(profiler_index):
    """
    save the strings for the post sub in the submit script
    """
    data_dict = {
        'none': '',
        'darshan': 'darshan-parser setup_submit_run/$DARSHAN_LOGFILE',
        'scorep': ''
    }

    print data_dict[profiler_index]
