# Runs a simple output check against a gold standard file

# Import the ParFlow TCL package
#

set tcl_precision 17
set sig_digits 6

lappend auto_path $env(PARFLOW_DIR)/bin
package require parflow
namespace import Parflow::*

pfset FileVersion 4

set runname  "#RUNNAME#"
set comparisonfile "#COMPARISONFILE#"

#-----------------------------------------------------------------------------
# Run and do tests
#-----------------------------------------------------------------------------

source pftest.tcl
set passed 1
set i "#COMPARISONSTEP#"

set newfile "$runname.out.press.$i.pfb"
puts $newfile
puts $comparisonfile

if ![pftestFile $comparisonfile $newfile "Max difference in Pressure for timestep $i" $sig_digits] {
    set passed 0
}


if $passed {
    puts "benchmark : PASSED"
} {
    puts "benchmark : FAILED"
}

