#/usr/bin/ksh

PARFLOW_DESIRED_DIR=$PARFLOW_DIR
PARFLOW_DIR=$PARFLOW_SRC/ParFlow.r${PARFLOW_REV}
PARFLOW_SRC=$PARFLOW_SRC

if (( $PARFLOW_COMPILE_TRUE == 1 )) ; then

    if (( $PARFLOW_EXTRACT_SRC_TRUE == 1 )) ; then
        wdir=$(pwd)
        cd $PARFLOW_DIR_EXTRACT
        echo $PARFLOW_DIR
        if [[ -d "${PARFLOW_DESIRED_DIR}" ]] ; then
           rm -rf $PARFLOW_DESIRED_DIR
        fi
        tar -xvzf $PARFLOW_SRC/ParFlow.r${PARFLOW_REV}.tar.gz
	cd $wdir
    elif (( $PARFLOW_DOWNLOAD_SRC_TRUE == 1 )) ; then
        wdir=$(pwd)
        cd $PARFLOW_DIR_EXTRACT
        echo $PARFLOW_DIR
        if [[ -d "${PARFLOW_DESIRED_DIR}" ]] ; then
           rm -rf $PARFLOW_DESIRED_DIR
        fi
        #If this particular revision has already been downloaded- remove it
        if [[ -e "Parflow.r${PARFLOW_REV}.tar.gz" ]] ; then
             rm -f Parflow.r${PARFLOW_REV}.tar.gz
        fi
        # Use the web version revision nomenclature, where the revision number is given by the user:
        wget "http://inside.mines.edu/~rmaxwell/ParFlow.r${PARFLOW_REV}.tar.gz"
        tar -xvzf $PARFLOW_SRC/ParFlow.r${PARFLOW_REV}.tar.gz
        cd $wdir
    fi

    
    # patch for orig r693 from FGa
    if [[ $PARFLOW_REV == "693" ]]; then
        cp ${PARFLOW_SRC}/pf_pfmg_octree.c ${PARFLOW_DIR}/pfsimulator/parflow_lib/.
    fi
    # We do not need it 
    #source $(pwd)/env_jureca.ini

    MPIDIR=$EBROOTPSMPI
    SILO_DIR=$EBROOTSILO
    HYPRE_DIR=$EBROOTHYPRE
    TCL_DIR=$EBROOTTCL

    CC=#MPICC#
    CXX=#MPIC++#
    FC=#MPIF90#
    export CFLAGS=#CFLAGS#

    #PATCHES#

    cd $PARFLOW_DIR/pfsimulator

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if (( $PARFLOW_COMPILE_CLM == 1 )) ; then
        if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
            ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-clm --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing --enable-opt=#OPT_FLAGS#
        else
            ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-clm --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --enable-timing --enable-opt=#OPT_FLAGS#
        fi
    else
        if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
            ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing --enable-opt=#OPT_FLAGS#
        else
            ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --enable-timing --enable-opt=#OPT_FLAGS#
        fi
    fi

    #needed due to automodel, gfortran is irrelevant
    sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DIR/pfsimulator/model/Makefile.model
    sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    sed "s/ m /  -lm  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    sed "s/-l /  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    # due to the usage of gfortran intel opt flags need to be removed from that call
    sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
   
    #PREMAKE#

    make
    make install

    echo "ParFlow compilation done"

    #pftools are not available with some profiler wrappers so need to change this to plain mpicc etc

    CC=#CC#
    CXX=#CXX#
    FC=#FC#

    cd $PARFLOW_DIR/pftools

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
        ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-opt=#OPT_FLAGS#
    else
        ./modelure CC="$CC -qopenmp" CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --with-amps=mpi1 --enable-opt=#OPT_FLAGS#
    fi

    #needed due to automodel, gfortran is irrelevant
    sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DIR/pftools/model/Makefile.model
    sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    sed "s/ m /  -lm  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    sed "s/-l /  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    # due to the usage of gfortran intel opt flags need to be removed from that call
    sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DIR/pftools/model/Makefile.model

    make
    make install

    echo "ParFlow tools compilation done"
    cd $PARFLOW_SRC
    if (( $PARFLOW_DOWNLOAD_SRC_TRUE == 1 )) ; then
        rm -f $PARFLOW_SRC/ParFlow.r${PARFLOW_REV}.tar.gz
    fi
    mv $PARFLOW_DIR $PARFLOW_DESIRED_DIR
else

    echo "ParFlow was not recompiled for this run"
fi
