#/usr/bin/ksh

if (( $PARFLOW_COMPILE == 1 )) ; then

    PARFLOW_DIR=$PARFLOW_DIR
    PARFLOW_SRC=$PARFLOW_SRC

    if (( $PARFLOW_EXTRACT_SRC == 1 )) ; then
       wdir=$(pwd)
       cd $PARFLOW_DIR_EXTRACT
       rm -rf $PARFLOW_DIR
       tar -xvzf $PARFLOW_SRC/ParFlow.r693.tar.gz
       cd $wdir
    fi

    # patch for orig r693 from FGa
    cp ${PARFLOW_SRC}/pf_pfmg_octree.c ${PARFLOW_DIR}/pfsimulator/parflow_lib/.

    source $(pwd)/env.ini

    MPIDIR=$EBROOTPSMPI
    SILO_DIR=$EBROOTSILO
    HYPRE_DIR=$EBROOTHYPRE
    TCL_DIR=$EBROOTTCL

    CC=#MPICC#
    CXX=#MPIC++#
    FC=#MPIF90#

    cd $PARFLOW_DIR/pfsimulator

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
        ./modelure CC=$CC CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-timing --enable-opt=#OPT_FLAGS#
    else
        ./modelure CC=$CC CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-hypre=$HYPRE_DIR --with-amps=mpi1 --enable-timing --enable-opt=#OPT_FLAGS#
    fi

    #needed due to automodel, gfortran is irrelevant
    sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DIR/pfsimulator/model/Makefile.model
    sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    sed "s/ m /  -lm  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    sed "s/-l /  /g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model
    # due to the usage of gfortran intel opt flags need to be removed from that call
    sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DIR/pfsimulator/model/Makefile.model

    make
    make install

    echo "ParFlow compilation done"

    cd $PARFLOW_DIR/pftools

    if (( $PARFLOW_CLEAN_COMPILE == 1 )) ; then
        make clean
    fi

    if (( $PARFLOW_UNDISTRIBUTED_FILE == 1 )) ; then
        ./modelure CC=$CC CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --with-amps=mpi1 --with-amps-sequential-io --enable-opt=#OPT_FLAGS#
    else
        ./modelure CC=$CC CXX=$CXX FC=$FC --prefix=$PARFLOW_DIR --with-silo=$SILO_DIR --with-tcl=$TCL_DIR --with-amps=mpi1 --enable-opt=#OPT_FLAGS#
    fi

    #needed due to automodel, gfortran is irrelevant
    sed -i 's@\" \-lmpi \-lifport \-lifcoremt \-limf \-lsvml \-lm \-lipgo \-lirc \-lpthread \-lgcc \-lgcc_s \-lirc_s \-ldl \-lm  \-lmpifort \-lmpi\"@@' $PARFLOW_DIR/pftools/model/Makefile.model
    sed "s/ gfortran /  -lgfortran  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    sed "s/ m /  -lm  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    sed "s/-l /  /g" -i $PARFLOW_DIR/pftools/model/Makefile.model
    # due to the usage of gfortran intel opt flags need to be removed from that call
    sed "s/FFLAGS        = -O.*/FFLAGS        = -O3 \$(FFLAGS_EXTRA)/g" -i $PARFLOW_DIR/pftools/model/Makefile.model

    make
    make install

    echo "ParFlow tools compilation done"

else

    echo "ParFlow was not recompiled for this run"

fi
