MODULE variables
 IMPLICIT NONE
 !variables needed by the AD part of the code
 INTEGER, PARAMETER :: width=11		!number of columns in the jacobian
 REAL :: seed_matrix(width,width)=0	!seed matrix that comprise the seed vectors x-dot_k
 REAL, DIMENSION(width) :: cft2d,cfnhd,cfhhd,cfuad,cfabd,cfasd,&
                           cfald,clad,clod,cz0d,chud !elements of the seed vector
 !dot-x_k = (/cft2d(k),cfnhd(k),cfhhd(k),cfuad(k),cfabd(k),cfasd(k),cfald(k),
 !clad(k),clod(k),cz0d(k),chud(k)/)^T
 DATA cft2d/1,0,0,0,0,0,0,0,0,0,0/
 DATA cfnhd/0,1,0,0,0,0,0,0,0,0,0/
 DATA cfhhd/0,0,1,0,0,0,0,0,0,0,0/
 DATA cfuad/0,0,0,1,0,0,0,0,0,0,0/
 DATA cfabd/0,0,0,0,1,0,0,0,0,0,0/
 DATA cfasd/0,0,0,0,0,1,0,0,0,0,0/
 DATA cfald/0,0,0,0,0,0,1,0,0,0,0/
 DATA  clad/0,0,0,0,0,0,0,1,0,0,0/
 DATA  clod/0,0,0,0,0,0,0,0,1,0,0/
 DATA  cz0d/0,0,0,0,0,0,0,0,0,1,0/
 DATA  chud/0,0,0,0,0,0,0,0,0,0,1/
 REAL, DIMENSION(10,width) :: jacobian
 REAL, DIMENSION(width,10) :: resultsd=0
 !results produced by DO_EVUOT (the standard output)
 REAL, DIMENSION(10) :: results=0
 !variables for the main loop of the wrapper
 INTEGER :: stat,i,j,k=1,f
 !---------- input variables to the subroutine DO_EVUOT_DV ----------
 !latitude, longitude, wind speed measurent height
 REAL :: CLA=60.30,CLO=24.85,CHU=10.0
 !This does nothing in the subroutine do_evuot_d at the moment (no table lookup) but passed to it anyway.
 REAL, DIMENSION(10) :: ALB
 !variables in a input file that are not needed here but passed to DO_EVUOT anyway
 REAL :: CFNR=-9.9,CFST=-9.9,CFVU=2079.0,CFKU=12.0,CFPV=28.0, &
	       CFKL=1200.0,CFPR=-9.9,CFUU=-9.9,CFSU=-9.9,CFNN=-9.9, &
	       CFTD=-9.9,CFTW=-9.9,CFRR=-9.9,CFVV=-9.9,CFWW=-9.9, &
         CFW1=-9.9,CFW2=-9.9,CFCL=-9.9,CFCM=-9.9,CFCH=-9.9, &
	       CFDD=-9.9,CFAP=-9.9
 !The artificial input data : albedo cloudCover cloudHeight moistureParameter solarRadiation temperature windSpeed z0
 REAL :: CFAB,CFNH,CFHH,CFAL,CFAS,CFT2,CFUA,CZ0
 !file header
 CHARACTER(LEN=101) :: header
 !read data input from these files
 CHARACTER (len=70), dimension(2) :: input_file
 DATA input_file/'../input/variable_range.txt','../input/variable_range_ws.txt'/
 !---------- header strings for the output files ----------
 CHARACTER (len=30), dimension(11) :: info
 DATA info/'temperature','cloudCover','cloudHeight','windSpeed','albedo','solarRadiation',&
	   'moistureParameter','latitude','longitude','z0','measurementHeight'/
 CHARACTER (len=6), dimension(11) :: names
 !---------- file names for the output files ----------
 CHARACTER (len=30), dimension(10) :: file_name
 DATA file_name/'albedo.dat','solarElevation.dat','solarRadiation.dat','moisture_parameter.dat',&
		'obukhov_length.dat','temperature_scale.dat','friction_velocity.dat','sensible_heat_flux',&
		'net_radiation.dat','latent_heat_flux.dat'/
 !logical variable for overwriting existing files
 LOGICAL :: over_write=.TRUE.
 !vector comprising the data output (not sensitivity info) from DO_EVUOT_DV
 REAL, DIMENSION(36) :: output_data
END MODULE variables
