SUBROUTINE SAVE_DATA(info,file_name,jacobian,over_write,output_data,line,f)
 IMPLICIT NONE
 !input
 CHARACTER (len=30), dimension(11), INTENT(IN) :: info
 CHARACTER (len=30), dimension(10), INTENT(IN) :: file_name
 REAL, INTENT(IN) :: jacobian(10,11)
 INTEGER, INTENT(IN) :: f
 REAL, DIMENSION(36), INTENT(IN) :: output_data
 INTEGER, INTENT(IN) :: line
 LOGICAL, INTENT(IN) :: over_write
 !local variables
 INTEGER :: file_id, i,j,yy_mm_dd_HH(4)
 CHARACTER (len=6), dimension(1) :: header
 CHARACTER (len=20), dimension(2) :: output_folder
 DATA output_folder/'../output/','../output_ws/'/
 DATA header/'line'/
 !date information
 yy_mm_dd_HH = INT(output_data(3:6))
 !reset the files that comprise one row of the jacobian
 IF ( over_write ) THEN
	DO i=1,SIZE(file_name)
		file_id = i+110
		OPEN(file_id,file=TRIM(output_folder(f)) // TRIM(file_name(i)),action='write',status='replace')
		!WRITE(file_id,FMT='(A9,11A30)') header,info
		write(file_id,*) header,(TRIM(info(j))// '  ',j=1,SIZE(info))
		CLOSE(file_id)
	END DO
 END IF

 !write the partial derivatives in different files (one row of the jacobian in a different file)
 DO i=1,SIZE(file_name)
	file_id = i+110
	OPEN(file_id,file=TRIM(output_folder(f)) // TRIM(file_name(i)),action='write',status='old',position='append')
	write(file_id,FMT='(1I9,11E13.3)') line,jacobian(i,:)
	CLOSE(file_id)
 END DO

 !reset the results file and add a (cryptic) header line
 IF ( over_write ) THEN
	OPEN(100,file= TRIM(output_folder(f)) // 'evuot_res.dat',action='write',status='replace')
	!'temperature','cloudCover','cloudHeight','windSpeed','albedo','solarRadiation','moistureParameter','latitude','lonitude','z0','measurementHeight'/
	!						 col.  column content
	WRITE(100,*) 	'NUM    ',&	        !1     record numer
		  	'LPNN    ',&			          !2     staion id
			'YYYY    ',&			            !3     year
			'MM    ',&			              !4     month
			'DD    ',&			              !5     day
			'HH24    ',&			            !6     hour
			'P_SEA    ',&			            !7     sea level pressure
			'temperature    ',&		        !8  i  temperature at 2 metres (k)
			'RH    ',&			              !9     relative hmidity
			'GROUND    ',&			          !10    state of the ground
			'N    ',&			                !11    total cloudiness
			'TD    ',&			              !12    dew point tempemperature (K)
			'TW    ',&			              !13    wet-bulb temperature (K)
			'R_1H    ',&			            !14    amount of rain (mm/12h)
			'VIS    ',&			              !15    visibility (m)
			'WW_COMB    ',&			          !16    synop code (0-99)
			'W1    ',&			              !17    weather druring previous hour
			'W2    ',&			              !18    weather during previous 3 h
			'cloudCover    ',&	       	  !19 i  amount of low clouds (0-1)
			'CL    ',&			              !20    type of low clouds (code 0-9)
			'cloudHeight    ',&		        !21 i  height of low clouds (m)
			'CM    ',&			              !22    type of middle clouds (code 0-10)
			'CH    ',&			              !23    type of high clouds (code 0-10)
			'DIRECTION_OF_FLOW    ',&	    !24    direction of wind flow (N = 270 degrees)
			'windSpeed    ',&		          !25 i  wind speed at 10 metres (m/s)
			'SUN_DUR_U    ',&		          !26    hourly amount of sunshine (0-1)
			'albedo    ',&			          !27 io surface albedo
			'SOLAR_ELEV    ',&		        !28  o solar elevation
			'solarRadiation    ',&        !29 io solar radiation (W/m²)
			'moistureParameter    ',&	    !30 io moisture parameter (0.5-1.0)
			'obukhov_length    ',&        !31  o inverse obukhov length (1/m)
			'temperature_scale    ',&	    !32  o temperature scale (K)
			'friction_velocity    ',&	    !33  o friction velocity (m/s)
			'sensible_heat_flux    ',&	  !34  o turbulent/sensible heat flux (W/m²)
			'net_radiation    ',&		      !35  o net radiation (W/m²)
			'latent_heat_flux    '		    !36  o latent heat flux (W/m²)
	CLOSE(100)
 END IF

 101 FORMAT(I9,2I6,2I4,I6,3E13.3,I4,E13.3,2E13.3,E13.3,I7, &
            I4,2I4,E13.3,I4,I6,2I4,E13.3,E13.3,E13.3, &
            E13.3,E13.3,E13.3,E13.3,6E13.3)

 OPEN(100,file=TRIM(output_folder(f)) // 'evuot_res.dat',action='write',status='old',position='append')
 write(100,101) (INT(output_data(j)),j=1,6),(output_data(j),j=7,9),INT(output_data(10)), &
                (output_data(j),j=11,14),(INT(output_data(j)),j=15,18),output_data(19),  &
                (INT(output_data(j)),j=20,23),(output_data(j),j=24,36)
 CLOSE(100)
END SUBROUTINE SAVE_DATA
