!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.12 (r6213) - 13 Oct 2016 10:54
!
!  Differentiation of salfa in forward (tangent) mode:
!   variations   of useful results: cfak
!   with respect to varying inputs: plat ppit
!END OF the acutal subroutine that does the work <---------------------
!OTHER SUBROUTINES
SUBROUTINE SALFA_DV(ivv, ikk, ipa, iklo, plat, platd, ppit, ppitd, ppp, &
& sinal, sinfii, cosfii, cfak, cfakd, nbdirs)
  USE DIFFSIZES
!  Hint: nbdirsmax should be the maximum number of differentiation directions
  IMPLICIT NONE
!input variables
  INTEGER, INTENT(IN) :: ivv, ikk, ipa, iklo
  REAL, INTENT(IN) :: plat, ppit
  REAL, DIMENSION(nbdirsmax), INTENT(IN) :: platd, ppitd
!output variables
  REAL, INTENT(OUT) :: ppp, sinal, sinfii, cosfii, cfak
  REAL, DIMENSION(nbdirsmax), INTENT(OUT) :: cfakd
!local variables
  INTEGER, DIMENSION(12) :: ipaiv
  INTEGER :: ipv
  REAL :: rad, rlat, rpv, s, decl, rdecl, pp, rl, dklo, h, hh
  REAL, DIMENSION(nbdirsmax) :: rlatd, rld, hd, hhd
  INTRINSIC MOD
  INTRINSIC REAL
  INTRINSIC SIN
  INTRINSIC COS
  INTRINSIC SQRT
  INTRINSIC ASIN
  REAL :: arg1
  REAL :: arg2
  REAL :: arg3
  REAL :: arg4
  INTEGER :: arg10
  REAL :: arg11
  REAL :: result1
  REAL, DIMENSION(nbdirsmax) :: result1d
  INTEGER :: nd
  INTEGER :: nbdirs
  REAL :: pppd(nbdirsmax)
  REAL :: sinald(nbdirsmax)
!days passed when the month changes
  ipaiv = (/0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334/)
!radians / degrees
  rad = 0.0174522925
  DO nd=1,nbdirs
!latitude to radians
    rlatd(nd) = rad*platd(nd)
  END DO
  rlat = rad*plat
!leap year check
  ipv = ipa + ipaiv(ikk)
  IF (ikk .GE. 3 .AND. MOD(ivv, 4) .EQ. 0) ipv = ipv + 1
!day to float
  rpv = REAL(ipv)
  s = 0.0171672
!declination in degrees
  arg1 = s*rpv
  arg2 = s*rpv
  decl = 0.33281 + 3.7872*SIN(arg1) - 22.984*COS(arg2)
!declination in radians
  rdecl = rad*decl
  arg1 = s*rpv
  arg2 = s*rpv
  arg3 = 2.0*s*rpv
  arg4 = 2.0*s*rpv
  pp = -(0.1229*SIN(arg1)) + 0.0072*COS(arg2) - 0.1565*SIN(arg3) - &
&   0.0528*COS(arg4)
  rl = 24.0/360.0*(30.0-ppit)
  ppp = pp - rl
  arg10 = iklo - iklo/100*100
  dklo = REAL(arg10)/60.0 + REAL(iklo/100)
  h = 360.0/24.0*(dklo-12.0+ppp)
  hh = rad*h
  sinal = SIN(rdecl)*SIN(rlat) + COS(rdecl)*COS(rlat)*COS(hh)
  DO nd=1,nbdirs
    rld(nd) = -(24.0*ppitd(nd)/360.0)
    pppd(nd) = -rld(nd)
    hd(nd) = 360.0*pppd(nd)/24.0
    hhd(nd) = rad*hd(nd)
    sinald(nd) = SIN(rdecl)*rlatd(nd)*COS(rlat) + COS(rdecl)*(-(rlatd(nd&
&     )*SIN(rlat)*COS(hh))-COS(rlat)*hhd(nd)*SIN(hh))
!solar elevation in degrees
    IF (sinal .EQ. 1.0 .OR. sinal .EQ. (-1.0)) THEN
      result1d(nd) = 0.0
    ELSE
      result1d(nd) = sinald(nd)/SQRT(1.0-sinal**2)
    END IF
    cfakd(nd) = 57.29578*result1d(nd)
  END DO
  arg11 = 1.0 - sinal**2
  result1 = SQRT(arg11)
  sinfii = COS(rdecl)/result1*SIN(hh)
  arg1 = 1 - sinal**2
  result1 = SQRT(arg1)
  cosfii = (sinal*SIN(rlat)-SIN(rdecl))/(result1*COS(rlat))
  result1 = ASIN(sinal)
  cfak = result1*57.29578
END SUBROUTINE SALFA_DV
